/*
 * Decompiled with CFR 0.152.
 */
package net.aubrecht.letadylko;

import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.GameSettings;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.particle.ParticleComponent;
import com.almasb.fxgl.ui.ProgressBar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.util.Duration;
import net.aubrecht.letadylko.Effects;

public class LetadylkoMain
extends GameApplication {
    private final Random rand = new Random();
    private static final double DESCEND_SPEED = 12.0;
    private static final double MOVE_UP_AMOUNT = -0.5;
    private static final double FUEL_CONSUMPTION = 0.025;
    private static final double INITIAL_FUEL = 100.0;
    private static final double INITIAL_FLIGHT_SPEED = 25.0;
    public static final String FUEL_PROPERTY = "fuel";
    public static final String STARS_PROPERTY = "coins";
    public static final String DISTANCE_PROPERTY = "distance";
    public static final String SPEED_PROPERTY = "speed";
    public static final String ACCELERATED_PROPERTY = "accelerated";
    private static final double FUEL_TANK_EARNS = 50.0;
    private static final int MOVE_RIGHT_SPEED = 2;
    private static final double MOVE_LEFT_SPEED = -0.2;
    private static final int PERIOD_ACCELERATION = 100;
    private static final double ACCELERATION_AMOUNT = 2.0;
    private ParticleComponent engineFireComponent;
    private boolean isEngineWorking;
    private boolean isFlying;
    Entity player;
    private List<Entity> starsAndFuel;
    private List<Entity> clouds;

    @Override
    protected void initSettings(GameSettings settings) {
        settings.setWidth(800);
        settings.setHeight(600);
        settings.setTitle("Letadylko");
        settings.setVersion("1.0");
        settings.setIntroEnabled(false);
        settings.setMenuEnabled(true);
    }

    @Override
    protected void initGameVars(Map<String, Object> vars) {
        vars.put(FUEL_PROPERTY, 100.0);
        vars.put(STARS_PROPERTY, 0);
        vars.put(DISTANCE_PROPERTY, 0.0);
        vars.put(SPEED_PROPERTY, 25.0);
        vars.put(ACCELERATED_PROPERTY, 1.0);
    }

    @Override
    protected void initGame() {
        this.createAirplaneFireEffect();
        this.player = FXGL.entityBuilder().type(EntityType.PLAYER).at(30.0, 100.0).viewWithBBox("letadylko.png").with(this.engineFireComponent).collidable().buildAndAttach();
        this.isEngineWorking = true;
        this.isFlying = true;
        this.starsAndFuel = new ArrayList<Entity>();
        Entity star = FXGL.entityBuilder().type(EntityType.STAR).at(500.0, 100.0).viewWithBBox("star.png").collidable().buildAndAttach();
        this.starsAndFuel.add(star);
        this.clouds = new ArrayList<Entity>();
    }

    @Override
    protected void onUpdate(double tpf) {
        double beyondBottom;
        if (!this.isFlying) {
            return;
        }
        this.player.translateY(tpf * 12.0);
        if (this.player.getY() < 0.0) {
            this.player.setY(0.0);
        }
        if ((beyondBottom = (double)FXGL.getAppHeight() - this.player.getBottomY()) < 0.0) {
            this.player.translateY(beyondBottom);
            this.handleFinishOfGame();
        }
        ArrayList<Entity> deleteStars = new ArrayList<Entity>();
        for (Entity entity : this.starsAndFuel) {
            entity.translateX(-1.0 * tpf * FXGL.getGameState().getDouble(SPEED_PROPERTY));
            if (!(entity.getRightX() < 0.0)) continue;
            entity.removeFromWorld();
            deleteStars.add(entity);
        }
        for (Entity entity : deleteStars) {
            this.starsAndFuel.remove(entity);
        }
        ArrayList<Entity> deleteClouds = new ArrayList<Entity>();
        for (Entity cloud : this.clouds) {
            cloud.translateX(-1.0 * tpf * FXGL.getGameState().getDouble(SPEED_PROPERTY));
            if (!(cloud.getRightX() < 0.0)) continue;
            cloud.removeFromWorld();
            deleteClouds.add(cloud);
        }
        for (Entity deleteCloud : deleteClouds) {
            this.clouds.remove(deleteCloud);
        }
        if (this.starsAndFuel.size() < 1) {
            int n = this.rand.nextInt(5);
            Entity object = n > 2 ? FXGL.entityBuilder().type(EntityType.STAR).at(FXGL.getAppWidth(), this.rand.nextInt(FXGL.getAppHeight() - 100) + 20).viewWithBBox("star.png").collidable().buildAndAttach() : FXGL.entityBuilder().type(EntityType.FUEL).at(FXGL.getAppWidth(), this.rand.nextInt(FXGL.getAppHeight() - 100) + 20).viewWithBBox("fuel.jpg").collidable().buildAndAttach();
            this.starsAndFuel.add(object);
        }
        if (this.rand.nextInt(1300) == 42) {
            this.clouds.add(FXGL.entityBuilder().type(EntityType.CLOUD).at(FXGL.getAppWidth(), this.rand.nextInt(FXGL.getAppHeight() - 300)).viewWithBBox("cloud.png").collidable().buildAndAttach());
        }
        FXGL.getGameState().increment(DISTANCE_PROPERTY, tpf * FXGL.getGameState().getDouble(SPEED_PROPERTY) / 25.0);
        if (FXGL.getGameState().getDouble(DISTANCE_PROPERTY) > 100.0 * FXGL.getGameState().getDouble(ACCELERATED_PROPERTY)) {
            FXGL.getGameState().increment(ACCELERATED_PROPERTY, 1.0);
            FXGL.getGameState().increment(SPEED_PROPERTY, 2.0);
            FXGL.getNotificationService().pushNotification("Speed Increase: " + FXGL.getGameState().getDouble(SPEED_PROPERTY));
        }
    }

    @Override
    protected void initInput() {
        Input input = FXGL.getInput();
        input.addAction(new UserAction("move right"){

            @Override
            protected void onAction() {
                if (FXGL.getGameState().getDouble(LetadylkoMain.FUEL_PROPERTY) > 0.0) {
                    LetadylkoMain.this.player.translateX(2.0);
                    if (LetadylkoMain.this.player.getRightX() > (double)FXGL.getAppWidth()) {
                        LetadylkoMain.this.player.setX((double)FXGL.getAppWidth() - LetadylkoMain.this.player.getWidth());
                    }
                }
            }
        }, KeyCode.D);
        input.addAction(new UserAction("move left"){

            @Override
            protected void onAction() {
                if (FXGL.getGameState().getDouble(LetadylkoMain.FUEL_PROPERTY) > 0.0) {
                    LetadylkoMain.this.player.translateX(-0.2);
                    if (LetadylkoMain.this.player.getX() < 0.0) {
                        LetadylkoMain.this.player.setX(0.0);
                    }
                }
            }
        }, KeyCode.A);
        input.addAction(new UserAction("move up"){

            @Override
            protected void onAction() {
                Double fuel = FXGL.getGameState().getDouble(LetadylkoMain.FUEL_PROPERTY);
                if (fuel > 0.0) {
                    LetadylkoMain.this.player.translateY(-0.5);
                    FXGL.getGameState().increment(LetadylkoMain.FUEL_PROPERTY, -0.025);
                } else {
                    LetadylkoMain.this.player.removeComponent(LetadylkoMain.this.engineFireComponent.getClass());
                    LetadylkoMain.this.isEngineWorking = false;
                }
            }
        }, KeyCode.SPACE);
    }

    @Override
    protected void initUI() {
        ProgressBar progressBar = new ProgressBar();
        progressBar.currentValueProperty().bind(FXGL.getGameState().doubleProperty(FUEL_PROPERTY));
        FXGL.getGameScene().addUINode(progressBar);
        Text textCoins = FXGL.getUIFactory().newText("0", Color.BLACK, 22.0);
        textCoins.setTranslateX(220.0);
        textCoins.setTranslateY(20.0);
        textCoins.textProperty().bind(FXGL.getGameState().intProperty(STARS_PROPERTY).asString("Stars: %d"));
        FXGL.getGameScene().addUINode(textCoins);
        Text textDistance = FXGL.getUIFactory().newText("0", Color.BLACK, 22.0);
        textDistance.setTranslateX(500.0);
        textDistance.setTranslateY(20.0);
        textDistance.textProperty().bind(FXGL.getGameState().doubleProperty(DISTANCE_PROPERTY).asString("Distance: %,.1f km"));
        FXGL.getGameScene().addUINode(textDistance);
    }

    @Override
    protected void initPhysics() {
        FXGL.onCollisionCollectible(EntityType.PLAYER, EntityType.STAR, star -> {
            this.starsAndFuel.remove(star);
            FXGL.getGameState().increment(STARS_PROPERTY, 1);
            FXGL.getNotificationService().pushNotification("Gotcha!");
        });
        FXGL.onCollisionCollectible(EntityType.PLAYER, EntityType.FUEL, fuel -> {
            this.starsAndFuel.remove(fuel);
            double newFuel = Math.min(FXGL.getGameState().doubleProperty(FUEL_PROPERTY).getValue() + 50.0, 100.0);
            FXGL.getGameState().setValue(FUEL_PROPERTY, newFuel);
            if (!this.isEngineWorking) {
                this.createAirplaneFireEffect();
                this.player.addComponent(this.engineFireComponent);
                this.isEngineWorking = true;
            }
            FXGL.getNotificationService().pushNotification("Tanked");
        });
        FXGL.onCollision(EntityType.PLAYER, EntityType.CLOUD, (player, cloud) -> this.handleFinishOfGame());
    }

    private void createAirplaneFireEffect() {
        this.engineFireComponent = Effects.createAirplaneFire();
    }

    private void handleFinishOfGame() {
        if (this.isFlying) {
            if (this.isEngineWorking) {
                this.player.removeComponent(this.engineFireComponent.getClass());
            }
            Entity explosion = new Entity();
            explosion.setPosition(this.player.getPosition());
            explosion.addComponent(Effects.createAirplaneExplosion());
            FXGL.getGameWorld().addEntity(explosion);
            FXGL.getEngineTimer().runOnceAfter(() -> FXGL.showMessage(FXGL.getGameState().getInt(STARS_PROPERTY) + " stars achieved", () -> FXGL.getGameController().gotoMainMenu()), Duration.seconds(2.0));
        }
        this.isFlying = false;
    }

    public static void main(String[] args) {
        LetadylkoMain.launch(args);
    }

    public static enum EntityType {
        PLAYER,
        FUEL,
        STAR,
        CLOUD;

    }
}

