/*
 * Decompiled with CFR 0.152.
 */
package net.aubrecht.letadylko;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.particle.ParticleComponent;
import com.almasb.fxgl.particle.ParticleEmitter;
import com.almasb.fxgl.particle.ParticleEmitters;
import javafx.geometry.Point2D;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class Effects {
    public static ParticleComponent createAirplaneFire() {
        ParticleEmitter engineFireEmitter = ParticleEmitters.newFireEmitter();
        engineFireEmitter.setSize(2.0, 4.0);
        engineFireEmitter.setStartColor(Color.YELLOW);
        engineFireEmitter.setEndColor(Color.RED);
        engineFireEmitter.setBlendMode(BlendMode.SRC_OVER);
        engineFireEmitter.setVelocityFunction(i -> new Point2D(FXGL.random() * -1.0 * 60.0, FXGL.random(-0.5, 0.5) * 0.25 * 60.0));
        engineFireEmitter.setExpireFunction(i -> Duration.seconds(1.0));
        engineFireEmitter.setSpawnPointFunction(i -> new Point2D(0.0, 16.0));
        return new ParticleComponent(engineFireEmitter);
    }

    public static ParticleComponent createAirplaneExplosion() {
        ParticleEmitter airplaneExplosionEmitter = ParticleEmitters.newExplosionEmitter(100);
        airplaneExplosionEmitter.setStartColor(Color.RED);
        airplaneExplosionEmitter.setEndColor(Color.YELLOW);
        airplaneExplosionEmitter.setVelocityFunction(i -> Vec2.fromAngle(i * 10).mulLocal(FXGLMath.random(50.0, 50.0)).toPoint2D());
        airplaneExplosionEmitter.setExpireFunction(i -> Duration.seconds(2.0));
        airplaneExplosionEmitter.setSpawnPointFunction(i -> new Point2D(30.0, 15.0));
        airplaneExplosionEmitter.setSize(5.0, 10.0);
        airplaneExplosionEmitter.setNumParticles(200);
        airplaneExplosionEmitter.setBlendMode(BlendMode.SRC_OVER);
        return new ParticleComponent(airplaneExplosionEmitter);
    }
}

