/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.effect;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.effect.Identity;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;

public class ImageInput
extends Effect {
    private ObjectProperty<Image> source;
    private final AbstractNotifyListener platformImageChangeListener = new AbstractNotifyListener(){

        @Override
        public void invalidated(Observable observable2) {
            ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
            ImageInput.this.effectBoundsChanged();
        }
    };
    private Image oldImage;
    private DoubleProperty x;
    private DoubleProperty y;

    public ImageInput() {
    }

    public ImageInput(Image image2) {
        this.setSource(image2);
    }

    public ImageInput(Image image2, double d, double d2) {
        this.setSource(image2);
        this.setX(d);
        this.setY(d2);
    }

    @Override
    Identity createPeer() {
        return new Identity(null);
    }

    public final void setSource(Image image2) {
        this.sourceProperty().set(image2);
    }

    public final Image getSource() {
        return this.source == null ? null : (Image)this.source.get();
    }

    public final ObjectProperty<Image> sourceProperty() {
        if (this.source == null) {
            this.source = new ObjectPropertyBase<Image>(){
                private boolean needsListeners = false;

                @Override
                public void invalidated() {
                    Image image2 = (Image)this.get();
                    Toolkit.ImageAccessor imageAccessor = Toolkit.getImageAccessor();
                    if (this.needsListeners) {
                        imageAccessor.getImageProperty(ImageInput.this.oldImage).removeListener(ImageInput.this.platformImageChangeListener.getWeakListener());
                    }
                    this.needsListeners = image2 != null && (imageAccessor.isAnimation(image2) || image2.getProgress() < 1.0);
                    ImageInput.this.oldImage = image2;
                    if (this.needsListeners) {
                        imageAccessor.getImageProperty(image2).addListener(ImageInput.this.platformImageChangeListener.getWeakListener());
                    }
                    ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ImageInput.this.effectBoundsChanged();
                }

                @Override
                public Object getBean() {
                    return ImageInput.this;
                }

                @Override
                public String getName() {
                    return "source";
                }
            };
        }
        return this.source;
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ImageInput.this.effectBoundsChanged();
                }

                @Override
                public Object getBean() {
                    return ImageInput.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public void invalidated() {
                    ImageInput.this.markDirty(EffectDirtyBits.EFFECT_DIRTY);
                    ImageInput.this.effectBoundsChanged();
                }

                @Override
                public Object getBean() {
                    return ImageInput.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    @Override
    void update() {
        Identity identity = (Identity)this.getPeer();
        Image image2 = this.getSource();
        if (image2 != null && Toolkit.getImageAccessor().getPlatformImage(image2) != null) {
            identity.setSource(Toolkit.getToolkit().toFilterable(image2));
        } else {
            identity.setSource(null);
        }
        identity.setLocation(new Point2D((float)this.getX(), (float)this.getY()));
    }

    @Override
    boolean checkChainContains(Effect effect) {
        return false;
    }

    @Override
    BaseBounds getBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node, BoundsAccessor boundsAccessor) {
        Image image2 = this.getSource();
        if (image2 != null && Toolkit.getImageAccessor().getPlatformImage(image2) != null) {
            float f = (float)this.getX();
            float f2 = (float)this.getY();
            float f3 = (float)image2.getWidth();
            float f4 = (float)image2.getHeight();
            RectBounds rectBounds = new RectBounds(f, f2, f + f3, f2 + f4);
            return ImageInput.transformBounds(baseTransform, rectBounds);
        }
        return new RectBounds();
    }

    @Override
    Effect copy() {
        return new ImageInput(this.getSource(), this.getX(), this.getY());
    }
}

