/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.util.impl;

import com.gluonhq.attach.util.Platform;
import com.gluonhq.attach.util.impl.ServiceFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultServiceFactory<T>
implements ServiceFactory<T> {
    private static final Logger LOGGER = Logger.getLogger(DefaultServiceFactory.class.getName());
    private final Class<T> serviceType;
    private T instance;

    public DefaultServiceFactory(Class<T> serviceType) {
        this.serviceType = serviceType;
    }

    @Override
    public Class<T> getServiceType() {
        return this.serviceType;
    }

    @Override
    public Optional<T> getInstance() {
        if (this.instance == null) {
            this.instance = this.createInstance(Platform.getCurrent());
        }
        return Optional.ofNullable(this.instance);
    }

    private T createInstance(Platform platform) {
        String fqn = this.serviceType.getPackageName() + ".impl." + this.className(platform);
        try {
            Class<?> clazz = Class.forName(fqn);
            if (clazz != null) {
                LOGGER.fine("Service class for: " + clazz.getName());
                return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, "No new instance for " + this.serviceType);
        }
        return null;
    }

    private String className(Platform platform) {
        return platform.getName() + this.serviceType.getSimpleName();
    }
}

