/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.sslogger;

import com.almasb.sslogger.DefaultMessageFormatter;
import com.almasb.sslogger.Logger$Companion$WhenMappings;
import com.almasb.sslogger.LoggerConfig;
import com.almasb.sslogger.LoggerLevel;
import com.almasb.sslogger.LoggerOutput;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\t\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000fJ'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J'\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000fJ'\u0010\u0016\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00032\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/sslogger/Logger;", "", "name", "", "(Ljava/lang/String;)V", "debug", "", "message", "debugf", "format", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "errorTraceAsString", "e", "", "fatal", "error", "fatalf", "info", "infof", "warning", "warningf", "Companion", "sslogger"})
public final class Logger {
    private final String name;
    private static final ArrayList<LoggerOutput> outputs;
    private static final ArrayList<LoggerOutput> debug;
    private static final ArrayList<LoggerOutput> info;
    private static final ArrayList<LoggerOutput> warning;
    private static final ArrayList<LoggerOutput> fatal;
    private static LoggerConfig config;
    private static boolean configured;
    private static boolean closed;
    public static final Companion Companion;

    public final void info(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.INFO);
    }

    public final void infof(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull(format, "format");
        Intrinsics.checkParameterIsNotNull(args, "args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(format, *args)");
        String string2 = string;
        logger.info(string2);
    }

    public final void debug(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.DEBUG);
    }

    public final void debugf(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull(format, "format");
        Intrinsics.checkParameterIsNotNull(args, "args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(format, *args)");
        String string2 = string;
        logger.debug(string2);
    }

    public final void warning(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.WARNING);
    }

    public final void warning(@NotNull String message2, @NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(error, "error");
        this.warning(message2 + " Error: " + error);
    }

    public final void warningf(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull(format, "format");
        Intrinsics.checkParameterIsNotNull(args, "args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(format, *args)");
        String string2 = string;
        logger.warning(string2);
    }

    public final void fatal(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Logger.Companion.doLog(this.name, message2, LoggerLevel.FATAL);
    }

    public final void fatal(@NotNull String message2, @NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(error, "error");
        String trace = this.errorTraceAsString(error);
        this.fatal(message2 + '\n' + trace);
    }

    public final void fatalf(@NotNull String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull(format, "format");
        Intrinsics.checkParameterIsNotNull(args, "args");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        Logger logger = this;
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string, "java.lang.String.format(format, *args)");
        String string2 = string;
        logger.fatal(string2);
    }

    private final String errorTraceAsString(Throwable e) {
        StackTraceElement[] elements;
        StringBuilder sb = new StringBuilder();
        sb.append("\nFatal exception occurred: ").append(e.getClass().getCanonicalName()).append(" : ").append(e.getMessage() + '\n');
        for (StackTraceElement el : elements = e.getStackTrace()) {
            sb.append("E: ").append(el.toString()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    private Logger(String name) {
        this.name = name;
    }

    static {
        Companion = new Companion(null);
        outputs = new ArrayList();
        debug = new ArrayList();
        info = new ArrayList();
        warning = new ArrayList();
        fatal = new ArrayList();
        config = new LoggerConfig();
    }

    public /* synthetic */ Logger(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @JvmStatic
    public static final boolean isConfigured() {
        return Companion.isConfigured();
    }

    @JvmStatic
    public static final void configure(@NotNull LoggerConfig config) {
        Companion.configure(config);
    }

    @JvmStatic
    public static final void addOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
        Companion.addOutput(loggerOutput, level);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull String name) {
        return Companion.get(name);
    }

    @JvmStatic
    @NotNull
    public static final Logger get(@NotNull Class<?> caller) {
        return Companion.get(caller);
    }

    @JvmStatic
    public static final void close() {
        Companion.close();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u00020\u0011H\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0011\u0010\u001b\u001a\u00020\u001c\"\u0006\b\u0000\u0010\u001d\u0018\u0001H\u0086\bJ\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0019H\u0007J\b\u0010!\u001a\u00020\u0004H\u0007J \u0010\"\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/sslogger/Logger$Companion;", "", "()V", "closed", "", "config", "Lcom/almasb/sslogger/LoggerConfig;", "configured", "debug", "Ljava/util/ArrayList;", "Lcom/almasb/sslogger/LoggerOutput;", "Lkotlin/collections/ArrayList;", "fatal", "info", "outputs", "warning", "addOutput", "", "loggerOutput", "level", "Lcom/almasb/sslogger/LoggerLevel;", "close", "configure", "doLog", "loggerName", "", "loggerMessage", "get", "Lcom/almasb/sslogger/Logger;", "T", "caller", "Ljava/lang/Class;", "name", "isConfigured", "makeMessage", "sslogger"})
    public static final class Companion {
        @JvmStatic
        public final boolean isConfigured() {
            return configured;
        }

        @JvmStatic
        public final void configure(@NotNull LoggerConfig config) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(config, "config");
            boolean bl2 = bl = !configured;
            if (!bl) {
                boolean bl3 = false;
                String string = "Logger already configured";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            config = config.copy$sslogger();
            configured = true;
        }

        @JvmStatic
        public final void addOutput(@NotNull LoggerOutput loggerOutput, @NotNull LoggerLevel level) {
            Intrinsics.checkParameterIsNotNull(loggerOutput, "loggerOutput");
            Intrinsics.checkParameterIsNotNull((Object)level, "level");
            outputs.add(loggerOutput);
            switch (Logger$Companion$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    debug.add(loggerOutput);
                    info.add(loggerOutput);
                    warning.add(loggerOutput);
                    fatal.add(loggerOutput);
                    break;
                }
                case 2: {
                    info.add(loggerOutput);
                    warning.add(loggerOutput);
                    fatal.add(loggerOutput);
                    break;
                }
                case 3: {
                    warning.add(loggerOutput);
                    fatal.add(loggerOutput);
                    break;
                }
                case 4: {
                    fatal.add(loggerOutput);
                }
            }
        }

        private final void doLog(String loggerName, String loggerMessage, LoggerLevel level) {
            Lazy message2 = LazyKt.lazy((Function0)new Function0<String>(loggerName, loggerMessage, level){
                final /* synthetic */ String $loggerName;
                final /* synthetic */ String $loggerMessage;
                final /* synthetic */ LoggerLevel $level;

                @NotNull
                public final String invoke() {
                    return com.almasb.sslogger.Logger$Companion.access$makeMessage(Logger.Companion, this.$loggerName, this.$loggerMessage, this.$level);
                }
                {
                    this.$loggerName = string;
                    this.$loggerMessage = string2;
                    this.$level = loggerLevel;
                    super(0);
                }
            });
            switch (Logger$Companion$WhenMappings.$EnumSwitchMapping$1[level.ordinal()]) {
                case 1: {
                    Iterable $receiver$iv = debug;
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 2: {
                    Iterable $receiver$iv = info;
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 3: {
                    Iterable $receiver$iv = warning;
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
                case 4: {
                    Iterable $receiver$iv = fatal;
                    for (Object element$iv : $receiver$iv) {
                        LoggerOutput it = (LoggerOutput)element$iv;
                        boolean bl = false;
                        it.append((String)message2.getValue());
                    }
                    break;
                }
            }
        }

        private final String makeMessage(String loggerName, String loggerMessage, LoggerLevel level) {
            String time = LocalTime.now().format(config.getDateTimeFormatter());
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            String threadName = thread2.getName();
            DefaultMessageFormatter defaultMessageFormatter = config.getMessageFormatter();
            String string = time;
            Intrinsics.checkExpressionValueIsNotNull(string, "time");
            String string2 = threadName;
            Intrinsics.checkExpressionValueIsNotNull(string2, "threadName");
            return defaultMessageFormatter.makeMessage(string, string2, String.valueOf((Object)level), loggerName, loggerMessage);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull String name) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            return new Logger(name, null);
        }

        private final <T> Logger get() {
            int $i$f$get = 0;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this.get(Object.class);
        }

        @JvmStatic
        @NotNull
        public final Logger get(@NotNull Class<?> caller) {
            Intrinsics.checkParameterIsNotNull(caller, "caller");
            String string = caller.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull(string, "caller.simpleName");
            return this.get(string);
        }

        @JvmStatic
        public final void close() {
            boolean bl;
            boolean bl2 = bl = !closed;
            if (!bl) {
                boolean bl3 = false;
                String string = "Logger already closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable $receiver$iv = outputs;
            for (Object element$iv : $receiver$iv) {
                LoggerOutput p1 = (LoggerOutput)element$iv;
                boolean bl4 = false;
                p1.close();
            }
            closed = true;
        }

        private Companion() {
        }

        public static final /* synthetic */ String access$makeMessage(Companion $this, String loggerName, String loggerMessage, LoggerLevel level) {
            return $this.makeMessage(loggerName, loggerMessage, level);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

