/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.core.local.Local;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.core.util.Predicate;
import com.almasb.fxgl.ui.DialogFactory;
import com.almasb.fxgl.ui.FXGLButton;
import com.almasb.fxgl.ui.FXGLDialogFactory;
import com.almasb.fxgl.ui.FXGLUIConfig;
import java.util.Arrays;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J9\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J,\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J,\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J \u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u000eH\u0002\u00a8\u0006&"}, d2={"Lcom/almasb/fxgl/ui/FXGLDialogFactory;", "Lcom/almasb/fxgl/ui/DialogFactory;", "()V", "confirmationDialog", "Ljavafx/scene/layout/Pane;", "message", "", "callback", "Lcom/almasb/fxgl/core/util/Consumer;", "", "createMessage", "Ljavafx/scene/text/Text;", "customDialog", "content", "Ljavafx/scene/Node;", "Ljava/lang/Runnable;", "buttons", "", "Ljavafx/scene/control/Button;", "(Ljava/lang/String;Ljavafx/scene/Node;Ljava/lang/Runnable;[Ljavafx/scene/control/Button;)Ljavafx/scene/layout/Pane;", "errorDialog", "errorMessage", "error", "", "inputDialog", "filter", "Lcom/almasb/fxgl/core/util/Predicate;", "inputDialogWithCancel", "localizedStringProperty", "Ljavafx/beans/value/ObservableStringValue;", "key", "messageDialog", "progressDialog", "observable", "Ljavafx/beans/property/DoubleProperty;", "progressDialogIndeterminate", "wrap", "n", "fxgl-ui"})
public final class FXGLDialogFactory
implements DialogFactory {
    private final Text createMessage(String message2) {
        Text text = FXGLUIConfig.getUIFactory().newText(message2);
        Intrinsics.checkExpressionValueIsNotNull(text, "FXGLUIConfig.getUIFactory().newText(message)");
        return text;
    }

    private final Pane wrap(Node n) {
        StackPane wrapper = new StackPane(n);
        wrapper.setMinWidth(600.0);
        wrapper.setPadding(new Insets(20.0));
        wrapper.getStyleClass().add("dialog-border");
        return wrapper;
    }

    @Override
    @NotNull
    public Pane messageDialog(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        return this.messageDialog(message2, EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane messageDialog(@NotNull String message2, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Text text = this.createMessage(message2);
        Button btnOK = FXGLUIConfig.getUIFactory().newButton("");
        btnOK.textProperty().bind(this.localizedStringProperty("dialog.ok"));
        btnOK.setOnAction(new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Runnable $callback;

            public final void handle(ActionEvent it) {
                this.$callback.run();
            }
            {
                this.$callback = runnable;
            }
        });
        VBox vbox = new VBox(50.0, text, btnOK);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    @Override
    @NotNull
    public Pane confirmationDialog(@NotNull String message2, @NotNull Consumer<Boolean> callback) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Text text = this.createMessage(message2);
        FXGLButton btnYes = new FXGLButton();
        btnYes.textProperty().bind(this.localizedStringProperty("dialog.yes"));
        btnYes.setOnAction(new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                this.$callback.accept(true);
            }
            {
                this.$callback = consumer;
            }
        });
        FXGLButton btnNo = new FXGLButton();
        btnNo.textProperty().bind(this.localizedStringProperty("dialog.no"));
        btnNo.setOnAction(new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                this.$callback.accept(false);
            }
            {
                this.$callback = consumer;
            }
        });
        HBox hbox = new HBox(btnYes, btnNo);
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, text, hbox);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    @Override
    @NotNull
    public Pane inputDialog(@NotNull String message2, @NotNull Consumer<String> callback) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        return this.inputDialog(message2, inputDialog.1.INSTANCE, callback);
    }

    @Override
    @NotNull
    public Pane inputDialog(@NotNull String message2, @NotNull Predicate<String> filter, @NotNull Consumer<String> callback) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Text text = this.createMessage(message2);
        TextField field = new TextField();
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull(bounds, "text.layoutBounds");
        field.setMaxWidth(Math.max(bounds.getWidth(), 200.0));
        field.setFont(FXGLUIConfig.getUIFactory().newFont(18.0));
        FXGLButton btnOK = new FXGLButton("");
        btnOK.textProperty().bind(this.localizedStringProperty("dialog.ok"));
        field.textProperty().addListener((ChangeListener)new ChangeListener<String>(btnOK, filter){
            final /* synthetic */ FXGLButton $btnOK;
            final /* synthetic */ Predicate $filter;

            public final void changed(ObservableValue<? extends String> $noName_0, String $noName_1, String newInput) {
                String string = newInput;
                Intrinsics.checkExpressionValueIsNotNull(string, "newInput");
                CharSequence charSequence = string;
                FXGLButton fXGLButton = this.$btnOK;
                boolean bl = charSequence.length() == 0;
                fXGLButton.setDisable(bl || !this.$filter.test(newInput));
            }
            {
                this.$btnOK = fXGLButton;
                this.$filter = predicate;
            }
        });
        btnOK.setDisable(true);
        btnOK.setOnAction(new EventHandler<ActionEvent>(callback, field){
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ TextField $field;

            public final void handle(ActionEvent it) {
                this.$callback.accept(this.$field.getText());
            }
            {
                this.$callback = consumer;
                this.$field = textField;
            }
        });
        VBox vbox = new VBox(50.0, text, field, btnOK);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    @Override
    @NotNull
    public Pane inputDialogWithCancel(@NotNull String message2, @NotNull Predicate<String> filter, @NotNull Consumer<String> callback) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Text text = this.createMessage(message2);
        TextField field = new TextField();
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull(bounds, "text.layoutBounds");
        field.setMaxWidth(Math.max(bounds.getWidth(), 200.0));
        field.setFont(FXGLUIConfig.getUIFactory().newFont(18.0));
        Button btnOK = FXGLUIConfig.getUIFactory().newButton("");
        btnOK.textProperty().bind(this.localizedStringProperty("dialog.ok"));
        field.textProperty().addListener((ChangeListener)new ChangeListener<String>(btnOK, filter){
            final /* synthetic */ Button $btnOK;
            final /* synthetic */ Predicate $filter;

            public final void changed(ObservableValue<? extends String> $noName_0, String $noName_1, String newInput) {
                Button button = this.$btnOK;
                Intrinsics.checkExpressionValueIsNotNull(button, "btnOK");
                String string = newInput;
                Intrinsics.checkExpressionValueIsNotNull(string, "newInput");
                CharSequence charSequence = string;
                Button button2 = button;
                boolean bl = charSequence.length() == 0;
                button2.setDisable(bl || !this.$filter.test(newInput));
            }
            {
                this.$btnOK = button;
                this.$filter = predicate;
            }
        });
        Button button = btnOK;
        Intrinsics.checkExpressionValueIsNotNull(button, "btnOK");
        button.setDisable(true);
        btnOK.setOnAction(new EventHandler<ActionEvent>(callback, field){
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ TextField $field;

            public final void handle(ActionEvent it) {
                this.$callback.accept(this.$field.getText());
            }
            {
                this.$callback = consumer;
                this.$field = textField;
            }
        });
        Button btnCancel = FXGLUIConfig.getUIFactory().newButton("");
        btnCancel.textProperty().bind(this.localizedStringProperty("dialog.cancel"));
        btnCancel.setOnAction(new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Consumer $callback;

            public final void handle(ActionEvent it) {
                this.$callback.accept("");
            }
            {
                this.$callback = consumer;
            }
        });
        HBox hBox = new HBox(btnOK, btnCancel);
        hBox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, text, field, hBox);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull(error, "error");
        return this.errorDialog(error, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull(errorMessage, "errorMessage");
        return this.errorDialog(errorMessage, (Runnable)EmptyRunnable.INSTANCE);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull String errorMessage, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull(errorMessage, "errorMessage");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        return this.messageDialog("Error occurred: " + errorMessage, callback);
    }

    @Override
    @NotNull
    public Pane errorDialog(@NotNull Throwable error, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull(error, "error");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Text text = this.createMessage(error.toString());
        FXGLButton btnOK = new FXGLButton("");
        btnOK.textProperty().bind(this.localizedStringProperty("dialog.ok"));
        btnOK.setOnAction(new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Runnable $callback;

            public final void handle(ActionEvent it) {
                this.$callback.run();
            }
            {
                this.$callback = runnable;
            }
        });
        FXGLButton btnLog = new FXGLButton("LOG");
        btnLog.setOnAction(new EventHandler<ActionEvent>(callback){
            final /* synthetic */ Runnable $callback;

            public final void handle(ActionEvent it) {
                this.$callback.run();
            }
            {
                this.$callback = runnable;
            }
        });
        HBox hbox = new HBox(btnOK, btnLog);
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, text, hbox);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pane progressDialog(@NotNull String message2, @NotNull DoubleProperty observable2, @NotNull Runnable callback) {
        void listener2;
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(observable2, "observable");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        ProgressBar progress = new ProgressBar();
        progress.setPrefSize(200.0, 50.0);
        progress.progressProperty().bind(observable2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        listener2.element = new ChangeListener<Number>(progress, (Ref.ObjectRef)listener2, callback){
            final /* synthetic */ ProgressBar $progress;
            final /* synthetic */ Ref.ObjectRef $listener;
            final /* synthetic */ Runnable $callback;

            public final void changed(ObservableValue<? extends Number> $noName_0, Number $noName_1, Number value) {
                if (value.doubleValue() >= 1.0) {
                    this.$progress.progressProperty().unbind();
                    this.$progress.progressProperty().removeListener((ChangeListener)this.$listener.element);
                    this.$listener.element = null;
                    this.$callback.run();
                }
            }
            {
                this.$progress = progressBar;
                this.$listener = objectRef;
                this.$callback = runnable;
            }
        };
        progress.progressProperty().addListener((ChangeListener)listener2.element);
        Text text = this.createMessage(message2);
        VBox vbox = new VBox(50.0, text, progress);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    @Override
    @NotNull
    public Pane progressDialogIndeterminate(@NotNull String message2, @NotNull Runnable callback) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefSize(200.0, 200.0);
        Button btn = new Button();
        btn.setVisible(false);
        return this.customDialog(message2, progress, callback, btn);
    }

    @Override
    @NotNull
    public Pane customDialog(@NotNull String message2, @NotNull Node content, @NotNull Runnable callback, Button ... buttons) {
        Intrinsics.checkParameterIsNotNull(message2, "message");
        Intrinsics.checkParameterIsNotNull(content, "content");
        Intrinsics.checkParameterIsNotNull(callback, "callback");
        Intrinsics.checkParameterIsNotNull(buttons, "buttons");
        for (Button btn : buttons) {
            EventHandler<ActionEvent> handler = btn.getOnAction();
            btn.setOnAction(new EventHandler<ActionEvent>(callback, handler){
                final /* synthetic */ Runnable $callback;
                final /* synthetic */ EventHandler $handler;

                public final void handle(ActionEvent e) {
                    block0: {
                        this.$callback.run();
                        EventHandler eventHandler = this.$handler;
                        if (eventHandler == null) break block0;
                        eventHandler.handle((Event)e);
                    }
                }
                {
                    this.$callback = runnable;
                    this.$handler = eventHandler;
                }
            });
        }
        Text text = this.createMessage(message2);
        Node[] nodeArray = buttons;
        HBox hbox = new HBox(Arrays.copyOf(nodeArray, nodeArray.length));
        hbox.setAlignment(Pos.CENTER);
        VBox vbox = new VBox(50.0, text, content, hbox);
        vbox.setAlignment(Pos.CENTER);
        return this.wrap(vbox);
    }

    private final ObservableStringValue localizedStringProperty(String key) {
        return Local.localizedStringProperty(key);
    }
}

