/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.View;
import com.almasb.fxgl.texture.AnimatedTexture;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Pixel;
import com.almasb.fxgl.texture.Texture;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0000J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001dJ\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00002\u0006\u0010*\u001a\u00020,J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u0016\u0010-\u001a\u00020.2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u00106\u001a\u00020\u0000J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u00068"}, d2={"Lcom/almasb/fxgl/texture/Texture;", "Ljavafx/scene/image/ImageView;", "Lcom/almasb/fxgl/core/View;", "image", "Ljavafx/scene/image/Image;", "(Ljavafx/scene/image/Image;)V", "()V", "height", "", "getHeight", "()D", "width", "getWidth", "blend", "backgroundImage", "blendMode", "Ljavafx/scene/effect/BlendMode;", "brighter", "copy", "darker", "desaturate", "discolor", "dispose", "", "getNode", "Ljavafx/scene/Node;", "invert", "multiplyColor", "color", "Ljavafx/scene/paint/Color;", "onUpdate", "tpf", "replaceColor", "oldColor", "newColor", "saturate", "set", "other", "subTexture", "area", "Ljavafx/geometry/Rectangle2D;", "superTexture", "direction", "Ljavafx/geometry/HorizontalDirection;", "Ljavafx/geometry/VerticalDirection;", "toAnimatedTexture", "Lcom/almasb/fxgl/texture/AnimatedTexture;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "frames", "", "duration", "Ljavafx/util/Duration;", "toColor", "toGrayscale", "transparentColor", "fxgl-media"})
public class Texture
extends ImageView
implements View {
    public final double getWidth() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return image2.getWidth();
    }

    public final double getHeight() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return image2.getHeight();
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(int frames, @NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull(duration, "duration");
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return this.toAnimatedTexture(new AnimationChannel(image2, duration, frames));
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkParameterIsNotNull(defaultChannel, "defaultChannel");
        return new AnimatedTexture(defaultChannel);
    }

    @NotNull
    public final Texture copy() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(image2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Texture subTexture(@NotNull Rectangle2D area) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(area, "area");
        int minX = (int)area.getMinX();
        int minY = (int)area.getMinY();
        int maxX = (int)area.getMaxX();
        int maxY = (int)area.getMaxY();
        boolean bl2 = bl = minX >= 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "minX value of sub-texture cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = minY >= 0;
        if (!bl) {
            boolean bl5 = false;
            String string = "minY value of sub-texture cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d = maxX;
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        boolean bl6 = bl = d <= image2.getWidth();
        if (!bl) {
            boolean bl7 = false;
            String string = "maxX value of sub-texture cannot be greater than image width";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d2 = maxY;
        Image image3 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image3, "image");
        boolean bl8 = bl = d2 <= image3.getHeight();
        if (!bl) {
            boolean bl9 = false;
            String string = "maxY value of sub-texture cannot be greater than image height";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Image image4 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image4, "image");
        PixelReader pixelReader = image4.getPixelReader();
        WritableImage image5 = new WritableImage(maxX - minX, maxY - minY);
        PixelWriter pixelWriter = image5.getPixelWriter();
        int n = minY;
        int n2 = maxY;
        while (n < n2) {
            void y;
            int n3 = minX;
            int n4 = maxX;
            while (n3 < n4) {
                void x;
                Color color = pixelReader.getColor((int)x, (int)y);
                pixelWriter.setColor((int)(x - minX), (int)(y - minY), color);
                ++x;
            }
            ++y;
        }
        return new Texture(image5);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull HorizontalDirection direction) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
        Image leftImage = null;
        Image rightImage = null;
        if (direction == HorizontalDirection.LEFT) {
            Image image2 = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image2, "other.image");
            leftImage = image2;
            Image image3 = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image3, "this.image");
            rightImage = image3;
        } else {
            Image image4 = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image4, "this.image");
            leftImage = image4;
            Image image5 = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image5, "other.image");
            rightImage = image5;
        }
        int width = (int)(leftImage.getWidth() + rightImage.getWidth());
        int height = (int)Math.max(leftImage.getHeight(), rightImage.getHeight());
        PixelReader leftReader = leftImage.getPixelReader();
        PixelReader rightReader = rightImage.getPixelReader();
        WritableImage image6 = new WritableImage(width, height);
        PixelWriter pixelWriter = image6.getPixelWriter();
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void x;
                Color color = null;
                if ((double)x < leftImage.getWidth()) {
                    if ((double)y < leftImage.getHeight()) {
                        Color color2 = leftReader.getColor((int)x, (int)y);
                        Intrinsics.checkExpressionValueIsNotNull(color2, "leftReader.getColor(x, y)");
                        color = color2;
                    } else {
                        Color color3 = Color.TRANSPARENT;
                        Intrinsics.checkExpressionValueIsNotNull(color3, "Color.TRANSPARENT");
                        color = color3;
                    }
                } else if ((double)y < rightImage.getHeight()) {
                    Color color4 = rightReader.getColor((int)(x - (int)leftImage.getWidth()), (int)y);
                    Intrinsics.checkExpressionValueIsNotNull(color4, "rightReader.getColor(x -\u2026ftImage.width.toInt(), y)");
                    color = color4;
                } else {
                    Color color5 = Color.TRANSPARENT;
                    Intrinsics.checkExpressionValueIsNotNull(color5, "Color.TRANSPARENT");
                    color = color5;
                }
                pixelWriter.setColor((int)x, (int)y, color);
                ++x;
            }
            ++y;
        }
        return new Texture(image6);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull VerticalDirection direction) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        Intrinsics.checkParameterIsNotNull((Object)direction, "direction");
        Image topImage = null;
        Image bottomImage = null;
        if (direction == VerticalDirection.DOWN) {
            Image image2 = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image2, "this.image");
            topImage = image2;
            Image image3 = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image3, "other.image");
            bottomImage = image3;
        } else {
            Image image4 = other.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image4, "other.image");
            topImage = image4;
            Image image5 = this.getImage();
            Intrinsics.checkExpressionValueIsNotNull(image5, "this.image");
            bottomImage = image5;
        }
        int width = (int)Math.max(topImage.getWidth(), bottomImage.getWidth());
        int height = (int)(topImage.getHeight() + bottomImage.getHeight());
        PixelReader topReader = topImage.getPixelReader();
        PixelReader bottomReader = bottomImage.getPixelReader();
        WritableImage image6 = new WritableImage(width, height);
        PixelWriter pixelWriter = image6.getPixelWriter();
        int n = 0;
        int n2 = height;
        while (n < n2) {
            void y;
            int n3 = 0;
            int n4 = width;
            while (n3 < n4) {
                void x;
                Color color = null;
                if ((double)y < topImage.getHeight()) {
                    if ((double)x < topImage.getWidth()) {
                        Color color2 = topReader.getColor((int)x, (int)y);
                        Intrinsics.checkExpressionValueIsNotNull(color2, "topReader.getColor(x, y)");
                        color = color2;
                    } else {
                        Color color3 = Color.TRANSPARENT;
                        Intrinsics.checkExpressionValueIsNotNull(color3, "Color.TRANSPARENT");
                        color = color3;
                    }
                } else if ((double)x < bottomImage.getWidth()) {
                    Color color4 = bottomReader.getColor((int)x, (int)(y - (int)topImage.getHeight()));
                    Intrinsics.checkExpressionValueIsNotNull(color4, "bottomReader.getColor(x,\u2026 topImage.height.toInt())");
                    color = color4;
                } else {
                    Color color5 = Color.TRANSPARENT;
                    Intrinsics.checkExpressionValueIsNotNull(color5, "Color.TRANSPARENT");
                    color = color5;
                }
                pixelWriter.setColor((int)x, (int)y, color);
                ++x;
            }
            ++y;
        }
        return new Texture(image6);
    }

    @NotNull
    public final Texture toGrayscale() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, toGrayscale.1.INSTANCE));
    }

    @NotNull
    public final Texture invert() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, invert.1.INSTANCE));
    }

    @NotNull
    public final Texture brighter() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, brighter.1.INSTANCE));
    }

    @NotNull
    public final Texture darker() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, darker.1.INSTANCE));
    }

    @NotNull
    public final Texture saturate() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, saturate.1.INSTANCE));
    }

    @NotNull
    public final Texture desaturate() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, desaturate.1.INSTANCE));
    }

    @NotNull
    public final Texture discolor() {
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, discolor.1.INSTANCE));
    }

    @NotNull
    public final Texture multiplyColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(color){
            final /* synthetic */ Color $color;

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Color color = Color.color(it.getR() * this.$color.getRed(), it.getG() * this.$color.getGreen(), it.getB() * this.$color.getBlue(), it.getA() * this.$color.getOpacity());
                Intrinsics.checkExpressionValueIsNotNull(color, "Color.color(\n           \u2026* color.opacity\n        )");
                return it.copy(color);
            }
            {
                this.$color = color;
                super(1);
            }
        }));
    }

    @NotNull
    public final Texture toColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        Texture discolored = this.discolor();
        Texture colored = discolored.multiplyColor(color);
        discolored.dispose();
        return colored;
    }

    @NotNull
    public final Texture replaceColor(@NotNull Color oldColor, @NotNull Color newColor) {
        Intrinsics.checkParameterIsNotNull(oldColor, "oldColor");
        Intrinsics.checkParameterIsNotNull(newColor, "newColor");
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        Image newImage2 = ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(oldColor, newColor){
            final /* synthetic */ Color $oldColor;
            final /* synthetic */ Color $newColor;

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Color c = Intrinsics.areEqual(it.getColor(), this.$oldColor) ? this.$newColor : it.getColor();
                return it.copy(c);
            }
            {
                this.$oldColor = color;
                this.$newColor = color2;
                super(1);
            }
        });
        return new Texture(newImage2);
    }

    @NotNull
    public final Texture transparentColor(@NotNull Color color) {
        Intrinsics.checkParameterIsNotNull(color, "color");
        Color color2 = Color.TRANSPARENT;
        Intrinsics.checkExpressionValueIsNotNull(color2, "Color.TRANSPARENT");
        return this.replaceColor(color, color2);
    }

    @NotNull
    public final Texture blend(@NotNull Image backgroundImage, @NotNull BlendMode blendMode) {
        Intrinsics.checkParameterIsNotNull(backgroundImage, "backgroundImage");
        Intrinsics.checkParameterIsNotNull((Object)blendMode, "blendMode");
        Image image2 = this.getImage();
        Intrinsics.checkExpressionValueIsNotNull(image2, "image");
        return new Texture(ImagesKt.map(backgroundImage, image2, ImagesKt.operation(blendMode)));
    }

    public final void set(@NotNull Texture other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        this.setFitWidth(other.getFitWidth());
        this.setFitHeight(other.getFitHeight());
        this.setImage(other.getImage());
    }

    @Override
    public void onUpdate(double tpf) {
    }

    @Override
    @NotNull
    public Node getNode() {
        return this;
    }

    @Override
    public void dispose() {
        this.setImage(null);
    }

    public Texture(@NotNull Image image2) {
        Intrinsics.checkParameterIsNotNull(image2, "image");
        super(image2);
    }

    protected Texture() {
    }
}

