/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics.contacts;

import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.collision.ContactID;
import com.almasb.fxgl.physics.box2d.collision.Manifold;
import com.almasb.fxgl.physics.box2d.collision.ManifoldPoint;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.common.Transform;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactEdge;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

public abstract class Contact {
    public static final int ISLAND_FLAG = 1;
    public static final int TOUCHING_FLAG = 2;
    public static final int ENABLED_FLAG = 4;
    public static final int FILTER_FLAG = 8;
    public static final int BULLET_HIT_FLAG = 16;
    public static final int TOI_FLAG = 32;
    public int m_flags;
    public Contact m_prev;
    public Contact m_next;
    public ContactEdge m_nodeA = new ContactEdge();
    public ContactEdge m_nodeB = new ContactEdge();
    public Fixture m_fixtureA = null;
    public Fixture m_fixtureB = null;
    public int m_indexA;
    public int m_indexB;
    public final Manifold m_manifold = new Manifold();
    public float m_toiCount;
    public float m_toi;
    public float m_friction;
    public float m_restitution;
    public float m_tangentSpeed;
    protected final IWorldPool pool;
    private final Manifold oldManifold = new Manifold();

    protected Contact(IWorldPool argPool) {
        this.pool = argPool;
    }

    public void init(Fixture fA, int indexA, Fixture fB, int indexB) {
        this.m_flags = 4;
        this.m_fixtureA = fA;
        this.m_fixtureB = fB;
        this.m_indexA = indexA;
        this.m_indexB = indexB;
        this.m_manifold.pointCount = 0;
        this.m_prev = null;
        this.m_next = null;
        this.m_nodeA.contact = null;
        this.m_nodeA.prev = null;
        this.m_nodeA.next = null;
        this.m_nodeA.other = null;
        this.m_nodeB.contact = null;
        this.m_nodeB.prev = null;
        this.m_nodeB.next = null;
        this.m_nodeB.other = null;
        this.m_toiCount = 0.0f;
        this.m_friction = Contact.mixFriction(fA.getFriction(), fB.getFriction());
        this.m_restitution = Contact.mixRestitution(fA.getRestitution(), fB.getRestitution());
        this.m_tangentSpeed = 0.0f;
    }

    public Manifold getManifold() {
        return this.m_manifold;
    }

    public boolean isTouching() {
        return (this.m_flags & 2) == 2;
    }

    public void setEnabled(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean isEnabled() {
        return (this.m_flags & 4) == 4;
    }

    public Contact getNext() {
        return this.m_next;
    }

    public Fixture getFixtureA() {
        return this.m_fixtureA;
    }

    public int getChildIndexA() {
        return this.m_indexA;
    }

    public Fixture getFixtureB() {
        return this.m_fixtureB;
    }

    public int getChildIndexB() {
        return this.m_indexB;
    }

    public void setFriction(float friction) {
        this.m_friction = friction;
    }

    public float getFriction() {
        return this.m_friction;
    }

    public void resetFriction() {
        this.m_friction = Contact.mixFriction(this.m_fixtureA.getFriction(), this.m_fixtureB.getFriction());
    }

    public void setRestitution(float restitution) {
        this.m_restitution = restitution;
    }

    public float getRestitution() {
        return this.m_restitution;
    }

    public void resetRestitution() {
        this.m_restitution = Contact.mixRestitution(this.m_fixtureA.getRestitution(), this.m_fixtureB.getRestitution());
    }

    public void setTangentSpeed(float speed) {
        this.m_tangentSpeed = speed;
    }

    public float getTangentSpeed() {
        return this.m_tangentSpeed;
    }

    public abstract void evaluate(Manifold var1, Transform var2, Transform var3);

    public void flagForFiltering() {
        this.m_flags |= 8;
    }

    public void update(ContactListener listener2) {
        boolean touching;
        this.oldManifold.set(this.m_manifold);
        this.m_flags |= 4;
        boolean wasTouching = (this.m_flags & 2) == 2;
        boolean sensorA = this.m_fixtureA.isSensor();
        boolean sensorB = this.m_fixtureB.isSensor();
        boolean sensor = sensorA || sensorB;
        Body bodyA = this.m_fixtureA.getBody();
        Body bodyB = this.m_fixtureB.getBody();
        Transform xfA = bodyA.getTransform();
        Transform xfB = bodyB.getTransform();
        if (sensor) {
            Shape shapeA = this.m_fixtureA.getShape();
            Shape shapeB = this.m_fixtureB.getShape();
            touching = this.pool.getCollision().testOverlap(shapeA, this.m_indexA, shapeB, this.m_indexB, xfA, xfB);
            this.m_manifold.pointCount = 0;
        } else {
            this.evaluate(this.m_manifold, xfA, xfB);
            touching = this.m_manifold.pointCount > 0;
            block0: for (int i = 0; i < this.m_manifold.pointCount; ++i) {
                ManifoldPoint mp2 = this.m_manifold.points[i];
                mp2.normalImpulse = 0.0f;
                mp2.tangentImpulse = 0.0f;
                ContactID id2 = mp2.id;
                for (int j = 0; j < this.oldManifold.pointCount; ++j) {
                    ManifoldPoint mp1 = this.oldManifold.points[j];
                    if (!mp1.id.isEqual(id2)) continue;
                    mp2.normalImpulse = mp1.normalImpulse;
                    mp2.tangentImpulse = mp1.tangentImpulse;
                    continue block0;
                }
            }
            if (touching != wasTouching) {
                bodyA.setAwake(true);
                bodyB.setAwake(true);
            }
        }
        this.m_flags = touching ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
        if (listener2 == null) {
            return;
        }
        if (!wasTouching && touching) {
            listener2.beginContact(this);
        }
        if (wasTouching && !touching) {
            listener2.endContact(this);
        }
        if (!sensor && touching) {
            listener2.preSolve(this, this.oldManifold);
        }
    }

    private static float mixFriction(float friction1, float friction2) {
        return JBoxUtils.sqrt(friction1 * friction2);
    }

    private static float mixRestitution(float restitution1, float restitution2) {
        return restitution1 > restitution2 ? restitution1 : restitution2;
    }
}

