/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.dynamics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhase;
import com.almasb.fxgl.physics.box2d.collision.shapes.MassData;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.common.Rotation;
import com.almasb.fxgl.physics.box2d.common.Sweep;
import com.almasb.fxgl.physics.box2d.common.Transform;
import com.almasb.fxgl.physics.box2d.dynamics.BodyDef;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.ContactEdge;
import com.almasb.fxgl.physics.box2d.dynamics.joints.JointEdge;
import java.util.ArrayList;
import java.util.List;

public final class Body {
    static final int e_islandFlag = 1;
    private static final int e_awakeFlag = 2;
    private static final int e_autoSleepFlag = 4;
    private static final int e_bulletFlag = 8;
    private static final int e_fixedRotationFlag = 16;
    private static final int e_activeFlag = 32;
    private final World world;
    private BodyType type;
    private List<Fixture> fixtures = new ArrayList<Fixture>();
    public JointEdge m_jointList = null;
    public ContactEdge m_contactList = null;
    public int m_flags = 0;
    public int m_islandIndex;
    public final Transform m_xf = new Transform();
    public final Transform m_xf0 = new Transform();
    public final Sweep m_sweep = new Sweep();
    public final Vec2 m_linearVelocity = new Vec2();
    private float m_angularVelocity;
    public final Vec2 m_force = new Vec2();
    private float m_torque = 0.0f;
    public float m_mass;
    public float m_invMass;
    private float m_I = 0.0f;
    public float m_invI = 0.0f;
    private float linearDamping;
    private float angularDamping;
    private float gravityScale;
    private float sleepTime = 0.0f;
    private Object userData;
    private Entity entity;
    private final FixtureDef fixDef = new FixtureDef();
    private final MassData pmd = new MassData();
    private final Transform pxf = new Transform();

    Body(BodyDef bd, World world) {
        this.checkValid(bd);
        this.world = world;
        this.userData = bd.getUserData();
        if (bd.isBullet()) {
            this.m_flags |= 8;
        }
        if (bd.isFixedRotation()) {
            this.m_flags |= 0x10;
        }
        if (bd.isAllowSleep()) {
            this.m_flags |= 4;
        }
        if (bd.isAwake()) {
            this.m_flags |= 2;
        }
        if (bd.isActive()) {
            this.m_flags |= 0x20;
        }
        this.m_xf.p.set(bd.getPosition());
        this.m_xf.q.set(bd.getAngle());
        this.m_sweep.localCenter.setZero();
        this.m_sweep.c0.set(this.m_xf.p);
        this.m_sweep.c.set(this.m_xf.p);
        this.m_sweep.a0 = bd.getAngle();
        this.m_sweep.a = bd.getAngle();
        this.m_sweep.alpha0 = 0.0f;
        this.m_linearVelocity.set(bd.getLinearVelocity());
        this.m_angularVelocity = bd.getAngularVelocity();
        this.linearDamping = bd.getLinearDamping();
        this.angularDamping = bd.getAngularDamping();
        this.gravityScale = bd.getGravityScale();
        this.type = bd.getType();
        if (this.type == BodyType.DYNAMIC) {
            this.m_mass = 1.0f;
            this.m_invMass = 1.0f;
        } else {
            this.m_mass = 0.0f;
            this.m_invMass = 0.0f;
        }
    }

    private void checkValid(BodyDef def) {
        if (def.getGravityScale() < 0.0f) {
            throw new IllegalArgumentException("Gravity scale is invalid");
        }
        if (def.getAngularDamping() < 0.0f) {
            throw new IllegalArgumentException("Angular damping is invalid");
        }
        if (def.getLinearDamping() < 0.0f) {
            throw new IllegalArgumentException("Linear damping is invalid");
        }
    }

    public float getTorque() {
        return this.m_torque;
    }

    public void setTorque(float torque) {
        this.m_torque = torque;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public List<Fixture> getFixtures() {
        return this.fixtures;
    }

    public Fixture createFixture(FixtureDef def) {
        this.world.assertNotLocked();
        Fixture fixture = new Fixture(this, def);
        if ((this.m_flags & 0x20) == 32) {
            BroadPhase broadPhase = this.world.getContactManager().broadPhase;
            fixture.createProxies(broadPhase, this.m_xf);
        }
        this.fixtures.add(fixture);
        if (fixture.getDensity() > 0.0f) {
            this.resetMassData();
        }
        this.world.notifyNewFixture();
        return fixture;
    }

    public Fixture createFixture(Shape shape, float density) {
        this.fixDef.setShape(shape);
        this.fixDef.setDensity(density);
        return this.createFixture(this.fixDef);
    }

    public void destroyFixture(Fixture fixture) {
        this.world.assertNotLocked();
        assert (fixture.getBody() == this);
        assert (this.fixtures.contains(fixture));
        this.fixtures.remove(fixture);
        ContactEdge edge = this.m_contactList;
        while (edge != null) {
            Contact c = edge.contact;
            edge = edge.next;
            Fixture fixtureA = c.getFixtureA();
            Fixture fixtureB = c.getFixtureB();
            if (fixture != fixtureA && fixture != fixtureB) continue;
            this.world.getContactManager().destroy(c);
        }
        if ((this.m_flags & 0x20) == 32) {
            BroadPhase broadPhase = this.world.getContactManager().broadPhase;
            fixture.destroyProxies(broadPhase);
        }
        fixture.destroy();
        this.resetMassData();
    }

    public void setTransform(Vec2 position, float angle) {
        this.world.assertNotLocked();
        this.m_xf.q.set(angle);
        this.m_xf.p.set(position);
        Transform.mulToOutUnsafe(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c);
        this.m_sweep.a = angle;
        this.m_sweep.c0.set(this.m_sweep.c);
        this.m_sweep.a0 = this.m_sweep.a;
        BroadPhase broadPhase = this.world.getContactManager().broadPhase;
        for (Fixture f : this.fixtures) {
            f.synchronize(broadPhase, this.m_xf, this.m_xf);
        }
    }

    public Transform getTransform() {
        return this.m_xf;
    }

    public Vec2 getPosition() {
        return this.m_xf.p;
    }

    public float getAngle() {
        return this.m_sweep.a;
    }

    public Vec2 getWorldCenter() {
        return this.m_sweep.c;
    }

    public Vec2 getLocalCenter() {
        return this.m_sweep.localCenter;
    }

    public void setLinearVelocity(Vec2 v) {
        if (this.type == BodyType.STATIC) {
            return;
        }
        if (Vec2.dot(v, v) > 0.0f) {
            this.setAwake(true);
        }
        this.m_linearVelocity.set(v);
    }

    public Vec2 getLinearVelocity() {
        return this.m_linearVelocity;
    }

    public void setAngularVelocity(float w) {
        if (this.type == BodyType.STATIC) {
            return;
        }
        if (w * w > 0.0f) {
            this.setAwake(true);
        }
        this.m_angularVelocity = w;
    }

    void setAngularVelocityDirectly(float angularVelocity) {
        this.m_angularVelocity = angularVelocity;
    }

    public float getAngularVelocity() {
        return this.m_angularVelocity;
    }

    public float getGravityScale() {
        return this.gravityScale;
    }

    public void setGravityScale(float gravityScale) {
        this.gravityScale = gravityScale;
    }

    public void applyForce(Vec2 force, Vec2 point) {
        this.applyForceToCenter(force);
        this.m_torque += (point.x - this.m_sweep.c.x) * force.y - (point.y - this.m_sweep.c.y) * force.x;
    }

    public void applyForceToCenter(Vec2 force) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_force.addLocal(force);
    }

    public void applyTorque(float torque) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_torque += torque;
    }

    public void applyLinearImpulse(Vec2 impulse, Vec2 point, boolean wake) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            if (wake) {
                this.setAwake(true);
            } else {
                return;
            }
        }
        this.m_linearVelocity.x += impulse.x * this.m_invMass;
        this.m_linearVelocity.y += impulse.y * this.m_invMass;
        this.m_angularVelocity += this.m_invI * ((point.x - this.m_sweep.c.x) * impulse.y - (point.y - this.m_sweep.c.y) * impulse.x);
    }

    public void applyAngularImpulse(float impulse) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.m_angularVelocity += this.m_invI * impulse;
    }

    public float getMass() {
        return this.m_mass;
    }

    public float getInertia() {
        return this.m_I + this.m_mass * Vec2.dot(this.m_sweep.localCenter, this.m_sweep.localCenter);
    }

    public void getMassData(MassData data) {
        data.mass = this.m_mass;
        data.I = this.getInertia();
        data.center.set(this.m_sweep.localCenter);
    }

    public void setMassData(MassData massData) {
        this.world.assertNotLocked();
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_mass = massData.mass;
        if (this.m_mass <= 0.0f) {
            this.m_mass = 1.0f;
        }
        this.m_invMass = 1.0f / this.m_mass;
        if (massData.I > 0.0f && (this.m_flags & 0x10) == 0) {
            this.m_I = massData.I - this.m_mass * Vec2.dot(massData.center, massData.center);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        }
        Vec2 oldCenter = this.world.getPool().popVec2();
        oldCenter.set(this.m_sweep.c);
        this.m_sweep.localCenter.set(massData.center);
        Transform.mulToOutUnsafe(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        Vec2 temp = this.world.getPool().popVec2();
        temp.set(this.m_sweep.c).subLocal(oldCenter);
        float tempY = this.m_angularVelocity * temp.x;
        temp.x = -this.m_angularVelocity * temp.y;
        temp.y = tempY;
        this.m_linearVelocity.addLocal(temp);
        this.world.getPool().pushVec2(2);
    }

    public void resetMassData() {
        this.m_mass = 0.0f;
        this.m_invMass = 0.0f;
        this.m_I = 0.0f;
        this.m_invI = 0.0f;
        this.m_sweep.localCenter.setZero();
        if (this.type == BodyType.STATIC || this.type == BodyType.KINEMATIC) {
            this.m_sweep.c0.set(this.m_xf.p);
            this.m_sweep.c.set(this.m_xf.p);
            this.m_sweep.a0 = this.m_sweep.a;
            return;
        }
        assert (this.type == BodyType.DYNAMIC);
        Vec2 localCenter = this.world.getPool().popVec2();
        localCenter.setZero();
        Vec2 temp = this.world.getPool().popVec2();
        MassData massData = this.pmd;
        for (Fixture f : this.fixtures) {
            if (f.getDensity() == 0.0f) continue;
            f.getMassData(massData);
            this.m_mass += massData.mass;
            temp.set(massData.center).mulLocal(massData.mass);
            localCenter.addLocal(temp);
            this.m_I += massData.I;
        }
        if (this.m_mass > 0.0f) {
            this.m_invMass = 1.0f / this.m_mass;
            localCenter.mulLocal(this.m_invMass);
        } else {
            this.m_mass = 1.0f;
            this.m_invMass = 1.0f;
        }
        if (this.m_I > 0.0f && (this.m_flags & 0x10) == 0) {
            this.m_I -= this.m_mass * Vec2.dot(localCenter, localCenter);
            assert (this.m_I > 0.0f);
            this.m_invI = 1.0f / this.m_I;
        } else {
            this.m_I = 0.0f;
            this.m_invI = 0.0f;
        }
        Vec2 oldCenter = this.world.getPool().popVec2();
        oldCenter.set(this.m_sweep.c);
        this.m_sweep.localCenter.set(localCenter);
        Transform.mulToOutUnsafe(this.m_xf, this.m_sweep.localCenter, this.m_sweep.c0);
        this.m_sweep.c.set(this.m_sweep.c0);
        temp.set(this.m_sweep.c).subLocal(oldCenter);
        Vec2 temp2 = oldCenter;
        Vec2.crossToOutUnsafe(this.m_angularVelocity, temp, temp2);
        this.m_linearVelocity.addLocal(temp2);
        this.world.getPool().pushVec2(3);
    }

    public Vec2 getWorldPoint(Vec2 localPoint) {
        Vec2 v = new Vec2();
        this.getWorldPointToOut(localPoint, v);
        return v;
    }

    public void getWorldPointToOut(Vec2 localPoint, Vec2 out) {
        Transform.mulToOut(this.m_xf, localPoint, out);
    }

    public Vec2 getWorldVector(Vec2 localVector) {
        Vec2 out = new Vec2();
        this.getWorldVectorToOut(localVector, out);
        return out;
    }

    public void getWorldVectorToOut(Vec2 localVector, Vec2 out) {
        Rotation.mulToOut(this.m_xf.q, localVector, out);
    }

    public void getWorldVectorToOutUnsafe(Vec2 localVector, Vec2 out) {
        Rotation.mulToOutUnsafe(this.m_xf.q, localVector, out);
    }

    public Vec2 getLocalPoint(Vec2 worldPoint) {
        Vec2 out = new Vec2();
        this.getLocalPointToOut(worldPoint, out);
        return out;
    }

    public void getLocalPointToOut(Vec2 worldPoint, Vec2 out) {
        Transform.mulTransToOut(this.m_xf, worldPoint, out);
    }

    public Vec2 getLocalVector(Vec2 worldVector) {
        Vec2 out = new Vec2();
        this.getLocalVectorToOut(worldVector, out);
        return out;
    }

    public void getLocalVectorToOut(Vec2 worldVector, Vec2 out) {
        Rotation.mulTrans(this.m_xf.q, worldVector, out);
    }

    public void getLocalVectorToOutUnsafe(Vec2 worldVector, Vec2 out) {
        Rotation.mulTransUnsafe(this.m_xf.q, worldVector, out);
    }

    public Vec2 getLinearVelocityFromWorldPoint(Vec2 worldPoint) {
        Vec2 out = new Vec2();
        this.getLinearVelocityFromWorldPointToOut(worldPoint, out);
        return out;
    }

    public void getLinearVelocityFromWorldPointToOut(Vec2 worldPoint, Vec2 out) {
        float tempX = worldPoint.x - this.m_sweep.c.x;
        float tempY = worldPoint.y - this.m_sweep.c.y;
        out.x = -this.m_angularVelocity * tempY + this.m_linearVelocity.x;
        out.y = this.m_angularVelocity * tempX + this.m_linearVelocity.y;
    }

    public Vec2 getLinearVelocityFromLocalPoint(Vec2 localPoint) {
        Vec2 out = new Vec2();
        this.getLinearVelocityFromLocalPointToOut(localPoint, out);
        return out;
    }

    public void getLinearVelocityFromLocalPointToOut(Vec2 localPoint, Vec2 out) {
        this.getWorldPointToOut(localPoint, out);
        this.getLinearVelocityFromWorldPointToOut(out, out);
    }

    public float getLinearDamping() {
        return this.linearDamping;
    }

    public void setLinearDamping(float linearDamping) {
        this.linearDamping = linearDamping;
    }

    public float getAngularDamping() {
        return this.angularDamping;
    }

    public void setAngularDamping(float angularDamping) {
        this.angularDamping = angularDamping;
    }

    public float getSleepTime() {
        return this.sleepTime;
    }

    void setSleepTime(float sleepTime) {
        this.sleepTime = sleepTime;
    }

    public BodyType getType() {
        return this.type;
    }

    public void setType(BodyType type) {
        this.world.assertNotLocked();
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.resetMassData();
        if (this.type == BodyType.STATIC) {
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            this.m_sweep.a0 = this.m_sweep.a;
            this.m_sweep.c0.set(this.m_sweep.c);
            this.synchronizeFixtures();
        }
        this.setAwake(true);
        this.m_force.setZero();
        this.m_torque = 0.0f;
        this.destroyAttachedContacts();
        BroadPhase broadPhase = this.world.getContactManager().broadPhase;
        for (Fixture f : this.fixtures) {
            int proxyCount = f.getProxyCount();
            for (int i = 0; i < proxyCount; ++i) {
                broadPhase.touchProxy(f.getProxyId(i));
            }
        }
    }

    void destroy() {
        this.destroyAttachedJoints();
        this.destroyAttachedContacts();
        this.destroyFixtures();
    }

    private void destroyAttachedJoints() {
        JointEdge je = this.m_jointList;
        while (je != null) {
            JointEdge je0 = je;
            je = je.next;
            if (this.world.getDestructionListener() != null) {
                this.world.getDestructionListener().onDestroy(je0.joint);
            }
            this.world.destroyJoint(je0.joint);
            this.m_jointList = je;
        }
        this.m_jointList = null;
    }

    private void destroyAttachedContacts() {
        ContactEdge ce = this.m_contactList;
        while (ce != null) {
            ContactEdge ce0 = ce;
            ce = ce.next;
            this.world.getContactManager().destroy(ce0.contact);
        }
        this.m_contactList = null;
    }

    private void destroyFixtures() {
        for (Fixture f : this.getFixtures()) {
            if (this.world.getDestructionListener() != null) {
                this.world.getDestructionListener().onDestroy(f);
            }
            f.destroyProxies(this.world.getContactManager().broadPhase);
            f.destroy();
        }
        this.getFixtures().clear();
    }

    public boolean isBullet() {
        return (this.m_flags & 8) == 8;
    }

    public void setBullet(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 8) : (this.m_flags &= 0xFFFFFFF7);
    }

    public void setSleepingAllowed(boolean flag) {
        if (flag) {
            this.m_flags |= 4;
        } else {
            this.m_flags &= 0xFFFFFFFB;
            this.setAwake(true);
        }
    }

    public boolean isSleepingAllowed() {
        return (this.m_flags & 4) == 4;
    }

    public void setAwake(boolean flag) {
        if (flag) {
            if ((this.m_flags & 2) == 0) {
                this.m_flags |= 2;
                this.sleepTime = 0.0f;
            }
        } else {
            this.m_flags &= 0xFFFFFFFD;
            this.sleepTime = 0.0f;
            this.m_linearVelocity.setZero();
            this.m_angularVelocity = 0.0f;
            this.m_force.setZero();
            this.m_torque = 0.0f;
        }
    }

    public boolean isAwake() {
        return (this.m_flags & 2) == 2;
    }

    public void setActive(boolean flag) {
        this.world.assertNotLocked();
        if (flag == this.isActive()) {
            return;
        }
        if (flag) {
            this.m_flags |= 0x20;
            BroadPhase broadPhase = this.world.getContactManager().broadPhase;
            for (Fixture f : this.fixtures) {
                f.createProxies(broadPhase, this.m_xf);
            }
        } else {
            this.m_flags &= 0xFFFFFFDF;
            BroadPhase broadPhase = this.world.getContactManager().broadPhase;
            for (Fixture f : this.fixtures) {
                f.destroyProxies(broadPhase);
            }
            this.destroyAttachedContacts();
        }
    }

    public boolean isActive() {
        return (this.m_flags & 0x20) == 32;
    }

    public void setFixedRotation(boolean flag) {
        this.m_flags = flag ? (this.m_flags |= 0x10) : (this.m_flags &= 0xFFFFFFEF);
        this.resetMassData();
    }

    public boolean isFixedRotation() {
        return (this.m_flags & 0x10) == 16;
    }

    public JointEdge getJointList() {
        return this.m_jointList;
    }

    public ContactEdge getContactList() {
        return this.m_contactList;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public World getWorld() {
        return this.world;
    }

    void synchronizeFixtures() {
        Transform xf1 = this.pxf;
        xf1.q.s = JBoxUtils.sin(this.m_sweep.a0);
        xf1.q.c = JBoxUtils.cos(this.m_sweep.a0);
        xf1.p.x = this.m_sweep.c0.x - xf1.q.c * this.m_sweep.localCenter.x + xf1.q.s * this.m_sweep.localCenter.y;
        xf1.p.y = this.m_sweep.c0.y - xf1.q.s * this.m_sweep.localCenter.x - xf1.q.c * this.m_sweep.localCenter.y;
        for (Fixture f : this.fixtures) {
            f.synchronize(this.world.getContactManager().broadPhase, xf1, this.m_xf);
        }
    }

    void synchronizeTransform() {
        this.m_xf.q.s = JBoxUtils.sin(this.m_sweep.a);
        this.m_xf.q.c = JBoxUtils.cos(this.m_sweep.a);
        Rotation q = this.m_xf.q;
        Vec2 v = this.m_sweep.localCenter;
        this.m_xf.p.x = this.m_sweep.c.x - q.c * v.x + q.s * v.y;
        this.m_xf.p.y = this.m_sweep.c.y - q.s * v.x - q.c * v.y;
    }

    public boolean shouldCollide(Body other) {
        if (this.type != BodyType.DYNAMIC && other.type != BodyType.DYNAMIC) {
            return false;
        }
        JointEdge jn = this.m_jointList;
        while (jn != null) {
            if (jn.other == other && !jn.joint.getCollideConnected()) {
                return false;
            }
            jn = jn.next;
        }
        return true;
    }

    void advance(float t) {
        this.m_sweep.advance(t);
        this.m_sweep.c.set(this.m_sweep.c0);
        this.m_sweep.a = this.m_sweep.a0;
        this.m_xf.q.set(this.m_sweep.a);
        Rotation.mulToOutUnsafe(this.m_xf.q, this.m_sweep.localCenter, this.m_xf.p);
        this.m_xf.p.mulLocal(-1.0).addLocal(this.m_sweep.c);
    }
}

