/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision.broadphase;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.callbacks.TreeCallback;
import com.almasb.fxgl.physics.box2d.callbacks.TreeRayCastCallback;
import com.almasb.fxgl.physics.box2d.collision.AABB;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.broadphase.BroadPhaseStrategy;
import com.almasb.fxgl.physics.box2d.collision.broadphase.DynamicTreeNode;
import com.almasb.fxgl.physics.box2d.common.JBoxSettings;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;

public class DynamicTree
implements BroadPhaseStrategy {
    private static final int NULL_NODE = -1;
    private DynamicTreeNode root = null;
    private DynamicTreeNode[] m_nodes = new DynamicTreeNode[16];
    private int m_nodeCount = 0;
    private int m_nodeCapacity = 16;
    private int m_freeList = 0;
    private DynamicTreeNode[] nodeStack = new DynamicTreeNode[20];
    private int nodeStackIndex = 0;
    private final Vec2 r = new Vec2();
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final AABB combinedAABB = new AABB();

    public DynamicTree() {
        for (int i = this.m_nodeCapacity - 1; i >= 0; --i) {
            this.m_nodes[i] = new DynamicTreeNode(i);
            this.m_nodes[i].parent = i == this.m_nodeCapacity - 1 ? null : this.m_nodes[i + 1];
            this.m_nodes[i].height = -1;
        }
    }

    @Override
    public final int createProxy(AABB aabb, Object userData) {
        DynamicTreeNode node = this.allocateNode();
        int proxyId = node.id;
        AABB nodeAABB = node.aabb;
        nodeAABB.lowerBound.x = aabb.lowerBound.x - JBoxSettings.aabbExtension;
        nodeAABB.lowerBound.y = aabb.lowerBound.y - JBoxSettings.aabbExtension;
        nodeAABB.upperBound.x = aabb.upperBound.x + JBoxSettings.aabbExtension;
        nodeAABB.upperBound.y = aabb.upperBound.y + JBoxSettings.aabbExtension;
        node.userData = userData;
        this.insertLeaf(proxyId);
        return proxyId;
    }

    @Override
    public final void destroyProxy(int proxyId) {
        DynamicTreeNode node = this.m_nodes[proxyId];
        this.removeLeaf(node);
        this.freeNode(node);
    }

    @Override
    public final boolean moveProxy(int proxyId, AABB aabb, Vec2 displacement) {
        DynamicTreeNode node = this.m_nodes[proxyId];
        AABB nodeAABB = node.aabb;
        if (nodeAABB.lowerBound.x <= aabb.lowerBound.x && nodeAABB.lowerBound.y <= aabb.lowerBound.y && aabb.upperBound.x <= nodeAABB.upperBound.x && aabb.upperBound.y <= nodeAABB.upperBound.y) {
            return false;
        }
        this.removeLeaf(node);
        Vec2 lowerBound = nodeAABB.lowerBound;
        Vec2 upperBound = nodeAABB.upperBound;
        lowerBound.x = aabb.lowerBound.x - JBoxSettings.aabbExtension;
        lowerBound.y = aabb.lowerBound.y - JBoxSettings.aabbExtension;
        upperBound.x = aabb.upperBound.x + JBoxSettings.aabbExtension;
        upperBound.y = aabb.upperBound.y + JBoxSettings.aabbExtension;
        float dx = displacement.x * JBoxSettings.aabbMultiplier;
        float dy = displacement.y * JBoxSettings.aabbMultiplier;
        if (dx < 0.0f) {
            lowerBound.x += dx;
        } else {
            upperBound.x += dx;
        }
        if (dy < 0.0f) {
            lowerBound.y += dy;
        } else {
            upperBound.y += dy;
        }
        this.insertLeaf(proxyId);
        return true;
    }

    @Override
    public final Object getUserData(int proxyId) {
        return this.m_nodes[proxyId].userData;
    }

    @Override
    public final AABB getFatAABB(int proxyId) {
        return this.m_nodes[proxyId].aabb;
    }

    @Override
    public final void query(TreeCallback callback, AABB aabb) {
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.root;
        while (this.nodeStackIndex > 0) {
            DynamicTreeNode node;
            if ((node = this.nodeStack[--this.nodeStackIndex]) == null || !AABB.testOverlap(node.aabb, aabb)) continue;
            if (node.child1 == null) {
                boolean proceed = callback.treeCallback(node.id);
                if (proceed) continue;
                return;
            }
            if (this.nodeStack.length - this.nodeStackIndex - 2 <= 0) {
                DynamicTreeNode[] newBuffer = new DynamicTreeNode[this.nodeStack.length * 2];
                System.arraycopy(this.nodeStack, 0, newBuffer, 0, this.nodeStack.length);
                this.nodeStack = newBuffer;
            }
            this.nodeStack[this.nodeStackIndex++] = node.child1;
            this.nodeStack[this.nodeStackIndex++] = node.child2;
        }
    }

    @Override
    public void raycast(TreeRayCastCallback callback, RayCastInput input) {
        Vec2 p1 = input.p1;
        Vec2 p2 = input.p2;
        float p1x = p1.x;
        float p2x = p2.x;
        float p1y = p1.y;
        float p2y = p2.y;
        this.r.x = p2x - p1x;
        this.r.y = p2y - p1y;
        assert (this.r.x * this.r.x + this.r.y * this.r.y > 0.0f);
        this.r.getLengthAndNormalize();
        float rx = this.r.x;
        float ry = this.r.y;
        float vx = -1.0f * ry;
        float vy = 1.0f * rx;
        float absVx = FXGLMath.abs(vx);
        float absVy = FXGLMath.abs(vy);
        float maxFraction = input.maxFraction;
        AABB segAABB = this.aabb;
        float tempx = (p2x - p1x) * maxFraction + p1x;
        float tempy = (p2y - p1y) * maxFraction + p1y;
        segAABB.lowerBound.x = p1x < tempx ? p1x : tempx;
        segAABB.lowerBound.y = p1y < tempy ? p1y : tempy;
        segAABB.upperBound.x = p1x > tempx ? p1x : tempx;
        segAABB.upperBound.y = p1y > tempy ? p1y : tempy;
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.root;
        while (this.nodeStackIndex > 0) {
            AABB nodeAABB;
            DynamicTreeNode node;
            if ((node = this.nodeStack[--this.nodeStackIndex]) == null || !AABB.testOverlap(nodeAABB = node.aabb, segAABB)) continue;
            float cx = (nodeAABB.lowerBound.x + nodeAABB.upperBound.x) * 0.5f;
            float cy = (nodeAABB.lowerBound.y + nodeAABB.upperBound.y) * 0.5f;
            float hx = (nodeAABB.upperBound.x - nodeAABB.lowerBound.x) * 0.5f;
            float hy = (nodeAABB.upperBound.y - nodeAABB.lowerBound.y) * 0.5f;
            tempx = p1x - cx;
            tempy = p1y - cy;
            float separation = FXGLMath.abs(vx * tempx + vy * tempy) - (absVx * hx + absVy * hy);
            if (separation > 0.0f) continue;
            if (node.child1 == null) {
                this.subInput.p1.x = p1x;
                this.subInput.p1.y = p1y;
                this.subInput.p2.x = p2x;
                this.subInput.p2.y = p2y;
                this.subInput.maxFraction = maxFraction;
                float value = callback.raycastCallback(this.subInput, node.id);
                if (value == 0.0f) {
                    return;
                }
                if (!(value > 0.0f)) continue;
                maxFraction = value;
                tempx = (p2x - p1x) * maxFraction + p1x;
                tempy = (p2y - p1y) * maxFraction + p1y;
                segAABB.lowerBound.x = p1x < tempx ? p1x : tempx;
                segAABB.lowerBound.y = p1y < tempy ? p1y : tempy;
                segAABB.upperBound.x = p1x > tempx ? p1x : tempx;
                segAABB.upperBound.y = p1y > tempy ? p1y : tempy;
                continue;
            }
            if (this.nodeStack.length - this.nodeStackIndex - 2 <= 0) {
                DynamicTreeNode[] newBuffer = new DynamicTreeNode[this.nodeStack.length * 2];
                System.arraycopy(this.nodeStack, 0, newBuffer, 0, this.nodeStack.length);
                this.nodeStack = newBuffer;
            }
            this.nodeStack[this.nodeStackIndex++] = node.child1;
            this.nodeStack[this.nodeStackIndex++] = node.child2;
        }
    }

    private DynamicTreeNode allocateNode() {
        if (this.m_freeList == -1) {
            DynamicTreeNode[] old = this.m_nodes;
            this.m_nodeCapacity *= 2;
            this.m_nodes = new DynamicTreeNode[this.m_nodeCapacity];
            System.arraycopy(old, 0, this.m_nodes, 0, old.length);
            for (int i = this.m_nodeCapacity - 1; i >= this.m_nodeCount; --i) {
                this.m_nodes[i] = new DynamicTreeNode(i);
                this.m_nodes[i].parent = i == this.m_nodeCapacity - 1 ? null : this.m_nodes[i + 1];
                this.m_nodes[i].height = -1;
            }
            this.m_freeList = this.m_nodeCount;
        }
        int nodeId = this.m_freeList;
        DynamicTreeNode treeNode = this.m_nodes[nodeId];
        this.m_freeList = treeNode.parent != null ? treeNode.parent.id : -1;
        treeNode.parent = null;
        treeNode.child1 = null;
        treeNode.child2 = null;
        treeNode.height = 0;
        treeNode.userData = null;
        ++this.m_nodeCount;
        return treeNode;
    }

    private void freeNode(DynamicTreeNode node) {
        node.parent = this.m_freeList != -1 ? this.m_nodes[this.m_freeList] : null;
        node.height = -1;
        this.m_freeList = node.id;
        --this.m_nodeCount;
    }

    private void insertLeaf(int leaf_index) {
        DynamicTreeNode leaf = this.m_nodes[leaf_index];
        if (this.root == null) {
            this.root = leaf;
            this.root.parent = null;
            return;
        }
        AABB leafAABB = leaf.aabb;
        DynamicTreeNode index = this.root;
        while (index.child1 != null) {
            float cost2;
            float cost1;
            DynamicTreeNode node = index;
            DynamicTreeNode child1 = node.child1;
            DynamicTreeNode child2 = node.child2;
            float area = node.aabb.getPerimeter();
            this.combinedAABB.combine(node.aabb, leafAABB);
            float combinedArea = this.combinedAABB.getPerimeter();
            float cost = 2.0f * combinedArea;
            float inheritanceCost = 2.0f * (combinedArea - area);
            if (child1.child1 == null) {
                this.combinedAABB.combine(leafAABB, child1.aabb);
                cost1 = this.combinedAABB.getPerimeter() + inheritanceCost;
            } else {
                this.combinedAABB.combine(leafAABB, child1.aabb);
                float oldArea = child1.aabb.getPerimeter();
                float newArea = this.combinedAABB.getPerimeter();
                cost1 = newArea - oldArea + inheritanceCost;
            }
            if (child2.child1 == null) {
                this.combinedAABB.combine(leafAABB, child2.aabb);
                cost2 = this.combinedAABB.getPerimeter() + inheritanceCost;
            } else {
                this.combinedAABB.combine(leafAABB, child2.aabb);
                float oldArea = child2.aabb.getPerimeter();
                float newArea = this.combinedAABB.getPerimeter();
                cost2 = newArea - oldArea + inheritanceCost;
            }
            if (cost < cost1 && cost < cost2) break;
            if (cost1 < cost2) {
                index = child1;
                continue;
            }
            index = child2;
        }
        DynamicTreeNode sibling = index;
        DynamicTreeNode oldParent = this.m_nodes[sibling.id].parent;
        DynamicTreeNode newParent = this.allocateNode();
        newParent.parent = oldParent;
        newParent.userData = null;
        newParent.aabb.combine(leafAABB, sibling.aabb);
        newParent.height = sibling.height + 1;
        if (oldParent != null) {
            if (oldParent.child1 == sibling) {
                oldParent.child1 = newParent;
            } else {
                oldParent.child2 = newParent;
            }
            newParent.child1 = sibling;
            newParent.child2 = leaf;
            sibling.parent = newParent;
            leaf.parent = newParent;
        } else {
            newParent.child1 = sibling;
            newParent.child2 = leaf;
            sibling.parent = newParent;
            leaf.parent = newParent;
            this.root = newParent;
        }
        index = leaf.parent;
        while (index != null) {
            index = this.balance(index);
            DynamicTreeNode child1 = index.child1;
            DynamicTreeNode child2 = index.child2;
            assert (child1 != null);
            assert (child2 != null);
            index.height = 1 + JBoxUtils.max(child1.height, child2.height);
            index.aabb.combine(child1.aabb, child2.aabb);
            index = index.parent;
        }
    }

    private void removeLeaf(DynamicTreeNode leaf) {
        if (leaf == this.root) {
            this.root = null;
            return;
        }
        DynamicTreeNode parent = leaf.parent;
        DynamicTreeNode grandParent = parent.parent;
        DynamicTreeNode sibling = parent.child1 == leaf ? parent.child2 : parent.child1;
        if (grandParent != null) {
            if (grandParent.child1 == parent) {
                grandParent.child1 = sibling;
            } else {
                grandParent.child2 = sibling;
            }
            sibling.parent = grandParent;
            this.freeNode(parent);
            DynamicTreeNode index = grandParent;
            while (index != null) {
                index = this.balance(index);
                DynamicTreeNode child1 = index.child1;
                DynamicTreeNode child2 = index.child2;
                index.aabb.combine(child1.aabb, child2.aabb);
                index.height = 1 + JBoxUtils.max(child1.height, child2.height);
                index = index.parent;
            }
        } else {
            this.root = sibling;
            sibling.parent = null;
            this.freeNode(parent);
        }
    }

    private DynamicTreeNode balance(DynamicTreeNode iA) {
        DynamicTreeNode A = iA;
        if (A.child1 == null || A.height < 2) {
            return iA;
        }
        DynamicTreeNode iB = A.child1;
        DynamicTreeNode iC = A.child2;
        assert (0 <= iB.id && iB.id < this.m_nodeCapacity);
        assert (0 <= iC.id && iC.id < this.m_nodeCapacity);
        DynamicTreeNode B = iB;
        DynamicTreeNode C = iC;
        int balance = C.height - B.height;
        if (balance > 1) {
            DynamicTreeNode iF = C.child1;
            DynamicTreeNode iG = C.child2;
            DynamicTreeNode F = iF;
            DynamicTreeNode G = iG;
            assert (F != null);
            assert (G != null);
            assert (0 <= iF.id && iF.id < this.m_nodeCapacity);
            assert (0 <= iG.id && iG.id < this.m_nodeCapacity);
            C.child1 = iA;
            C.parent = A.parent;
            A.parent = iC;
            if (C.parent != null) {
                if (C.parent.child1 == iA) {
                    C.parent.child1 = iC;
                } else {
                    assert (C.parent.child2 == iA);
                    C.parent.child2 = iC;
                }
            } else {
                this.root = iC;
            }
            if (F.height > G.height) {
                C.child2 = iF;
                A.child2 = iG;
                G.parent = iA;
                A.aabb.combine(B.aabb, G.aabb);
                C.aabb.combine(A.aabb, F.aabb);
                A.height = 1 + JBoxUtils.max(B.height, G.height);
                C.height = 1 + JBoxUtils.max(A.height, F.height);
            } else {
                C.child2 = iG;
                A.child2 = iF;
                F.parent = iA;
                A.aabb.combine(B.aabb, F.aabb);
                C.aabb.combine(A.aabb, G.aabb);
                A.height = 1 + JBoxUtils.max(B.height, F.height);
                C.height = 1 + JBoxUtils.max(A.height, G.height);
            }
            return iC;
        }
        if (balance < -1) {
            DynamicTreeNode iD = B.child1;
            DynamicTreeNode iE = B.child2;
            DynamicTreeNode D = iD;
            DynamicTreeNode E = iE;
            assert (0 <= iD.id && iD.id < this.m_nodeCapacity);
            assert (0 <= iE.id && iE.id < this.m_nodeCapacity);
            B.child1 = iA;
            B.parent = A.parent;
            A.parent = iB;
            if (B.parent != null) {
                if (B.parent.child1 == iA) {
                    B.parent.child1 = iB;
                } else {
                    assert (B.parent.child2 == iA);
                    B.parent.child2 = iB;
                }
            } else {
                this.root = iB;
            }
            if (D.height > E.height) {
                B.child2 = iD;
                A.child1 = iE;
                E.parent = iA;
                A.aabb.combine(C.aabb, E.aabb);
                B.aabb.combine(A.aabb, D.aabb);
                A.height = 1 + JBoxUtils.max(C.height, E.height);
                B.height = 1 + JBoxUtils.max(A.height, D.height);
            } else {
                B.child2 = iE;
                A.child1 = iD;
                D.parent = iA;
                A.aabb.combine(C.aabb, D.aabb);
                B.aabb.combine(A.aabb, E.aabb);
                A.height = 1 + JBoxUtils.max(C.height, D.height);
                B.height = 1 + JBoxUtils.max(A.height, E.height);
            }
            return iB;
        }
        return iA;
    }
}

