/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics.box2d.collision;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.physics.box2d.collision.RayCastInput;
import com.almasb.fxgl.physics.box2d.collision.RayCastOutput;
import com.almasb.fxgl.physics.box2d.common.JBoxUtils;
import com.almasb.fxgl.physics.box2d.pooling.IWorldPool;

public final class AABB {
    public final Vec2 lowerBound;
    public final Vec2 upperBound;

    public AABB() {
        this.lowerBound = new Vec2();
        this.upperBound = new Vec2();
    }

    public AABB(AABB copy) {
        this(copy.lowerBound, copy.upperBound);
    }

    public AABB(Vec2 lowerVertex, Vec2 upperVertex) {
        this.lowerBound = lowerVertex.clone();
        this.upperBound = upperVertex.clone();
    }

    public void set(AABB aabb) {
        Vec2 v = aabb.lowerBound;
        this.lowerBound.x = v.x;
        this.lowerBound.y = v.y;
        Vec2 v1 = aabb.upperBound;
        this.upperBound.x = v1.x;
        this.upperBound.y = v1.y;
    }

    public Vec2 getCenter() {
        return new Vec2(this.lowerBound).addLocal(this.upperBound).mulLocal(0.5);
    }

    public Vec2 getExtents() {
        return new Vec2(this.upperBound).subLocal(this.lowerBound).mulLocal(0.5);
    }

    public float getPerimeter() {
        return 2.0f * (this.upperBound.x - this.lowerBound.x + this.upperBound.y - this.lowerBound.y);
    }

    public void combine(AABB aabb1, AABB aabb2) {
        this.lowerBound.x = aabb1.lowerBound.x < aabb2.lowerBound.x ? aabb1.lowerBound.x : aabb2.lowerBound.x;
        this.lowerBound.y = aabb1.lowerBound.y < aabb2.lowerBound.y ? aabb1.lowerBound.y : aabb2.lowerBound.y;
        this.upperBound.x = aabb1.upperBound.x > aabb2.upperBound.x ? aabb1.upperBound.x : aabb2.upperBound.x;
        this.upperBound.y = aabb1.upperBound.y > aabb2.upperBound.y ? aabb1.upperBound.y : aabb2.upperBound.y;
    }

    public void combine(AABB aabb) {
        this.lowerBound.x = this.lowerBound.x < aabb.lowerBound.x ? this.lowerBound.x : aabb.lowerBound.x;
        this.lowerBound.y = this.lowerBound.y < aabb.lowerBound.y ? this.lowerBound.y : aabb.lowerBound.y;
        this.upperBound.x = this.upperBound.x > aabb.upperBound.x ? this.upperBound.x : aabb.upperBound.x;
        this.upperBound.y = this.upperBound.y > aabb.upperBound.y ? this.upperBound.y : aabb.upperBound.y;
    }

    public boolean contains(AABB aabb) {
        return this.lowerBound.x <= aabb.lowerBound.x && this.lowerBound.y <= aabb.lowerBound.y && aabb.upperBound.x <= this.upperBound.x && aabb.upperBound.y <= this.upperBound.y;
    }

    public boolean raycast(RayCastOutput output, RayCastInput input, IWorldPool argPool) {
        float temp;
        float s;
        float t2;
        float t1;
        float inv_d;
        float tmin = -3.4028235E38f;
        float tmax = Float.MAX_VALUE;
        Vec2 p = argPool.popVec2();
        Vec2 d = argPool.popVec2();
        Vec2 absD = argPool.popVec2();
        Vec2 normal = argPool.popVec2();
        p.set(input.p1);
        d.set(input.p2).subLocal(input.p1);
        absD.x = FXGLMath.abs(d.x);
        absD.y = FXGLMath.abs(d.y);
        if (absD.x < 1.1920929E-7f) {
            if (p.x < this.lowerBound.x || this.upperBound.x < p.x) {
                argPool.pushVec2(4);
                return false;
            }
        } else {
            inv_d = 1.0f / d.x;
            t1 = (this.lowerBound.x - p.x) * inv_d;
            t2 = (this.upperBound.x - p.x) * inv_d;
            s = -1.0f;
            if (t1 > t2) {
                temp = t1;
                t1 = t2;
                t2 = temp;
                s = 1.0f;
            }
            if (t1 > tmin) {
                normal.setZero();
                normal.x = s;
                tmin = t1;
            }
            if (tmin > (tmax = JBoxUtils.min(tmax, t2))) {
                argPool.pushVec2(4);
                return false;
            }
        }
        if (absD.y < 1.1920929E-7f) {
            if (p.y < this.lowerBound.y || this.upperBound.y < p.y) {
                argPool.pushVec2(4);
                return false;
            }
        } else {
            inv_d = 1.0f / d.y;
            t1 = (this.lowerBound.y - p.y) * inv_d;
            t2 = (this.upperBound.y - p.y) * inv_d;
            s = -1.0f;
            if (t1 > t2) {
                temp = t1;
                t1 = t2;
                t2 = temp;
                s = 1.0f;
            }
            if (t1 > tmin) {
                normal.setZero();
                normal.y = s;
                tmin = t1;
            }
            if (tmin > (tmax = JBoxUtils.min(tmax, t2))) {
                argPool.pushVec2(4);
                return false;
            }
        }
        if (tmin < 0.0f || input.maxFraction < tmin) {
            argPool.pushVec2(4);
            return false;
        }
        output.fraction = tmin;
        output.normal.x = normal.x;
        output.normal.y = normal.y;
        argPool.pushVec2(4);
        return true;
    }

    public static boolean testOverlap(AABB a, AABB b) {
        return !(b.lowerBound.x - a.upperBound.x > 0.0f || b.lowerBound.y - a.upperBound.y > 0.0f || a.lowerBound.x - b.upperBound.x > 0.0f) && !(a.lowerBound.y - b.upperBound.y > 0.0f);
    }

    public final String toString() {
        return "AABB[" + this.lowerBound + " . " + this.upperBound + "]";
    }
}

