/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.core.util.BackportKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.CollidableComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.entity.components.TypeComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.CollisionHandler;
import com.almasb.fxgl.physics.CollisionPair;
import com.almasb.fxgl.physics.CollisionResult;
import com.almasb.fxgl.physics.EdgeCallback;
import com.almasb.fxgl.physics.HitBox;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.RaycastResult;
import com.almasb.fxgl.physics.SensorCollisionHandler;
import com.almasb.fxgl.physics.box2d.callbacks.ContactFilter;
import com.almasb.fxgl.physics.box2d.callbacks.ContactImpulse;
import com.almasb.fxgl.physics.box2d.callbacks.ContactListener;
import com.almasb.fxgl.physics.box2d.collision.Manifold;
import com.almasb.fxgl.physics.box2d.collision.shapes.ChainShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.CircleShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.PolygonShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.Shape;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.BodyType;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import com.almasb.fxgl.physics.box2d.dynamics.FixtureDef;
import com.almasb.fxgl.physics.box2d.dynamics.World;
import com.almasb.fxgl.physics.box2d.dynamics.contacts.Contact;
import com.almasb.sslogger.Logger;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;

public final class PhysicsWorld
implements EntityWorldListener,
ContactListener {
    private static final Logger log = Logger.get(PhysicsWorld.class);
    private final double PIXELS_PER_METER;
    private final double METERS_PER_PIXELS;
    private World jboxWorld = new World(new Vec2(0.0f, -10.0f));
    private Array<Entity> entities = new UnorderedArray<Entity>(128);
    private Array<CollisionHandler> collisionHandlers = new UnorderedArray<CollisionHandler>(16);
    private Array<CollisionPair> collisions = new UnorderedArray<CollisionPair>(128);
    private int appHeight;
    private Array<Entity> delayedBodiesAdd = new UnorderedArray<Entity>();
    private Array<Entity> delayedParticlesAdd = new UnorderedArray<Entity>();
    private Array<Body> delayedBodiesRemove = new UnorderedArray<Body>();
    private Array<Entity> collidables = new UnorderedArray<Entity>(128);
    private EdgeCallback raycastCallback = new EdgeCallback();

    public World getJBox2DWorld() {
        return this.jboxWorld;
    }

    private boolean isCollidable(Entity e) {
        if (!e.isActive()) {
            return false;
        }
        return e.getComponentOptional(CollidableComponent.class).map(c -> c.getValue()).orElse(false);
    }

    private boolean areCollidable(Entity e1, Entity e2) {
        return this.isCollidable(e1) && this.isCollidable(e2);
    }

    private boolean needManualCheck(Entity e1, Entity e2) {
        BodyType type1 = e1.getComponentOptional(PhysicsComponent.class).map(p -> p.body.getType()).orElse(null);
        if (type1 == null) {
            return true;
        }
        BodyType type2 = e2.getComponentOptional(PhysicsComponent.class).map(p -> p.body.getType()).orElse(null);
        if (type2 == null) {
            return true;
        }
        return type1 == BodyType.KINEMATIC && type2 == BodyType.STATIC || type2 == BodyType.KINEMATIC && type1 == BodyType.STATIC;
    }

    private CollisionHandler getHandler(Entity e1, Entity e2) {
        if (!e1.isActive() || !e2.isActive()) {
            return null;
        }
        Object type1 = e1.getComponent(TypeComponent.class).getValue();
        Object type2 = e2.getComponent(TypeComponent.class).getValue();
        for (CollisionHandler handler : this.collisionHandlers) {
            if (!handler.equal(type1, type2)) continue;
            return handler;
        }
        return null;
    }

    private CollisionPair getPair(Entity e1, Entity e2) {
        int index = this.getPairIndex(e1, e2);
        return index == -1 ? null : this.collisions.get(index);
    }

    private int getPairIndex(Entity e1, Entity e2) {
        for (int i = 0; i < this.collisions.size(); ++i) {
            CollisionPair pair = this.collisions.get(i);
            if (!pair.equal(e1, e2)) continue;
            return i;
        }
        return -1;
    }

    public PhysicsWorld(int appHeight, double ppm) {
        this.appHeight = appHeight;
        this.PIXELS_PER_METER = ppm;
        this.METERS_PER_PIXELS = 1.0 / this.PIXELS_PER_METER;
        this.initCollisionPool();
        this.initContactListener();
        this.initParticles();
        this.jboxWorld.setContactFilter(new CollisionFilterCallback());
        log.debugf("Physics world initialized: appHeight=%d, physics.ppm=%.1f", appHeight, ppm);
    }

    private void initCollisionPool() {
        Pools.set(CollisionPair.class, new Pool<CollisionPair>(){

            @Override
            protected CollisionPair newObject() {
                return new CollisionPair();
            }
        });
    }

    private void initContactListener() {
        this.jboxWorld.setContactListener(this);
    }

    private void initParticles() {
        this.jboxWorld.setParticleGravityScale(0.4f);
        this.jboxWorld.setParticleDensity(1.2f);
        this.jboxWorld.setParticleRadius(this.toMetersF(1.0));
    }

    @Override
    public void onEntityAdded(Entity entity) {
        this.entities.add(entity);
        if (entity.hasComponent(PhysicsComponent.class)) {
            this.onPhysicsEntityAdded(entity);
        }
    }

    private void onPhysicsEntityAdded(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.createBody(entity);
        } else {
            this.delayedBodiesAdd.add(entity);
        }
        ChangeListener<Number> scaleChangeListener = (observable2, oldValue, newValue) -> {
            Body b = entity.getComponent(PhysicsComponent.class).body;
            if (b != null) {
                List<Fixture> fixtures = List.copyOf(b.getFixtures());
                BackportKt.forEach(fixtures, b::destroyFixture);
                this.createFixtures(entity);
                this.createSensors(entity);
            }
        };
        entity.getTransformComponent().scaleXProperty().addListener(scaleChangeListener);
        entity.getTransformComponent().scaleYProperty().addListener(scaleChangeListener);
    }

    private void onPhysicsParticleEntityAdded(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.createPhysicsParticles(entity);
        } else {
            this.delayedParticlesAdd.add(entity);
        }
    }

    @Override
    public void onEntityRemoved(Entity entity) {
        this.entities.removeValueByIdentity(entity);
        if (entity.hasComponent(PhysicsComponent.class)) {
            this.onPhysicsEntityRemoved(entity);
        }
    }

    private void onPhysicsEntityRemoved(Entity entity) {
        if (!this.jboxWorld.isLocked()) {
            this.destroyBody(entity);
        } else {
            this.delayedBodiesRemove.add(entity.getComponent(PhysicsComponent.class).getBody());
        }
    }

    public void onUpdate(double tpf) {
        this.jboxWorld.step((float)tpf, 8, 3);
        this.postStep();
        this.checkCollisions();
        this.notifyCollisions();
    }

    private void postStep() {
        for (Entity e : this.delayedBodiesAdd) {
            this.createBody(e);
        }
        this.delayedBodiesAdd.clear();
        for (Entity e : this.delayedParticlesAdd) {
            this.createPhysicsParticles(e);
        }
        this.delayedParticlesAdd.clear();
        for (Body body : this.delayedBodiesRemove) {
            this.jboxWorld.destroyBody(body);
        }
        this.delayedBodiesRemove.clear();
    }

    public void clear() {
        log.debug("Clearing physics world");
        this.entities.clear();
        this.collisions.clear();
    }

    public void clearCollisionHandlers() {
        this.collisionHandlers.clear();
    }

    @Override
    public void beginContact(Contact contact) {
        CollisionPair pair;
        Entity e1 = contact.getFixtureA().getBody().getEntity();
        Entity e2 = contact.getFixtureB().getBody().getEntity();
        if (contact.getFixtureA().isSensor()) {
            this.notifySensorCollisionBegin(e1, e2, contact.getFixtureA().getHitBox());
            return;
        }
        if (contact.getFixtureB().isSensor()) {
            this.notifySensorCollisionBegin(e2, e1, contact.getFixtureB().getHitBox());
            return;
        }
        if (!this.areCollidable(e1, e2)) {
            return;
        }
        CollisionHandler handler = this.getHandler(e1, e2);
        if (handler != null && (pair = this.getPair(e1, e2)) == null) {
            pair = Pools.obtain(CollisionPair.class);
            pair.init(e1, e2, handler);
            this.collisions.add(pair);
            HitBox boxA = contact.getFixtureA().getHitBox();
            HitBox boxB = contact.getFixtureB().getHitBox();
            handler.onHitBoxTrigger((Entity)pair.getA(), (Entity)pair.getB(), e1 == pair.getA() ? boxA : boxB, e2 == pair.getB() ? boxB : boxA);
            pair.collisionBegin();
        }
    }

    @Override
    public void endContact(Contact contact) {
        int pairIndex;
        Entity e1 = contact.getFixtureA().getBody().getEntity();
        Entity e2 = contact.getFixtureB().getBody().getEntity();
        if (contact.getFixtureA().isSensor()) {
            this.notifySensorCollisionEnd(e1, e2, contact.getFixtureA().getHitBox());
            return;
        }
        if (contact.getFixtureB().isSensor()) {
            this.notifySensorCollisionEnd(e2, e1, contact.getFixtureB().getHitBox());
            return;
        }
        if (!this.areCollidable(e1, e2)) {
            return;
        }
        CollisionHandler handler = this.getHandler(e1, e2);
        if (handler != null && (pairIndex = this.getPairIndex(e1, e2)) != -1) {
            CollisionPair pair = this.collisions.get(pairIndex);
            this.collisions.removeIndex(pairIndex);
            pair.collisionEnd();
            Pools.free(pair);
        }
    }

    private void notifySensorCollisionBegin(Entity eWithSensor, Entity eTriggered, HitBox box) {
        SensorCollisionHandler handler = eWithSensor.getComponent(PhysicsComponent.class).getSensorHandlers().get(box);
        handler.onCollisionBegin(eTriggered);
    }

    private void notifySensorCollisionEnd(Entity eWithSensor, Entity eTriggered, HitBox box) {
        SensorCollisionHandler handler = eWithSensor.getComponent(PhysicsComponent.class).getSensorHandlers().get(box);
        handler.onCollisionEnd(eTriggered);
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    private void checkCollisions() {
        for (Entity e : this.entities) {
            if (!this.isCollidable(e)) continue;
            this.collidables.add(e);
        }
        for (int i = 0; i < this.collidables.size(); ++i) {
            Entity e1 = this.collidables.get(i);
            for (int j = i + 1; j < this.collidables.size(); ++j) {
                Entity e2 = this.collidables.get(j);
                CollisionHandler handler = this.getHandler(e1, e2);
                if (handler == null || !this.needManualCheck(e1, e2) || this.isIgnored(e1, e2)) continue;
                CollisionResult result = e1.getBoundingBoxComponent().checkCollision(e2.getBoundingBoxComponent());
                if (result.hasCollided()) {
                    this.collisionBeginFor(handler, e1, e2, result.getBoxA(), result.getBoxB());
                    Pools.free(result);
                    continue;
                }
                this.collisionEndFor(e1, e2);
            }
        }
        this.collidables.clear();
    }

    private boolean isIgnored(Entity e1, Entity e2) {
        if (!e1.hasComponent(CollidableComponent.class) || !e2.hasComponent(CollidableComponent.class)) {
            return false;
        }
        CollidableComponent c1 = e1.getComponent(CollidableComponent.class);
        for (Serializable t1 : c1.getIgnoredTypes()) {
            if (!e2.isType(t1)) continue;
            return true;
        }
        CollidableComponent c2 = e2.getComponent(CollidableComponent.class);
        for (Serializable t2 : c2.getIgnoredTypes()) {
            if (!e1.isType(t2)) continue;
            return true;
        }
        return false;
    }

    private void collisionBeginFor(CollisionHandler handler, Entity e1, Entity e2, HitBox a, HitBox b) {
        CollisionPair pair = this.getPair(e1, e2);
        if (pair == null) {
            pair = Pools.obtain(CollisionPair.class);
            pair.init(e1, e2, handler);
            this.collisions.add(pair);
            handler.onHitBoxTrigger((Entity)pair.getA(), (Entity)pair.getB(), a, b);
            pair.collisionBegin();
        }
    }

    private void collisionEndFor(Entity e1, Entity e2) {
        int pairIndex = this.getPairIndex(e1, e2);
        if (pairIndex != -1) {
            CollisionPair pair = this.collisions.get(pairIndex);
            this.collisions.removeIndex(pairIndex);
            pair.collisionEnd();
            Pools.free(pair);
        }
    }

    private void notifyCollisions() {
        Iterator<CollisionPair> it = this.collisions.iterator();
        while (it.hasNext()) {
            CollisionPair pair = it.next();
            if (!(((Entity)pair.getA()).isActive() && ((Entity)pair.getB()).isActive() && this.isCollidable((Entity)pair.getA()) && this.isCollidable((Entity)pair.getB()))) {
                pair.collisionEnd();
                it.remove();
                Pools.free(pair);
                continue;
            }
            pair.collision();
        }
    }

    public void addCollisionHandler(CollisionHandler handler) {
        this.collisionHandlers.add(handler);
    }

    public void removeCollisionHandler(CollisionHandler handler) {
        this.collisionHandlers.removeValueByIdentity(handler);
    }

    public void setGravity(double x, double y) {
        this.jboxWorld.setGravity(this.toVector(new Point2D(x, y)));
    }

    private void createBody(Entity e) {
        PhysicsComponent physics = e.getComponent(PhysicsComponent.class);
        physics.setWorld(this);
        if (physics.bodyDef.getPosition().x == 0.0f && physics.bodyDef.getPosition().y == 0.0f) {
            physics.bodyDef.getPosition().set(this.toPoint(e.getCenter()));
        }
        if (physics.bodyDef.getAngle() == 0.0f) {
            physics.bodyDef.setAngle((float)(-Math.toRadians(e.getRotation())));
        }
        physics.body = this.jboxWorld.createBody(physics.bodyDef);
        this.createFixtures(e);
        this.createSensors(e);
        physics.body.setEntity(e);
        physics.onInitPhysics();
    }

    private void createFixtures(Entity e) {
        BoundingBoxComponent bbox = e.getBoundingBoxComponent();
        PhysicsComponent physics = e.getComponent(PhysicsComponent.class);
        FixtureDef fd = physics.fixtureDef;
        for (HitBox box : bbox.hitBoxesProperty()) {
            Shape b2Shape = this.createShape(box, e);
            fd.setShape(b2Shape);
            Fixture fixture = physics.body.createFixture(fd);
            fixture.setHitBox(box);
        }
    }

    private void createSensors(Entity e) {
        PhysicsComponent physics = e.getComponent(PhysicsComponent.class);
        if (physics.getSensorHandlers().isEmpty()) {
            return;
        }
        BackportKt.forEach(physics.getSensorHandlers().keys(), box -> {
            box.bindXY(e.getTransformComponent());
            Shape polygonShape = this.createShape((HitBox)box, e);
            FixtureDef fd = new FixtureDef().sensor(true).shape(polygonShape);
            Fixture f = physics.body.createFixture(fd);
            f.setHitBox((HitBox)box);
        });
    }

    private Shape createShape(HitBox box, Entity e) {
        Point2D boundsCenterWorld = new Point2D((box.getMinXWorld() + box.getMaxXWorld()) / 2.0, (box.getMinYWorld() + box.getMaxYWorld()) / 2.0);
        Point2D boundsCenterLocal = boundsCenterWorld.subtract(e.getCenter());
        double w = box.getMaxXWorld() - box.getMinXWorld();
        double h = box.getMaxYWorld() - box.getMinYWorld();
        BoundingShape boundingShape = box.getShape();
        switch (boundingShape.type) {
            case CIRCLE: {
                return this.circle(w, boundsCenterLocal);
            }
            case POLYGON: {
                if (boundingShape.data instanceof Dimension2D) {
                    return this.polygonAsBox(w, h, boundsCenterLocal);
                }
                return this.polygon((Point2D[])boundingShape.data, boundsCenterLocal, e.getBoundingBoxComponent().getCenterLocal(), e.getTransformComponent(), box, e.getBoundingBoxComponent());
            }
            case CHAIN: {
                if (e.getComponent(PhysicsComponent.class).body.getType() != BodyType.STATIC) {
                    throw new IllegalArgumentException("BoundingShape.chain() can only be used with BodyType.STATIC");
                }
                return this.chain((Point2D[])boundingShape.data, boundsCenterLocal, e.getBoundingBoxComponent().getCenterLocal());
            }
        }
        log.warning("Unsupported hit box shape");
        throw new UnsupportedOperationException("Using unsupported shape: " + boundingShape.type);
    }

    private Shape circle(double w, Point2D boundsCenterLocal) {
        CircleShape shape = new CircleShape();
        shape.setRadius(this.toMetersF(w / 2.0));
        shape.center.set(this.toVector(boundsCenterLocal));
        return shape;
    }

    private Shape polygonAsBox(double w, double h, Point2D boundsCenterLocal) {
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(this.toMetersF(w / 2.0), this.toMetersF(h / 2.0), this.toVector(boundsCenterLocal), 0.0f);
        return shape;
    }

    private Shape polygon(Point2D[] points, Point2D boundsCenterLocal, Point2D bboxCenterLocal, TransformComponent t, HitBox box, BoundingBoxComponent bboxComp) {
        Vec2[] vertices = new Vec2[points.length];
        Point2D bboxCenterLocalNew = new Point2D(bboxCenterLocal.getX() * t.getScaleX() + (1.0 - t.getScaleX()) * t.getScaleOrigin().getX(), bboxCenterLocal.getY() * t.getScaleY() + (1.0 - t.getScaleY()) * t.getScaleOrigin().getY());
        Point2D boundsCenterLocalNew = new Point2D(boundsCenterLocal.getX() * t.getScaleX() + (1.0 - t.getScaleX()) * t.getScaleOrigin().getX(), boundsCenterLocal.getY() * t.getScaleY() + (1.0 - t.getScaleY()) * t.getScaleOrigin().getY());
        for (int i = 0; i < vertices.length; ++i) {
            Point2D p = new Point2D((points[i].getX() + box.getMinX()) * t.getScaleX() + (1.0 - t.getScaleX()) * t.getScaleOrigin().getX(), (points[i].getY() + box.getMinY()) * t.getScaleY() + (1.0 - t.getScaleY()) * t.getScaleOrigin().getY());
            vertices[i] = this.toVector(p.subtract(boundsCenterLocalNew)).subLocal(this.toVector(bboxCenterLocalNew)).addLocal(this.toVector(boundsCenterLocalNew)).subLocal(this.toMeters(bboxComp.getMinXLocal()), -this.toMeters(bboxComp.getMinYLocal()));
        }
        PolygonShape shape = new PolygonShape();
        shape.set(vertices);
        return shape;
    }

    private Shape chain(Point2D[] points, Point2D boundsCenterLocal, Point2D bboxCenterLocal) {
        Vec2[] vertices = new Vec2[points.length];
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = this.toVector(points[i].subtract(boundsCenterLocal)).subLocal(this.toVector(bboxCenterLocal));
        }
        ChainShape shape = new ChainShape();
        shape.createLoop(vertices, vertices.length);
        return shape;
    }

    private void createPhysicsParticles(Entity e) {
    }

    private void destroyBody(Entity e) {
        this.jboxWorld.destroyBody(e.getComponent(PhysicsComponent.class).body);
    }

    public RaycastResult raycast(Point2D start, Point2D end) {
        this.raycastCallback.reset();
        this.jboxWorld.raycast(this.raycastCallback, this.toPoint(start), this.toPoint(end));
        Entity entity = null;
        Point2D point = null;
        if (this.raycastCallback.getFixture() != null) {
            entity = this.raycastCallback.getFixture().getBody().getEntity();
        }
        if (this.raycastCallback.getPoint() != null) {
            point = this.toPoint(this.raycastCallback.getPoint());
        }
        if (entity == null && point == null) {
            return RaycastResult.NONE;
        }
        return new RaycastResult(entity, point);
    }

    public float toMetersF(double pixels) {
        return (float)this.toMeters(pixels);
    }

    public double toMeters(double pixels) {
        return pixels * this.METERS_PER_PIXELS;
    }

    public float toPixelsF(double meters) {
        return (float)this.toPixels(meters);
    }

    public double toPixels(double meters) {
        return meters * this.PIXELS_PER_METER;
    }

    public Vec2 toVector(Point2D v) {
        return new Vec2(this.toMetersF(v.getX()), this.toMetersF(-v.getY()));
    }

    public Point2D toVector(Vec2 v) {
        return new Point2D(this.toPixels(v.x), this.toPixels(-v.y));
    }

    public Vec2 toPoint(Point2D p) {
        return new Vec2(this.toMetersF(p.getX()), this.toMetersF((double)this.appHeight - p.getY()));
    }

    public Point2D toPoint(Vec2 p) {
        return new Point2D(this.toPixels(p.x), this.toPixels(this.toMeters(this.appHeight) - (double)p.y));
    }

    private class CollisionFilterCallback
    extends ContactFilter {
        private CollisionFilterCallback() {
        }

        @Override
        public boolean shouldCollide(Fixture fixtureA, Fixture fixtureB) {
            Entity e2;
            Entity e1 = fixtureA.getBody().getEntity();
            if (PhysicsWorld.this.areCollidable(e1, e2 = fixtureB.getBody().getEntity()) && PhysicsWorld.this.isIgnored(e1, e2)) {
                return false;
            }
            return super.shouldCollide(fixtureA, fixtureB);
        }
    }
}

