/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.physics.BoundingShape;
import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;

public final class HitBox
implements Serializable {
    private String name;
    private BoundingShape shape;
    private Bounds bounds;
    private transient DoubleProperty minXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxXWorld = new SimpleDoubleProperty();
    private transient DoubleProperty minYWorld = new SimpleDoubleProperty();
    private transient DoubleProperty maxYWorld = new SimpleDoubleProperty();

    public HitBox(BoundingShape shape) {
        this(String.valueOf(shape.hashCode()), shape);
    }

    public HitBox(Point2D localOrigin, BoundingShape shape) {
        this(String.valueOf(shape.hashCode()), localOrigin, shape);
    }

    public HitBox(String name, BoundingShape shape) {
        this(name, Point2D.ZERO, shape);
    }

    public HitBox(String name, Point2D localOrigin, BoundingShape shape) {
        this.name = name;
        this.shape = shape;
        this.bounds = new BoundingBox(localOrigin.getX(), localOrigin.getY(), shape.getSize().getWidth(), shape.getSize().getHeight());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeDouble(this.bounds.getMinX());
        out.writeDouble(this.bounds.getMinY());
        out.writeDouble(this.bounds.getWidth());
        out.writeDouble(this.bounds.getHeight());
        out.writeDouble(this.shape.size.getWidth());
        out.writeDouble(this.shape.size.getHeight());
        out.writeObject((Object)this.shape.type);
        if (this.shape.type == ShapeType.CHAIN) {
            Point2D[] points = (Point2D[])this.shape.data;
            out.writeInt(points.length);
            for (Point2D p : points) {
                out.writeDouble(p.getX());
                out.writeDouble(p.getY());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.bounds = new BoundingBox(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
        Dimension2D size = new Dimension2D(in.readDouble(), in.readDouble());
        ShapeType type = (ShapeType)((Object)in.readObject());
        switch (type) {
            case CIRCLE: {
                this.shape = BoundingShape.circle(size.getWidth() / 2.0);
                break;
            }
            case POLYGON: {
                this.shape = BoundingShape.box(size.getWidth(), size.getHeight());
                break;
            }
            case CHAIN: {
                int length = in.readInt();
                Point2D[] points = new Point2D[length];
                for (int i = 0; i < length; ++i) {
                    points[i] = new Point2D(in.readDouble(), in.readDouble());
                }
                this.shape = BoundingShape.chain(points);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown shape type");
            }
        }
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public BoundingShape getShape() {
        return this.shape;
    }

    public double getMinX() {
        return this.bounds.getMinX();
    }

    public double getMinY() {
        return this.bounds.getMinY();
    }

    public double getMaxX() {
        return this.bounds.getMaxX();
    }

    public double getMaxY() {
        return this.bounds.getMaxY();
    }

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    public String getName() {
        return this.name;
    }

    public void bindXY(TransformComponent transform) {
        DoubleBinding x1 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMinX()) * transform.getScaleX() + transform.getX(), transform.scaleOriginXProperty(), transform.scaleXProperty(), transform.xProperty());
        DoubleBinding x2 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getX() - (transform.getScaleOrigin().getX() - this.getMaxX()) * transform.getScaleX() + transform.getX(), transform.scaleOriginXProperty(), transform.scaleXProperty(), transform.xProperty());
        DoubleBinding y1 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMinY()) * transform.getScaleY() + transform.getY(), transform.scaleOriginYProperty(), transform.scaleYProperty(), transform.yProperty());
        DoubleBinding y2 = Bindings.createDoubleBinding(() -> transform.getScaleOrigin().getY() - (transform.getScaleOrigin().getY() - this.getMaxY()) * transform.getScaleY() + transform.getY(), transform.scaleOriginYProperty(), transform.scaleYProperty(), transform.yProperty());
        this.minXWorld.bind(Bindings.when(x1.greaterThan(x2)).then(x2).otherwise(x1));
        this.maxXWorld.bind(Bindings.when(x1.greaterThan(x2)).then(x1).otherwise(x2));
        this.minYWorld.bind(Bindings.when(y1.greaterThan(y2)).then(y2).otherwise(y1));
        this.maxYWorld.bind(Bindings.when(y1.greaterThan(y2)).then(y1).otherwise(y2));
    }

    public void unbind() {
        this.minXWorld.unbind();
        this.maxXWorld.unbind();
        this.minYWorld.unbind();
        this.maxYWorld.unbind();
    }

    public double getMinXWorld() {
        return this.minXWorld.get();
    }

    public double getMaxXWorld() {
        return this.maxXWorld.get();
    }

    public double getMinYWorld() {
        return this.minYWorld.get();
    }

    public double getMaxYWorld() {
        return this.maxYWorld.get();
    }

    public Point2D centerLocal() {
        return new Point2D((this.bounds.getMinX() + this.bounds.getMaxX()) / 2.0, (this.bounds.getMinY() + this.bounds.getMaxY()) / 2.0);
    }

    public Point2D centerWorld(double x, double y) {
        return this.centerLocal().add(x, y);
    }

    public HitBox copy() {
        return new HitBox(this.name, new Point2D(this.bounds.getMinX(), this.bounds.getMinY()), this.shape);
    }

    public String toString() {
        return "HitBox(" + this.name + "," + this.shape + ")";
    }
}

