/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.physics.PhysicsComponent;
import com.almasb.fxgl.physics.box2d.callbacks.RayCastCallback;
import com.almasb.fxgl.physics.box2d.dynamics.Body;
import com.almasb.fxgl.physics.box2d.dynamics.Fixture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0003\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/almasb/fxgl/physics/EdgeCallback;", "Lcom/almasb/fxgl/physics/box2d/callbacks/RayCastCallback;", "()V", "<set-?>", "", "bestFraction", "getBestFraction", "()F", "Lcom/almasb/fxgl/physics/box2d/dynamics/Fixture;", "fixture", "getFixture", "()Lcom/almasb/fxgl/physics/box2d/dynamics/Fixture;", "Lcom/almasb/fxgl/core/math/Vec2;", "point", "getPoint", "()Lcom/almasb/fxgl/core/math/Vec2;", "reportFixture", "normal", "fraction", "reset", "", "fxgl-entity"})
public final class EdgeCallback
implements RayCastCallback {
    @Nullable
    private Fixture fixture;
    @Nullable
    private Vec2 point;
    private float bestFraction = 1.0f;

    @Nullable
    public final Fixture getFixture() {
        return this.fixture;
    }

    @Nullable
    public final Vec2 getPoint() {
        return this.point;
    }

    public final float getBestFraction() {
        return this.bestFraction;
    }

    @Override
    public float reportFixture(@NotNull Fixture fixture, @NotNull Vec2 point, @Nullable Vec2 normal, float fraction) {
        Intrinsics.checkParameterIsNotNull(fixture, "fixture");
        Intrinsics.checkParameterIsNotNull(point, "point");
        Body body = fixture.getBody();
        Intrinsics.checkExpressionValueIsNotNull(body, "fixture.body");
        Entity e = body.getEntity();
        PhysicsComponent physicsComponent = e.getComponent(PhysicsComponent.class);
        Intrinsics.checkExpressionValueIsNotNull(physicsComponent, "e.getComponent(PhysicsComponent::class.java)");
        if (physicsComponent.isRaycastIgnored()) {
            return 1.0f;
        }
        if (fraction < this.bestFraction) {
            this.fixture = fixture;
            this.point = point.clone();
            this.bestFraction = fraction;
        }
        return this.bestFraction;
    }

    public final void reset() {
        this.fixture = null;
        this.point = null;
        this.bestFraction = 1.0f;
    }
}

