/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.physics;

import com.almasb.fxgl.physics.box2d.collision.shapes.ShapeType;
import java.util.List;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;

public final class BoundingShape {
    final ShapeType type;
    public final Object data;
    final Dimension2D size;

    private BoundingShape(ShapeType type, Object data, Dimension2D size) {
        this.type = type;
        this.data = data;
        this.size = size;
    }

    Dimension2D getSize() {
        return this.size;
    }

    public boolean isCircle() {
        return this.type == ShapeType.CIRCLE;
    }

    public boolean isPolygon() {
        return this.type == ShapeType.POLYGON;
    }

    public static BoundingShape circle(double radius) {
        return new BoundingShape(ShapeType.CIRCLE, new Dimension2D(radius * 2.0, radius * 2.0), new Dimension2D(radius * 2.0, radius * 2.0));
    }

    public static BoundingShape box(double width, double height) {
        return new BoundingShape(ShapeType.POLYGON, new Dimension2D(width, height), new Dimension2D(width, height));
    }

    public static BoundingShape chain(Point2D ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("Chain shape requires at least 2 points. Given points: " + points.length);
        }
        double maxX = points[0].getX();
        double maxY = points[0].getY();
        for (Point2D p : points) {
            if (p.getX() > maxX) {
                maxX = p.getX();
            }
            if (!(p.getY() > maxY)) continue;
            maxY = p.getY();
        }
        return new BoundingShape(ShapeType.CHAIN, points, new Dimension2D(maxX, maxY));
    }

    public static BoundingShape polygon(List<Point2D> points) {
        return BoundingShape.polygon(points.toArray(new Point2D[0]));
    }

    public static BoundingShape polygonFromDoubles(List<Double> points) {
        double[] array = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            array[i] = points.get(i);
        }
        return BoundingShape.polygon(array);
    }

    public static BoundingShape polygon(double ... points) {
        Point2D[] array = new Point2D[points.length / 2];
        for (int i = 0; i < array.length; ++i) {
            double x = points[i * 2];
            double y = points[i * 2 + 1];
            array[i] = new Point2D(x, y);
        }
        return BoundingShape.polygon(array);
    }

    public static BoundingShape polygon(Point2D ... points) {
        if (points.length < 3) {
            throw new IllegalArgumentException("Polygon shape requires at least 3 points. Given points: " + points.length);
        }
        double maxX = points[0].getX();
        double maxY = points[0].getY();
        for (Point2D p : points) {
            if (p.getX() > maxX) {
                maxX = p.getX();
            }
            if (!(p.getY() > maxY)) continue;
            maxY = p.getY();
        }
        return new BoundingShape(ShapeType.POLYGON, points, new Dimension2D(maxX, maxY));
    }

    public String toString() {
        return this.type.toString();
    }
}

