/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.particle;

import com.almasb.fxgl.core.Updatable;
import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.particle.Particle;
import com.almasb.fxgl.particle.ParticleEmitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR6\u0010\f\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/particle/ParticleSystem;", "Lcom/almasb/fxgl/core/Updatable;", "()V", "emitters", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/particle/ParticleEmitter;", "Ljavafx/geometry/Point2D;", "Lkotlin/collections/HashMap;", "pane", "Ljavafx/scene/layout/Pane;", "getPane", "()Ljavafx/scene/layout/Pane;", "particles", "", "Lcom/almasb/fxgl/particle/Particle;", "addParticleEmitter", "", "emitter", "x", "", "y", "onUpdate", "tpf", "removeParticleEmitter", "fxgl-effects"})
public final class ParticleSystem
implements Updatable {
    @NotNull
    private final Pane pane = new Pane();
    private final HashMap<ParticleEmitter, Point2D> emitters;
    private final HashMap<ParticleEmitter, List<Particle>> particles;

    @NotNull
    public final Pane getPane() {
        return this.pane;
    }

    public final void addParticleEmitter(@NotNull ParticleEmitter emitter, double x, double y) {
        Intrinsics.checkParameterIsNotNull(emitter, "emitter");
        Map map = this.emitters;
        Object object = new Point2D(x, y);
        map.put(emitter, object);
        map = this.particles;
        object = new ArrayList();
        map.put(emitter, object);
    }

    public final void removeParticleEmitter(@NotNull ParticleEmitter emitter) {
        Intrinsics.checkParameterIsNotNull(emitter, "emitter");
        this.emitters.remove(emitter);
        List<Particle> list = this.particles.remove(emitter);
        if (list != null) {
            List<Particle> list2;
            List<Particle> it = list2 = list;
            boolean bl = false;
            List<Particle> list3 = it;
            Intrinsics.checkExpressionValueIsNotNull(list3, "it");
            Iterable $receiver$iv = list3;
            for (Object element$iv : $receiver$iv) {
                Particle it2 = (Particle)element$iv;
                boolean bl2 = false;
                Pools.free(it2);
            }
        }
    }

    @Override
    public void onUpdate(double tpf) {
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)this.emitters;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<Particle> particlesList;
            Map.Entry element$iv;
            Map.Entry $emitter_p = element$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = $emitter_p;
            ParticleEmitter emitter = (ParticleEmitter)entry.getKey();
            entry = $emitter_p;
            Point2D p = (Point2D)entry.getValue();
            if (this.particles.get(emitter) == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(particlesList, "particles[emitter]!!");
            Collection collection = particlesList;
            Array<Particle> array = emitter.emit(p.getX(), p.getY());
            Intrinsics.checkExpressionValueIsNotNull(array, "emitter.emit(p.x, p.y)");
            CollectionsKt.addAll(collection, (Iterable)array);
            Iterator<Particle> iter = particlesList.iterator();
            while (iter.hasNext()) {
                Particle particle = iter.next();
                if (particle.update(tpf)) {
                    iter.remove();
                    this.pane.getChildren().remove(particle.getView());
                    Pools.free(p);
                    continue;
                }
                Node node = particle.getView();
                Intrinsics.checkExpressionValueIsNotNull(node, "particle.view");
                if (node.getParent() != null) continue;
                this.pane.getChildren().add(particle.getView());
            }
        }
    }

    public ParticleSystem() {
        ParticleSystem particleSystem = this;
        HashMap hashMap = new HashMap();
        particleSystem.emitters = hashMap;
        particleSystem = this;
        hashMap = new HashMap();
        particleSystem.particles = hashMap;
    }
}

