/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.particle;

import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.particle.ParticleEmitter;
import javafx.geometry.Point2D;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public final class ParticleEmitters {
    public static ParticleEmitter newFireEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(15);
        emitter.setEmissionRate(0.5);
        emitter.setStartColor(Color.rgb(255, 255, 90));
        emitter.setEndColor(Color.rgb(230, 75, 40));
        emitter.setSize(9.0, 12.0);
        emitter.setVelocityFunction(i -> new Point2D(FXGLMath.random(-0.5, 0.5) * 0.25 * 60.0, FXGLMath.random() * -1.0 * 60.0));
        emitter.setSpawnPointFunction(i -> new Point2D(0.0, 0.0).add(new Point2D((double)i.intValue() * (FXGLMath.random() - 0.5), FXGLMath.random() - 1.0)));
        emitter.setScaleFunction(i -> new Point2D(FXGLMath.random(-0.01, 0.01) * 10.0, FXGLMath.random() * -0.1));
        emitter.setExpireFunction(i -> Duration.seconds(1.0));
        emitter.setBlendMode(BlendMode.ADD);
        return emitter;
    }

    public static ParticleEmitter newFireEmitter(int width) {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(width / 32 + 1);
        emitter.setEmissionRate(0.05);
        emitter.setSize(16.0, 32.0);
        emitter.setVelocityFunction(i -> new Point2D((double)FXGLMath.random(-1, 1) * 2.5, -FXGLMath.random() * (double)FXGLMath.random(10, 30)));
        emitter.setSpawnPointFunction(i -> new Point2D(FXGLMath.random(0, width - 32), 0.0));
        emitter.setScaleFunction(i -> new Point2D(0.15, 0.1));
        emitter.setExpireFunction(i -> Duration.seconds(FXGLMath.random(4, 7)));
        emitter.setBlendMode(BlendMode.ADD);
        return emitter;
    }

    public static ParticleEmitter newExplosionEmitter(int explosionRadius) {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(100);
        emitter.setEmissionRate(0.0166);
        emitter.setMaxEmissions(1);
        emitter.setSize(5.0, 20.0);
        emitter.setSpawnPointFunction(i -> new Point2D(0.0, 0.0));
        emitter.setVelocityFunction(i -> new Point2D(Math.cos(i.intValue()), Math.sin(i.intValue())).multiply(explosionRadius));
        emitter.setScaleFunction(i -> new Point2D(FXGLMath.random() * -0.1, FXGLMath.random() * -0.1));
        emitter.setExpireFunction(i -> Duration.seconds(0.5));
        emitter.setColor(Color.rgb(FXGLMath.random(200, 255), 30, 20));
        emitter.setBlendMode(BlendMode.ADD);
        emitter.setInterpolator(Interpolators.EXPONENTIAL.EASE_OUT());
        return emitter;
    }

    public static ParticleEmitter newImplosionEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(100);
        emitter.setEmissionRate(0.0166);
        emitter.setSize(5.0, 20.0);
        emitter.setSpawnPointFunction(i -> {
            Point2D vector = new Point2D(Math.cos(i.intValue()), Math.sin(i.intValue()));
            return new Point2D(0.0, 0.0).add(vector.multiply(25.0));
        });
        emitter.setVelocityFunction(i -> {
            Point2D vector = new Point2D(Math.cos(i.intValue()), Math.sin(i.intValue()));
            Point2D newPos = new Point2D(0.0, 0.0).add(vector.multiply(25.0));
            return newPos.subtract(Point2D.ZERO).multiply(-3.0);
        });
        emitter.setScaleFunction(i -> new Point2D(FXGLMath.random() * -0.1, FXGLMath.random() * -0.1));
        emitter.setExpireFunction(i -> Duration.seconds(0.5));
        emitter.setColor(Color.rgb(FXGLMath.random(200, 255), 30, 20));
        emitter.setBlendMode(BlendMode.ADD);
        return emitter;
    }

    public static ParticleEmitter newSparkEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(30);
        emitter.setEmissionRate(0.0083);
        emitter.setSize(1.0, 2.0);
        emitter.setSpawnPointFunction(i -> Point2D.ZERO);
        emitter.setVelocityFunction(i -> new Point2D(FXGLMath.random(-1, 1), FXGLMath.random(-6, -5)).multiply(6.0));
        emitter.setAccelerationFunction(() -> new Point2D(0.0, FXGLMath.random(0.01, 0.015)));
        emitter.setExpireFunction(i -> Duration.seconds(2.0));
        emitter.setColor(Color.rgb(30, 35, FXGLMath.random(200, 255)));
        return emitter;
    }

    public static ParticleEmitter newSmokeEmitter() {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(5);
        emitter.setEmissionRate(1.0);
        emitter.setSize(9.0, 10.0);
        emitter.setSpawnPointFunction(i -> Point2D.ZERO.add(FXGLMath.random(-1, 1), 0.0));
        emitter.setVelocityFunction(i -> new Point2D(FXGLMath.random() * 0.1 * 60.0, 0.0));
        emitter.setAccelerationFunction(() -> new Point2D(0.0, FXGLMath.random() * -0.03));
        emitter.setExpireFunction(i -> Duration.seconds(FXGLMath.random(1, 3)));
        emitter.setColor(Color.rgb(230, 230, 230));
        emitter.setScaleFunction(i -> new Point2D(-0.01, -0.05));
        return emitter;
    }

    public static ParticleEmitter newRainEmitter(int width) {
        ParticleEmitter emitter = new ParticleEmitter();
        emitter.setNumParticles(5);
        emitter.setEmissionRate(1.0);
        emitter.setSize(6.0, 7.0);
        emitter.setColor(Color.AQUA);
        emitter.setSpawnPointFunction(i -> new Point2D(FXGLMath.random() * (double)width, -25.0));
        emitter.setVelocityFunction(i -> new Point2D(0.0, FXGLMath.random() * 15.0 * 60.0));
        emitter.setAccelerationFunction(() -> new Point2D(0.0, FXGLMath.random() * 0.03));
        emitter.setExpireFunction(i -> Duration.seconds(FXGLMath.random(1, 3)));
        emitter.setScaleFunction(i -> new Point2D(-0.02, 0.0));
        return emitter;
    }
}

