/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.particle;

import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.pool.Pools;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.particle.Particle;
import com.almasb.fxgl.particle.ParticleEmitter;
import java.util.Iterator;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/particle/ParticleComponent;", "Lcom/almasb/fxgl/entity/component/Component;", "emitter", "Lcom/almasb/fxgl/particle/ParticleEmitter;", "(Lcom/almasb/fxgl/particle/ParticleEmitter;)V", "getEmitter", "()Lcom/almasb/fxgl/particle/ParticleEmitter;", "onFinished", "Ljava/lang/Runnable;", "getOnFinished", "()Ljava/lang/Runnable;", "setOnFinished", "(Ljava/lang/Runnable;)V", "parent", "Lcom/almasb/fxgl/entity/Entity;", "particles", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "Lcom/almasb/fxgl/particle/Particle;", "onRemoved", "", "onUpdate", "tpf", "", "fxgl-effects"})
public final class ParticleComponent
extends Component {
    @NotNull
    private Runnable onFinished;
    private final Entity parent;
    private final UnorderedArray<Particle> particles;
    @NotNull
    private final ParticleEmitter emitter;

    @NotNull
    public final Runnable getOnFinished() {
        return this.onFinished;
    }

    public final void setOnFinished(@NotNull Runnable runnable) {
        Intrinsics.checkParameterIsNotNull(runnable, "<set-?>");
        this.onFinished = runnable;
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.parent.getWorld() == null) {
            Entity entity = this.entity;
            Intrinsics.checkExpressionValueIsNotNull(entity, "entity");
            entity.getWorld().addEntity(this.parent);
        }
        Entity entity = this.entity;
        Intrinsics.checkExpressionValueIsNotNull(entity, "entity");
        double d = entity.getX();
        Entity entity2 = this.entity;
        Intrinsics.checkExpressionValueIsNotNull(entity2, "entity");
        this.particles.addAll(this.emitter.emit(d, entity2.getY()));
        Iterator iterator2 = this.particles.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, "particles.iterator()");
        Iterator iter = iterator2;
        while (iter.hasNext()) {
            Particle p = (Particle)iter.next();
            if (p.update(tpf)) {
                iter.remove();
                ViewComponent viewComponent = this.parent.getViewComponent();
                Particle particle = p;
                Intrinsics.checkExpressionValueIsNotNull(particle, "p");
                Node node = particle.getView();
                Intrinsics.checkExpressionValueIsNotNull(node, "p.view");
                viewComponent.removeChild(node);
                Pools.free(p);
                continue;
            }
            Particle particle = p;
            Intrinsics.checkExpressionValueIsNotNull(particle, "p");
            Node node = particle.getView();
            Intrinsics.checkExpressionValueIsNotNull(node, "p.view");
            if (node.getParent() != null) continue;
            ViewComponent viewComponent = this.parent.getViewComponent();
            Node node2 = p.getView();
            Intrinsics.checkExpressionValueIsNotNull(node2, "p.view");
            ViewComponent.addChild$default(viewComponent, node2, false, 2, null);
        }
        if (this.particles.isEmpty() && this.emitter.isFinished()) {
            this.onFinished.run();
        }
    }

    @Override
    public void onRemoved() {
        Iterable $receiver$iv = this.particles;
        for (Object element$iv : $receiver$iv) {
            Particle it = (Particle)element$iv;
            boolean bl = false;
            Pools.free(it);
        }
        this.particles.clear();
        this.parent.removeFromWorld();
    }

    @NotNull
    public final ParticleEmitter getEmitter() {
        return this.emitter;
    }

    public ParticleComponent(@NotNull ParticleEmitter emitter) {
        Intrinsics.checkParameterIsNotNull(emitter, "emitter");
        this.emitter = emitter;
        this.onFinished = EmptyRunnable.INSTANCE;
        this.parent = new Entity();
        this.particles = new UnorderedArray(256);
    }
}

