/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.particle;

import com.almasb.fxgl.animation.AnimatedColor;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.pool.Poolable;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Ellipse;
import javafx.util.Duration;

public class Particle
implements Poolable {
    private Vec2 startPosition = new Vec2();
    public final Vec2 position = new Vec2();
    public final Vec2 velocity = new Vec2();
    public final Vec2 acceleration = new Vec2();
    private Interpolator interpolator;
    private Vec2 radius = new Vec2();
    private Vec2 scale = new Vec2();
    private double initialLife;
    public double life;
    private Paint startColor;
    private Paint endColor;
    private BlendMode blendMode;
    private boolean allowRotation;
    private Function<Double, Point2D> equation;
    private Image image = null;
    private Ellipse view = new Ellipse();
    private ImageView imageView = new ImageView();
    private AnimatedColor colorAnimation = new AnimatedColor(Color.BLACK, Color.WHITE);
    private Consumer<Particle> control = null;
    private Vec2 moveVector = new Vec2();

    public Node getView() {
        return this.imageView.getImage() != null ? this.imageView : this.view;
    }

    public Particle(Consumer<Particle> control, Point2D position, Point2D vel, Point2D acceleration, double radius, Point2D scale, Duration expireTime, Paint startColor, Paint endColor, BlendMode blendMode, boolean allowRotation, Function<Double, Point2D> equation) {
        this(control, null, position, vel, acceleration, radius, scale, expireTime, startColor, endColor, blendMode, allowRotation, equation);
    }

    public Particle(Consumer<Particle> control, Image image2, Point2D position, Point2D vel, Point2D acceleration, double radius, Point2D scale, Duration expireTime, Paint startColor, Paint endColor, BlendMode blendMode, boolean allowRotation, Function<Double, Point2D> equation) {
        this.init(control, image2, position, vel, acceleration, radius, scale, expireTime, startColor, endColor, blendMode, Interpolator.LINEAR, allowRotation, equation);
    }

    public Particle() {
        this.reset();
    }

    public final void init(Consumer<Particle> control, Image image2, Point2D position, Point2D vel, Point2D acceleration, double radius, Point2D scale, Duration expireTime, Paint startColor, Paint endColor, BlendMode blendMode, Interpolator interpolator, boolean allowRotation, Function<Double, Point2D> equation) {
        this.image = image2;
        this.startPosition.set(position);
        this.position.set(position);
        this.radius.set((float)radius, (float)radius);
        this.scale.set(scale);
        this.velocity.set(vel);
        this.acceleration.set(acceleration);
        this.startColor = startColor;
        this.endColor = endColor;
        this.blendMode = blendMode;
        this.life = this.initialLife = expireTime.toSeconds();
        this.interpolator = interpolator;
        this.allowRotation = allowRotation;
        this.equation = equation;
        this.control = control;
        this.imageView.setImage(image2);
        this.colorAnimation = new AnimatedColor((Color)startColor, (Color)endColor);
    }

    @Override
    public void reset() {
        this.image = null;
        this.startPosition.setZero();
        this.position.setZero();
        this.velocity.setZero();
        this.acceleration.setZero();
        this.radius.setZero();
        this.scale.setZero();
        this.startColor = Color.TRANSPARENT;
        this.endColor = Color.TRANSPARENT;
        this.blendMode = BlendMode.SRC_OVER;
        this.initialLife = 0.0;
        this.life = 0.0;
        this.interpolator = Interpolator.LINEAR;
        this.allowRotation = false;
        this.equation = null;
        this.control = null;
    }

    boolean update(double tpf) {
        boolean dead;
        double y;
        double x;
        double progress = 1.0 - this.life / this.initialLife;
        double t = this.interpolator.interpolate(0.0, this.initialLife, progress);
        if (this.control != null) {
            this.control.accept(this);
            this.velocity.addLocal(this.acceleration);
            x = this.position.x + this.velocity.x;
            y = this.position.y + this.velocity.y;
        } else if (this.equation == null) {
            x = (double)this.startPosition.x + (double)this.velocity.x * t + 0.5 * (double)this.acceleration.x * t * t;
            y = (double)this.startPosition.y + (double)this.velocity.y * t + 0.5 * (double)this.acceleration.y * t * t;
        } else {
            Point2D newPos = this.equation.apply(t);
            x = (double)this.startPosition.x + newPos.getX();
            y = (double)this.startPosition.y + newPos.getY();
        }
        this.moveVector.set((float)x - this.position.x, (float)y - this.position.y);
        this.position.set((float)x, (float)y);
        this.radius.addLocal(this.scale);
        this.life -= tpf;
        boolean bl = dead = this.life <= 0.0 || this.radius.x <= 0.0f || this.radius.y <= 0.0f;
        if (!dead) {
            double alpha = this.life / this.initialLife;
            if (this.image != null) {
                this.imageView.setScaleX((double)(this.radius.x * 2.0f) / this.image.getWidth());
                this.imageView.setScaleY((double)(this.radius.y * 2.0f) / this.image.getHeight());
                this.imageView.setLayoutX(x);
                this.imageView.setLayoutY(y);
                this.imageView.setOpacity(alpha);
                this.imageView.setBlendMode(this.blendMode);
                if (this.allowRotation) {
                    this.imageView.setRotate(this.moveVector.angle());
                }
            } else {
                this.view.setRadiusX(this.radius.x);
                this.view.setRadiusY(this.radius.y);
                this.view.setCenterX(this.radius.x);
                this.view.setCenterY(this.radius.y);
                this.view.setLayoutX(x);
                this.view.setLayoutY(y);
                this.view.setOpacity(alpha);
                this.view.setFill((Paint)this.colorAnimation.getValue(progress, this.interpolator));
                this.view.setBlendMode(this.blendMode);
                if (this.allowRotation) {
                    this.view.setRotate(this.moveVector.angle());
                }
            }
        }
        return dead;
    }
}

