/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.io;

import com.almasb.fxgl.io.FSService;
import com.almasb.fxgl.io.FSServiceImpl;
import com.almasb.fxgl.io.FileExtension;
import com.almasb.sslogger.Logger;
import com.gluonhq.attach.storage.StorageService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001b\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u001e\u0010 \u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/almasb/fxgl/io/FSServiceImpl;", "Lcom/almasb/fxgl/io/FSService;", "isDesktop", "", "(Z)V", "log", "Lcom/almasb/sslogger/Logger;", "rootStorage", "Ljava/io/File;", "kotlin.jvm.PlatformType", "checkExists", "", "file", "createDirectory", "dirName", "", "deleteDirectory", "deleteFile", "fileName", "exists", "pathName", "loadDirectoryNames", "", "recursive", "loadFileNames", "extensions", "Lcom/almasb/fxgl/io/FileExtension;", "loadLastModifiedFileName", "readData", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "toFile", "writeData", "data", "Ljava/io/Serializable;", "text", "fxgl-io"})
public final class FSServiceImpl
implements FSService {
    private final Logger log = Logger.Companion.get(this.getClass());
    private final File rootStorage;

    @Override
    public boolean exists(@NotNull String pathName) {
        Intrinsics.checkParameterIsNotNull(pathName, "pathName");
        return this.toFile(pathName).exists();
    }

    @Override
    public void createDirectory(@NotNull String dirName) {
        Intrinsics.checkParameterIsNotNull(dirName, "dirName");
        File dir = this.toFile(dirName);
        dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(@NotNull Serializable data, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(data, "data");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        File file = this.toFile(fileName);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            this.log.debug("Creating directories to: " + file.getParentFile());
            file.getParentFile().mkdirs();
        }
        Closeable closeable = new ObjectOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            this.log.debug("Writing to: " + file);
            it.writeObject(data);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    public void writeData(@NotNull List<String> text, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        File file = this.toFile(fileName);
        FilesKt.writeText$default(file, CollectionsKt.joinToString$default(text, "\n", null, null, 0, null, null, 62, null), null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readData(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        File file = this.toFile(fileName);
        Closeable closeable = new ObjectInputStream(new FileInputStream(file));
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl = false;
            this.log.debug("Reading from: " + file);
            Object object = it.readObject();
            return (T)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Override
    @NotNull
    public List<String> loadFileNames(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkParameterIsNotNull(dirName, "dirName");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(FilesKt.walkTopDown(dir).maxDepth(recursive ? Integer.MAX_VALUE : 1), loadFileNames.1.INSTANCE), (Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = FilesKt.relativeTo(it, this.$dir).toString();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.relativeTo(dir).toString()");
                return StringsKt.replace$default(string, "\\", "/", false, 4, null);
            }
            {
                this.$dir = file;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public List<String> loadFileNames(@NotNull String dirName, boolean recursive, @NotNull List<FileExtension> extensions) {
        Intrinsics.checkParameterIsNotNull(dirName, "dirName");
        Intrinsics.checkParameterIsNotNull(extensions, "extensions");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(FilesKt.walkTopDown(dir).maxDepth(recursive ? Integer.MAX_VALUE : 1), (Function1)new Function1<File, Boolean>(extensions){
            final /* synthetic */ List $extensions;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull File file) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(file, "file");
                if (!file.isFile()) return false;
                Iterable iterable = $receiver$iv = (Iterable)this.$extensions;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    FileExtension it = (FileExtension)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default(String.valueOf(file), it.getExtension(), false, 2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection collection = (List)destination$iv$iv;
                if (collection.isEmpty()) return false;
                return true;
            }
            {
                this.$extensions = list;
                super(1);
            }
        }), (Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = FilesKt.relativeTo(it, this.$dir).toString();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.relativeTo(dir).toString()");
                return StringsKt.replace$default(string, "\\", "/", false, 4, null);
            }
            {
                this.$dir = file;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public List<String> loadDirectoryNames(@NotNull String dirName, boolean recursive) {
        Intrinsics.checkParameterIsNotNull(dirName, "dirName");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        return SequencesKt.toList(SequencesKt.filter(SequencesKt.map(SequencesKt.filter(FilesKt.walkTopDown(dir).maxDepth(recursive ? Integer.MAX_VALUE : 1), loadDirectoryNames.1.INSTANCE), (Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = FilesKt.relativeTo(it, this.$dir).toString();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.relativeTo(dir).toString()");
                return StringsKt.replace$default(string, "\\", "/", false, 4, null);
            }
            {
                this.$dir = file;
                super(1);
            }
        }), loadDirectoryNames.3.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String loadLastModifiedFileName(@NotNull String dirName, boolean recursive) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(dirName, "dirName");
        File dir = this.toFile(dirName);
        this.checkExists(dir);
        Sequence sequence = SequencesKt.filter(FilesKt.walkTopDown(dir).maxDepth(recursive ? Integer.MAX_VALUE : 1), loadLastModifiedFileName.1.INSTANCE);
        void var5_5 = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                Long l = it.lastModified();
                return ComparisonsKt.compareValues(comparable2, (Comparable)l);
            }
        };
        String string = (String)SequencesKt.firstOrNull(SequencesKt.map(SequencesKt.sortedWith(var5_5, comparator), (Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = FilesKt.relativeTo(it, this.$dir).toString();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.relativeTo(dir).toString()");
                return StringsKt.replace$default(string, "\\", "/", false, 4, null);
            }
            {
                this.$dir = file;
                super(1);
            }
        }));
        if (string == null) {
            throw (Throwable)new FileNotFoundException("No files found in " + dir);
        }
        return string;
    }

    @Override
    public void deleteFile(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        File file = this.toFile(fileName);
        this.checkExists(file);
        file.delete();
    }

    @Override
    public void deleteDirectory(@NotNull String dirName) {
        Intrinsics.checkParameterIsNotNull(dirName, "dirName");
        File file = this.toFile(dirName);
        this.checkExists(file);
        FilesKt.deleteRecursively(file);
    }

    private final File toFile(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = this.rootStorage;
        Intrinsics.checkExpressionValueIsNotNull(file, "rootStorage");
        return new File(stringBuilder.append(file.getAbsolutePath()).append(File.separatorChar).append(fileName).toString());
    }

    private final void checkExists(File file) {
        if (!file.exists()) {
            throw (Throwable)new FileNotFoundException("Path " + file + " does not exist");
        }
    }

    public FSServiceImpl(boolean isDesktop) {
        this.rootStorage = isDesktop ? new File(System.getProperty("user.dir") + "/") : (File)StorageService.create().flatMap(rootStorage.1.INSTANCE).orElseThrow(rootStorage.2.INSTANCE);
    }
}

