/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input;

import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.MouseTrigger$Companion$WhenMappings;
import com.almasb.fxgl.input.MouseTrigger$WhenMappings;
import com.almasb.fxgl.input.Trigger;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/almasb/fxgl/input/MouseTrigger;", "Lcom/almasb/fxgl/input/Trigger;", "button", "Ljavafx/scene/input/MouseButton;", "modifier", "Lcom/almasb/fxgl/input/InputModifier;", "(Ljavafx/scene/input/MouseButton;Lcom/almasb/fxgl/input/InputModifier;)V", "getButton", "()Ljavafx/scene/input/MouseButton;", "isButton", "", "()Z", "isKey", "getModifier", "()Lcom/almasb/fxgl/input/InputModifier;", "name", "", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "isReleased", "event", "Ljavafx/scene/input/InputEvent;", "isTriggered", "toString", "Companion", "fxgl-input"})
public final class MouseTrigger
implements Trigger {
    @NotNull
    private final String name;
    private final boolean isKey = false;
    private final boolean isButton = true;
    @NotNull
    private final MouseButton button;
    @NotNull
    private final InputModifier modifier;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isKey() {
        return this.isKey;
    }

    @Override
    public boolean isButton() {
        return this.isButton;
    }

    @Override
    public boolean isTriggered(@NotNull InputEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        return ((MouseEvent)event).getButton() == this.button && this.getModifier().isTriggered((MouseEvent)event);
    }

    @Override
    public boolean isReleased(@NotNull InputEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (event instanceof KeyEvent) {
            KeyCode keyCode = ((KeyEvent)event).getCode();
            if (keyCode != null) {
                switch (MouseTrigger$WhenMappings.$EnumSwitchMapping$0[keyCode.ordinal()]) {
                    case 1: {
                        return this.getModifier() == InputModifier.CTRL;
                    }
                    case 2: {
                        return this.getModifier() == InputModifier.SHIFT;
                    }
                    case 3: {
                        return this.getModifier() == InputModifier.ALT;
                    }
                }
            }
        }
        return this.isTriggered(event);
    }

    @NotNull
    public String toString() {
        return (this.getModifier() == InputModifier.NONE ? "" : "" + (Object)((Object)this.getModifier()) + '+') + this.getName();
    }

    @NotNull
    public final MouseButton getButton() {
        return this.button;
    }

    @Override
    @NotNull
    public InputModifier getModifier() {
        return this.modifier;
    }

    @JvmOverloads
    public MouseTrigger(@NotNull MouseButton button, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        this.button = button;
        this.modifier = modifier;
        this.name = Companion.buttonToString(this.button);
        this.isButton = true;
    }

    @JvmOverloads
    public /* synthetic */ MouseTrigger(MouseButton mouseButton, InputModifier inputModifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        this(mouseButton, inputModifier);
    }

    @JvmOverloads
    public MouseTrigger(@NotNull MouseButton button) {
        this(button, null, 2, null);
    }

    @NotNull
    public final MouseButton component1() {
        return this.button;
    }

    @NotNull
    public final InputModifier component2() {
        return this.getModifier();
    }

    @NotNull
    public final MouseTrigger copy(@NotNull MouseButton button, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        return new MouseTrigger(button, modifier);
    }

    @NotNull
    public static /* synthetic */ MouseTrigger copy$default(MouseTrigger mouseTrigger, MouseButton mouseButton, InputModifier inputModifier, int n, Object object) {
        if ((n & 1) != 0) {
            mouseButton = mouseTrigger.button;
        }
        if ((n & 2) != 0) {
            inputModifier = mouseTrigger.getModifier();
        }
        return mouseTrigger.copy(mouseButton, inputModifier);
    }

    public int hashCode() {
        MouseButton mouseButton = this.button;
        InputModifier inputModifier = this.getModifier();
        return (mouseButton != null ? ((Object)((Object)mouseButton)).hashCode() : 0) * 31 + (inputModifier != null ? ((Object)((Object)inputModifier)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MouseTrigger)) break block3;
                MouseTrigger mouseTrigger = (MouseTrigger)object;
                if (!Intrinsics.areEqual((Object)this.button, (Object)mouseTrigger.button) || !Intrinsics.areEqual((Object)this.getModifier(), (Object)mouseTrigger.getModifier())) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/almasb/fxgl/input/MouseTrigger$Companion;", "", "()V", "buttonFromString", "Ljavafx/scene/input/MouseButton;", "value", "", "buttonToString", "button", "fxgl-input"})
    public static final class Companion {
        @NotNull
        public final MouseButton buttonFromString(@NotNull String value) {
            MouseButton mouseButton;
            Intrinsics.checkParameterIsNotNull(value, "value");
            switch (value) {
                case "LMB": {
                    mouseButton = MouseButton.PRIMARY;
                    break;
                }
                case "MMB": {
                    mouseButton = MouseButton.MIDDLE;
                    break;
                }
                case "RMB": {
                    mouseButton = MouseButton.SECONDARY;
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("Must be one of [LMB, MMB, RMB]");
                }
            }
            return mouseButton;
        }

        @NotNull
        public final String buttonToString(@NotNull MouseButton button) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)button, "button");
            switch (MouseTrigger$Companion$WhenMappings.$EnumSwitchMapping$0[button.ordinal()]) {
                case 1: {
                    string = "LMB";
                    break;
                }
                case 2: {
                    string = "MMB";
                    break;
                }
                case 3: {
                    string = "RMB";
                    break;
                }
                default: {
                    throw (Throwable)new RuntimeException("Not a mouse button");
                }
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

