/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input;

import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.KeyTrigger;
import com.almasb.fxgl.input.MouseEventData;
import com.almasb.fxgl.input.MouseTrigger;
import com.almasb.fxgl.input.ObservableTrigger;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.virtual.VirtualButton;
import com.almasb.sslogger.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 t2\u00020\u0001:\u0001tB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020/2\b\b\u0002\u00105\u001a\u000206H\u0007J\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020/2\u0006\u00107\u001a\u00020.J\"\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00052\u0006\u00108\u001a\u0002092\b\b\u0002\u00105\u001a\u000206H\u0007J\u0018\u0010:\u001a\u0002022\u0006\u00103\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0006H\u0002J.\u0010<\u001a\u000202\"\b\b\u0000\u0010=*\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H=0@2\u000e\u0010A\u001a\n\u0012\u0006\b\u0000\u0012\u0002H=0BJ\u0018\u0010C\u001a\u0002022\u0006\u00107\u001a\u00020.2\u0006\u00104\u001a\u00020/H\u0002J\u0006\u0010D\u001a\u000202J\u000e\u0010E\u001a\u0002022\u0006\u0010F\u001a\u00020>J\u000e\u0010G\u001a\u00020\u00052\u0006\u0010H\u001a\u00020IJ\u000e\u0010J\u001a\u00020I2\u0006\u00103\u001a\u00020\u0005J\u000e\u0010J\u001a\u00020I2\u0006\u0010H\u001a\u00020IJ\u000e\u0010K\u001a\u00020\u00132\u0006\u0010L\u001a\u00020\u0013J\u000e\u0010M\u001a\u00020\u00132\u0006\u0010L\u001a\u00020\u0013J\u0010\u0010N\u001a\u0002022\u0006\u0010F\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u0002022\u0006\u0010F\u001a\u00020OH\u0002J\u0010\u0010Q\u001a\u00020$2\u0006\u0010;\u001a\u00020\u0006H\u0002J&\u0010R\u001a\u00020S2\u0006\u00104\u001a\u00020/2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020S0@2\u0006\u00105\u001a\u000206H\u0002J6\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u0002092\f\u0010?\u001a\b\u0012\u0004\u0012\u00020U0@2\u0006\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u00192\u0006\u00105\u001a\u000206H\u0002J\u001a\u0010Y\u001a\u0002022\u0006\u00108\u001a\u0002092\b\b\u0002\u0010Z\u001a\u000206H\u0007J*\u0010Y\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u00192\b\b\u0002\u00105\u001a\u000206H\u0007J\u001a\u0010[\u001a\u0002022\u0006\u00108\u001a\u0002092\b\b\u0002\u0010Z\u001a\u000206H\u0007J*\u0010[\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u00192\b\b\u0002\u00105\u001a\u000206H\u0007J\u001a\u0010\\\u001a\u0002022\u0006\u00104\u001a\u00020/2\b\b\u0002\u00105\u001a\u000206H\u0007J\u001a\u0010]\u001a\u0002022\u0006\u00104\u001a\u00020/2\b\b\u0002\u00105\u001a\u000206H\u0007J\u000e\u0010^\u001a\u0002022\u0006\u0010_\u001a\u00020SJ\u000e\u0010`\u001a\u0002022\u0006\u0010a\u001a\u00020bJ&\u0010`\u001a\u0002022\u0006\u0010c\u001a\u00020U2\u0006\u0010d\u001a\u00020\u00132\u0006\u0010e\u001a\u00020\u00192\u0006\u0010f\u001a\u00020\u0019J\u0015\u0010g\u001a\u0002022\u0006\u00107\u001a\u00020.H\u0000\u00a2\u0006\u0002\bhJ\u0018\u0010i\u001a\u00020$2\u0006\u00103\u001a\u00020\u00052\u0006\u0010j\u001a\u00020\u0006H\u0002J\"\u0010i\u001a\u00020$2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020/2\b\b\u0002\u00105\u001a\u000206H\u0007J\"\u0010i\u001a\u00020$2\u0006\u00103\u001a\u00020\u00052\u0006\u00108\u001a\u0002092\b\b\u0002\u00105\u001a\u000206H\u0007J\u0015\u0010k\u001a\u0002022\u0006\u00107\u001a\u00020.H\u0000\u00a2\u0006\u0002\blJ.\u0010m\u001a\u000202\"\b\b\u0000\u0010=*\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H=0@2\u000e\u0010A\u001a\n\u0012\u0006\b\u0000\u0012\u0002H=0BJ\u000e\u0010n\u001a\u00020o2\u0006\u00103\u001a\u00020\u0005J\u001c\u0010p\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00060\u00060q2\u0006\u00103\u001a\u00020\u0005J\u000e\u0010r\u001a\u0002022\u0006\u0010s\u001a\u00020\u0019R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u0005 \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R*\u0010,\u001a\u001e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-j\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/`0X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lcom/almasb/fxgl/input/Input;", "", "()V", "allBindings", "", "Lcom/almasb/fxgl/input/UserAction;", "Lcom/almasb/fxgl/input/Trigger;", "getAllBindings", "()Ljava/util/Map;", "bindings", "Ljava/util/LinkedHashMap;", "Lcom/almasb/fxgl/input/ObservableTrigger;", "Lkotlin/collections/LinkedHashMap;", "currentActions", "Ljavafx/collections/ObservableList;", "kotlin.jvm.PlatformType", "eventHandlers", "Ljavafx/scene/Group;", "mousePositionUI", "Ljavafx/geometry/Point2D;", "getMousePositionUI", "()Ljavafx/geometry/Point2D;", "mousePositionWorld", "getMousePositionWorld", "<set-?>", "", "mouseXUI", "getMouseXUI", "()D", "mouseXWorld", "getMouseXWorld", "mouseYUI", "getMouseYUI", "mouseYWorld", "getMouseYWorld", "processInput", "", "getProcessInput", "()Z", "setProcessInput", "(Z)V", "registerInput", "getRegisterInput", "setRegisterInput", "virtualButtons", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/input/virtual/VirtualButton;", "Ljavafx/scene/input/KeyCode;", "Lkotlin/collections/HashMap;", "addAction", "", "action", "key", "modifier", "Lcom/almasb/fxgl/input/InputModifier;", "virtualButton", "button", "Ljavafx/scene/input/MouseButton;", "addBinding", "trigger", "addEventHandler", "T", "Ljavafx/event/Event;", "eventType", "Ljavafx/event/EventType;", "eventHandler", "Ljavafx/event/EventHandler;", "addVirtualButton", "clearAll", "fireEvent", "event", "getActionByName", "actionName", "", "getTriggerName", "getVectorFromMouse", "gamePosition", "getVectorToMouse", "handlePressed", "Ljavafx/scene/input/InputEvent;", "handleReleased", "isTriggerBound", "makeKeyEvent", "Ljavafx/scene/input/KeyEvent;", "makeMouseEvent", "Ljavafx/scene/input/MouseEvent;", "btn", "gameX", "gameY", "mockButtonPress", "inputModifier", "mockButtonRelease", "mockKeyPress", "mockKeyRelease", "onKeyEvent", "keyEvent", "onMouseEvent", "eventData", "Lcom/almasb/fxgl/input/MouseEventData;", "mouseEvent", "viewportOrigin", "scaleRatioX", "scaleRatioY", "pressVirtual", "pressVirtual$fxgl_input", "rebind", "newTrigger", "releaseVirtual", "releaseVirtual$fxgl_input", "removeEventHandler", "triggerNameProperty", "Ljavafx/beans/property/ReadOnlyStringProperty;", "triggerProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "update", "tpf", "Companion", "fxgl-input"})
public final class Input {
    private double mouseXWorld;
    private double mouseYWorld;
    private double mouseXUI;
    private double mouseYUI;
    private final LinkedHashMap<UserAction, ObservableTrigger> bindings = new LinkedHashMap();
    private final ObservableList<UserAction> currentActions = FXCollections.observableArrayList();
    private boolean processInput = true;
    private boolean registerInput = true;
    private final Group eventHandlers = new Group();
    private final HashMap<VirtualButton, KeyCode> virtualButtons;
    private static final KeyCode[] ILLEGAL_KEYS;
    private static final Logger log;
    public static final Companion Companion;

    public final double getMouseXWorld() {
        return this.mouseXWorld;
    }

    public final double getMouseYWorld() {
        return this.mouseYWorld;
    }

    @NotNull
    public final Point2D getMousePositionWorld() {
        return new Point2D(this.mouseXWorld, this.mouseYWorld);
    }

    public final double getMouseXUI() {
        return this.mouseXUI;
    }

    public final double getMouseYUI() {
        return this.mouseYUI;
    }

    @NotNull
    public final Point2D getMousePositionUI() {
        return new Point2D(this.mouseXUI, this.mouseYUI);
    }

    @NotNull
    public final Point2D getVectorToMouse(@NotNull Point2D gamePosition) {
        Intrinsics.checkParameterIsNotNull(gamePosition, "gamePosition");
        Point2D point2D = this.getMousePositionWorld().subtract(gamePosition);
        Intrinsics.checkExpressionValueIsNotNull(point2D, "mousePositionWorld.subtract(gamePosition)");
        return point2D;
    }

    @NotNull
    public final Point2D getVectorFromMouse(@NotNull Point2D gamePosition) {
        Intrinsics.checkParameterIsNotNull(gamePosition, "gamePosition");
        Point2D point2D = this.getVectorToMouse(gamePosition).multiply(-1.0);
        Intrinsics.checkExpressionValueIsNotNull(point2D, "getVectorToMouse(gamePosition).multiply(-1.0)");
        return point2D;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<UserAction, Trigger> getAllBindings() {
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)this.bindings;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $$_$_obsTrigger;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl = false;
            void var12_12 = $$_$_obsTrigger;
            ObservableTrigger obsTrigger = (ObservableTrigger)var12_12.getValue();
            Trigger trigger = (Trigger)obsTrigger.getTrigger().getValue();
            map3.put(k2, trigger);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final String getTriggerName(@NotNull UserAction action) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        String string = this.triggerNameProperty(action).getValue();
        Intrinsics.checkExpressionValueIsNotNull(string, "triggerNameProperty(action).value");
        return string;
    }

    @NotNull
    public final String getTriggerName(@NotNull String actionName) {
        Intrinsics.checkParameterIsNotNull(actionName, "actionName");
        return this.getTriggerName(this.getActionByName(actionName));
    }

    @NotNull
    public final ReadOnlyStringProperty triggerNameProperty(@NotNull UserAction action) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        Object object = this.bindings.get(action);
        if (object == null || (object = ((ObservableTrigger)object).getName()) == null || (object = ((ReadOnlyStringWrapper)object).getReadOnlyProperty()) == null) {
            throw (Throwable)new IllegalArgumentException("Action " + action + " not found");
        }
        return object;
    }

    @NotNull
    public final ReadOnlyObjectProperty<Trigger> triggerProperty(@NotNull UserAction action) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        Object object = this.bindings.get(action);
        if (object == null || (object = ((ObservableTrigger)object).getTrigger()) == null || (object = ((ReadOnlyObjectWrapper)object).getReadOnlyProperty()) == null) {
            throw (Throwable)new IllegalArgumentException("Action " + action + " not found");
        }
        return object;
    }

    @NotNull
    public final UserAction getActionByName(@NotNull String actionName) {
        Object v1;
        block2: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(actionName, "actionName");
            Set<UserAction> set = this.bindings.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, "bindings.keys");
            Iterable iterable2 = iterable = (Iterable)set;
            for (Object t : iterable2) {
                UserAction it = (UserAction)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), actionName)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        UserAction userAction = v1;
        if (userAction == null) {
            throw (Throwable)new IllegalArgumentException("Action " + actionName + " not found");
        }
        return userAction;
    }

    public final boolean getProcessInput() {
        return this.processInput;
    }

    public final void setProcessInput(boolean bl) {
        this.processInput = bl;
    }

    public final boolean getRegisterInput() {
        return this.registerInput;
    }

    public final void setRegisterInput(boolean bl) {
        this.registerInput = bl;
    }

    public final <T extends Event> void addEventHandler(@NotNull EventType<T> eventType, @NotNull EventHandler<? super T> eventHandler) {
        Intrinsics.checkParameterIsNotNull(eventType, "eventType");
        Intrinsics.checkParameterIsNotNull(eventHandler, "eventHandler");
        this.eventHandlers.addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(@NotNull EventType<T> eventType, @NotNull EventHandler<? super T> eventHandler) {
        Intrinsics.checkParameterIsNotNull(eventType, "eventType");
        Intrinsics.checkParameterIsNotNull(eventHandler, "eventHandler");
        this.eventHandlers.removeEventHandler(eventType, eventHandler);
    }

    public final void fireEvent(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        this.eventHandlers.fireEvent(event);
    }

    /*
     * WARNING - void declaration
     */
    public final void update(double tpf) {
        if (!this.processInput) {
            return;
        }
        int n = 0;
        ObservableList<UserAction> observableList = this.currentActions;
        Intrinsics.checkExpressionValueIsNotNull(observableList, "currentActions");
        int n2 = ((Collection)observableList).size();
        while (n < n2) {
            void i;
            ((UserAction)this.currentActions.get((int)i)).action$fxgl_input();
            ++i;
        }
    }

    public final void onKeyEvent(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkParameterIsNotNull(keyEvent, "keyEvent");
        if (!this.registerInput) {
            return;
        }
        if (Intrinsics.areEqual(keyEvent.getEventType(), KeyEvent.KEY_PRESSED)) {
            this.handlePressed(keyEvent);
        } else if (Intrinsics.areEqual(keyEvent.getEventType(), KeyEvent.KEY_RELEASED)) {
            this.handleReleased(keyEvent);
        }
    }

    public final void onMouseEvent(@NotNull MouseEventData eventData) {
        Intrinsics.checkParameterIsNotNull(eventData, "eventData");
        this.onMouseEvent(eventData.getEvent(), eventData.getViewportOrigin(), eventData.getScaleRatioX(), eventData.getScaleRatioY());
    }

    public final void onMouseEvent(@NotNull MouseEvent mouseEvent, @NotNull Point2D viewportOrigin, double scaleRatioX, double scaleRatioY) {
        Intrinsics.checkParameterIsNotNull(mouseEvent, "mouseEvent");
        Intrinsics.checkParameterIsNotNull(viewportOrigin, "viewportOrigin");
        if (!this.registerInput) {
            return;
        }
        if (Intrinsics.areEqual(mouseEvent.getEventType(), MouseEvent.MOUSE_PRESSED)) {
            this.handlePressed(mouseEvent);
        } else if (Intrinsics.areEqual(mouseEvent.getEventType(), MouseEvent.MOUSE_RELEASED)) {
            this.handleReleased(mouseEvent);
        }
        this.mouseXUI = mouseEvent.getSceneX();
        this.mouseYUI = mouseEvent.getSceneY();
        this.mouseXWorld = this.mouseXUI / scaleRatioX + viewportOrigin.getX();
        this.mouseYWorld = this.mouseYUI / scaleRatioY + viewportOrigin.getY();
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePressed(InputEvent event) {
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)this.bindings;
        Map destination$iv$iv = new LinkedHashMap();
        void var5_5 = $receiver$iv$iv;
        Iterator iterator2 = var5_5.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $act_trigger = element$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = $act_trigger;
            UserAction act = (UserAction)entry.getKey();
            entry = $act_trigger;
            ObservableTrigger trigger = (ObservableTrigger)entry.getValue();
            if (!(!this.currentActions.contains(act) && trigger.isTriggered(event))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $receiver$iv = destination$iv$iv;
        map = $receiver$iv;
        Iterator iterator3 = map.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $act_$_$ = element$iv = iterator3.next();
            boolean bl = false;
            Map.Entry entry = $act_$_$;
            UserAction act = (UserAction)entry.getKey();
            this.currentActions.add(act);
            if (!this.processInput) continue;
            act.begin$fxgl_input();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleReleased(InputEvent event) {
        void $receiver$iv$iv;
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)this.bindings;
        Map destination$iv$iv = new LinkedHashMap();
        void var5_5 = $receiver$iv$iv;
        Iterator iterator2 = var5_5.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $act_trigger = element$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = $act_trigger;
            UserAction act = (UserAction)entry.getKey();
            entry = $act_trigger;
            ObservableTrigger trigger = (ObservableTrigger)entry.getValue();
            if (!(this.currentActions.contains(act) && trigger.isReleased(event))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $receiver$iv = destination$iv$iv;
        map = $receiver$iv;
        Iterator iterator3 = map.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $act_$_$ = element$iv = iterator3.next();
            boolean bl = false;
            Map.Entry entry = $act_$_$;
            UserAction act = (UserAction)entry.getKey();
            this.currentActions.remove(act);
            if (!this.processInput) continue;
            act.end$fxgl_input();
        }
    }

    public final void clearAll() {
        log.debug("Clearing active input actions");
        if (this.processInput) {
            ObservableList<UserAction> observableList = this.currentActions;
            Intrinsics.checkExpressionValueIsNotNull(observableList, "currentActions");
            Iterable $receiver$iv = observableList;
            for (Object element$iv : $receiver$iv) {
                UserAction it = (UserAction)element$iv;
                boolean bl = false;
                it.end$fxgl_input();
            }
        }
        this.currentActions.clear();
    }

    @JvmOverloads
    public final void addAction(@NotNull UserAction action, @NotNull MouseButton button, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        this.addBinding(action, new MouseTrigger(button, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ void addAction$default(Input input, UserAction userAction, MouseButton mouseButton, InputModifier inputModifier, int n, Object object) {
        if ((n & 4) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.addAction(userAction, mouseButton, inputModifier);
    }

    @JvmOverloads
    public final void addAction(@NotNull UserAction action, @NotNull MouseButton button) {
        Input.addAction$default(this, action, button, null, 4, null);
    }

    @JvmOverloads
    public final void addAction(@NotNull UserAction action, @NotNull KeyCode key, @NotNull InputModifier modifier) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(action, "action");
        Intrinsics.checkParameterIsNotNull((Object)key, "key");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        boolean bl2 = bl = !Companion.isIllegal(key);
        if (!bl) {
            boolean bl3 = false;
            String string = "Cannot bind to illegal key: " + (Object)((Object)key);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.addBinding(action, new KeyTrigger(key, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ void addAction$default(Input input, UserAction userAction, KeyCode keyCode, InputModifier inputModifier, int n, Object object) {
        if ((n & 4) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.addAction(userAction, keyCode, inputModifier);
    }

    @JvmOverloads
    public final void addAction(@NotNull UserAction action, @NotNull KeyCode key) {
        Input.addAction$default(this, action, key, null, 4, null);
    }

    private final void addBinding(UserAction action, Trigger trigger) {
        boolean bl;
        boolean bl2 = bl = !this.bindings.containsKey(action);
        if (!bl) {
            boolean bl3 = false;
            String string = "Action already exists: " + action.getName();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = !this.isTriggerBound(trigger);
        if (!bl) {
            boolean bl5 = false;
            String string = "Trigger is already bound: " + trigger;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Map map = this.bindings;
        ObservableTrigger observableTrigger = new ObservableTrigger(trigger);
        map.put(action, observableTrigger);
        log.debug("Registered new binding: " + action + " - " + trigger);
    }

    @JvmOverloads
    public final boolean rebind(@NotNull UserAction action, @NotNull KeyCode key, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        Intrinsics.checkParameterIsNotNull((Object)key, "key");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        return this.rebind(action, new KeyTrigger(key, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ boolean rebind$default(Input input, UserAction userAction, KeyCode keyCode, InputModifier inputModifier, int n, Object object) {
        if ((n & 4) != 0) {
            inputModifier = InputModifier.NONE;
        }
        return input.rebind(userAction, keyCode, inputModifier);
    }

    @JvmOverloads
    public final boolean rebind(@NotNull UserAction action, @NotNull KeyCode key) {
        return Input.rebind$default(this, action, key, null, 4, null);
    }

    @JvmOverloads
    public final boolean rebind(@NotNull UserAction action, @NotNull MouseButton button, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        return this.rebind(action, new MouseTrigger(button, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ boolean rebind$default(Input input, UserAction userAction, MouseButton mouseButton, InputModifier inputModifier, int n, Object object) {
        if ((n & 4) != 0) {
            inputModifier = InputModifier.NONE;
        }
        return input.rebind(userAction, mouseButton, inputModifier);
    }

    @JvmOverloads
    public final boolean rebind(@NotNull UserAction action, @NotNull MouseButton button) {
        return Input.rebind$default(this, action, button, null, 4, null);
    }

    private final boolean rebind(UserAction action, Trigger newTrigger) {
        if (!this.bindings.containsKey(action) || this.isTriggerBound(newTrigger)) {
            return false;
        }
        ObservableTrigger observableTrigger = this.bindings.get(action);
        if (observableTrigger == null) {
            Intrinsics.throwNpe();
        }
        observableTrigger.getTrigger().setValue(newTrigger);
        return true;
    }

    private final boolean isTriggerBound(Trigger trigger) {
        boolean bl;
        block3: {
            Collection<ObservableTrigger> collection = this.bindings.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, "bindings.values");
            Iterable $receiver$iv = collection;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ObservableTrigger it = (ObservableTrigger)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Trigger)it.getTrigger().getValue(), trigger)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void addAction(@NotNull UserAction action, @NotNull KeyCode key, @NotNull VirtualButton virtualButton) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(action, "action");
        Intrinsics.checkParameterIsNotNull((Object)key, "key");
        Intrinsics.checkParameterIsNotNull((Object)virtualButton, "virtualButton");
        boolean bl2 = bl = !Companion.isIllegal(key);
        if (!bl) {
            boolean bl3 = false;
            String string = "Cannot bind to illegal key: " + (Object)((Object)key);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.addBinding(action, new KeyTrigger(key, InputModifier.NONE));
        this.addVirtualButton(virtualButton, key);
    }

    private final void addVirtualButton(VirtualButton virtualButton, KeyCode key) {
        Map map = this.virtualButtons;
        KeyCode keyCode = key;
        map.put(virtualButton, keyCode);
    }

    public final void pressVirtual$fxgl_input(@NotNull VirtualButton virtualButton) {
        block0: {
            KeyCode keyCode;
            Intrinsics.checkParameterIsNotNull((Object)virtualButton, "virtualButton");
            KeyCode keyCode2 = this.virtualButtons.get((Object)virtualButton);
            if (keyCode2 == null) break block0;
            KeyCode it = keyCode = keyCode2;
            boolean bl = false;
            KeyCode keyCode3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyCode3, "it");
            Input.mockKeyPress$default(this, keyCode3, null, 2, null);
        }
    }

    public final void releaseVirtual$fxgl_input(@NotNull VirtualButton virtualButton) {
        block0: {
            KeyCode keyCode;
            Intrinsics.checkParameterIsNotNull((Object)virtualButton, "virtualButton");
            KeyCode keyCode2 = this.virtualButtons.get((Object)virtualButton);
            if (keyCode2 == null) break block0;
            KeyCode it = keyCode = keyCode2;
            boolean bl = false;
            KeyCode keyCode3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyCode3, "it");
            Input.mockKeyRelease$default(this, keyCode3, null, 2, null);
        }
    }

    @JvmOverloads
    public final void mockKeyPress(@NotNull KeyCode key, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull((Object)key, "key");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        log.debug("Mocking key press: " + new KeyTrigger(key, modifier));
        EventType<KeyEvent> eventType = KeyEvent.KEY_PRESSED;
        Intrinsics.checkExpressionValueIsNotNull(eventType, "KeyEvent.KEY_PRESSED");
        this.handlePressed(this.makeKeyEvent(key, eventType, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ void mockKeyPress$default(Input input, KeyCode keyCode, InputModifier inputModifier, int n, Object object) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.mockKeyPress(keyCode, inputModifier);
    }

    @JvmOverloads
    public final void mockKeyPress(@NotNull KeyCode key) {
        Input.mockKeyPress$default(this, key, null, 2, null);
    }

    @JvmOverloads
    public final void mockKeyRelease(@NotNull KeyCode key, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull((Object)key, "key");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        log.debug("Mocking key release: " + new KeyTrigger(key, modifier));
        EventType<KeyEvent> eventType = KeyEvent.KEY_RELEASED;
        Intrinsics.checkExpressionValueIsNotNull(eventType, "KeyEvent.KEY_RELEASED");
        this.handleReleased(this.makeKeyEvent(key, eventType, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ void mockKeyRelease$default(Input input, KeyCode keyCode, InputModifier inputModifier, int n, Object object) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.mockKeyRelease(keyCode, inputModifier);
    }

    @JvmOverloads
    public final void mockKeyRelease(@NotNull KeyCode key) {
        Input.mockKeyRelease$default(this, key, null, 2, null);
    }

    private final KeyEvent makeKeyEvent(KeyCode key, EventType<KeyEvent> eventType, InputModifier modifier) {
        return new KeyEvent(eventType, "", key.toString(), key, modifier == InputModifier.SHIFT, modifier == InputModifier.CTRL, modifier == InputModifier.ALT, false);
    }

    @JvmOverloads
    public final void mockButtonPress(@NotNull MouseButton button, double gameX, double gameY, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        log.debug("Mocking button press: " + new MouseTrigger(button, modifier) + " at " + gameX + ", " + gameY);
        this.mouseXWorld = gameX;
        this.mouseYWorld = gameY;
        EventType<MouseEvent> eventType = MouseEvent.MOUSE_PRESSED;
        Intrinsics.checkExpressionValueIsNotNull(eventType, "MouseEvent.MOUSE_PRESSED");
        this.handlePressed(this.makeMouseEvent(button, eventType, gameX, gameY, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ void mockButtonPress$default(Input input, MouseButton mouseButton, double d, double d2, InputModifier inputModifier, int n, Object object) {
        if ((n & 8) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.mockButtonPress(mouseButton, d, d2, inputModifier);
    }

    @JvmOverloads
    public final void mockButtonPress(@NotNull MouseButton button, double gameX, double gameY) {
        Input.mockButtonPress$default(this, button, gameX, gameY, null, 8, null);
    }

    @JvmOverloads
    public final void mockButtonPress(@NotNull MouseButton button, @NotNull InputModifier inputModifier) {
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)inputModifier, "inputModifier");
        this.mockButtonPress(button, this.mouseXWorld, this.mouseYWorld, inputModifier);
    }

    @JvmOverloads
    public static /* synthetic */ void mockButtonPress$default(Input input, MouseButton mouseButton, InputModifier inputModifier, int n, Object object) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.mockButtonPress(mouseButton, inputModifier);
    }

    @JvmOverloads
    public final void mockButtonPress(@NotNull MouseButton button) {
        Input.mockButtonPress$default(this, button, null, 2, null);
    }

    @JvmOverloads
    public final void mockButtonRelease(@NotNull MouseButton button, double gameX, double gameY, @NotNull InputModifier modifier) {
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)modifier, "modifier");
        log.debug("Mocking button release: " + new MouseTrigger(button, modifier) + " at " + gameX + ", " + gameY);
        this.mouseXWorld = gameX;
        this.mouseYWorld = gameY;
        EventType<MouseEvent> eventType = MouseEvent.MOUSE_RELEASED;
        Intrinsics.checkExpressionValueIsNotNull(eventType, "MouseEvent.MOUSE_RELEASED");
        this.handleReleased(this.makeMouseEvent(button, eventType, gameX, gameY, modifier));
    }

    @JvmOverloads
    public static /* synthetic */ void mockButtonRelease$default(Input input, MouseButton mouseButton, double d, double d2, InputModifier inputModifier, int n, Object object) {
        if ((n & 8) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.mockButtonRelease(mouseButton, d, d2, inputModifier);
    }

    @JvmOverloads
    public final void mockButtonRelease(@NotNull MouseButton button, double gameX, double gameY) {
        Input.mockButtonRelease$default(this, button, gameX, gameY, null, 8, null);
    }

    @JvmOverloads
    public final void mockButtonRelease(@NotNull MouseButton button, @NotNull InputModifier inputModifier) {
        Intrinsics.checkParameterIsNotNull((Object)button, "button");
        Intrinsics.checkParameterIsNotNull((Object)inputModifier, "inputModifier");
        this.mockButtonRelease(button, this.mouseXWorld, this.mouseYWorld, inputModifier);
    }

    @JvmOverloads
    public static /* synthetic */ void mockButtonRelease$default(Input input, MouseButton mouseButton, InputModifier inputModifier, int n, Object object) {
        if ((n & 2) != 0) {
            inputModifier = InputModifier.NONE;
        }
        input.mockButtonRelease(mouseButton, inputModifier);
    }

    @JvmOverloads
    public final void mockButtonRelease(@NotNull MouseButton button) {
        Input.mockButtonRelease$default(this, button, null, 2, null);
    }

    private final MouseEvent makeMouseEvent(MouseButton btn, EventType<MouseEvent> eventType, double gameX, double gameY, InputModifier modifier) {
        return new MouseEvent(eventType, gameX, gameY, gameX, gameY, btn, 0, modifier == InputModifier.SHIFT, modifier == InputModifier.CTRL, modifier == InputModifier.ALT, false, false, false, false, false, false, false, null);
    }

    public Input() {
        Input input = this;
        HashMap hashMap = new HashMap();
        input.virtualButtons = hashMap;
    }

    static {
        Companion = new Companion(null);
        ILLEGAL_KEYS = new KeyCode[]{KeyCode.CONTROL, KeyCode.SHIFT, KeyCode.ALT};
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        log = this_$iv.get(Input.class);
    }

    @JvmStatic
    public static final boolean isIllegal(@NotNull KeyCode key) {
        return Companion.isIllegal(key);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/input/Input$Companion;", "", "()V", "ILLEGAL_KEYS", "", "Ljavafx/scene/input/KeyCode;", "[Ljavafx/scene/input/KeyCode;", "log", "Lcom/almasb/sslogger/Logger;", "isIllegal", "", "key", "fxgl-input"})
    public static final class Companion {
        @JvmStatic
        public final boolean isIllegal(@NotNull KeyCode key) {
            Intrinsics.checkParameterIsNotNull((Object)key, "key");
            return ArraysKt.contains(ILLEGAL_KEYS, key);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

