/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity.level.tiled;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.fxgl.entity.level.LevelLoader;
import com.almasb.fxgl.entity.level.LevelLoadingException;
import com.almasb.fxgl.entity.level.tiled.Layer;
import com.almasb.fxgl.entity.level.tiled.TMXLevelLoaderKt;
import com.almasb.fxgl.entity.level.tiled.TiledMap;
import com.almasb.fxgl.entity.level.tiled.TiledObject;
import com.almasb.fxgl.entity.level.tiled.Tileset;
import com.almasb.fxgl.entity.level.tiled.TilesetLoader;
import com.almasb.sslogger.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javafx.scene.shape.Polygon;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/almasb/fxgl/entity/level/tiled/TMXLevelLoader;", "Lcom/almasb/fxgl/entity/level/LevelLoader;", "()V", "log", "Lcom/almasb/sslogger/Logger;", "createObjectLayerEntities", "", "Lcom/almasb/fxgl/entity/Entity;", "map", "Lcom/almasb/fxgl/entity/level/tiled/TiledMap;", "tilesetLoader", "Lcom/almasb/fxgl/entity/level/tiled/TilesetLoader;", "world", "Lcom/almasb/fxgl/entity/GameWorld;", "createTileLayerEntities", "load", "Lcom/almasb/fxgl/entity/level/Level;", "url", "Ljava/net/URL;", "parse", "inputStream", "Ljava/io/InputStream;", "parseData", "", "layer", "Lcom/almasb/fxgl/entity/level/tiled/Layer;", "data", "", "start", "Ljavax/xml/stream/events/StartElement;", "parseImage", "tileset", "Lcom/almasb/fxgl/entity/level/tiled/Tileset;", "parseMap", "parseMapProperty", "parseObject", "obj", "Lcom/almasb/fxgl/entity/level/tiled/TiledObject;", "parseObjectGroupLayer", "parseObjectPolygon", "parseObjectProperty", "parseTileLayer", "parseTileset", "fxgl-entity"})
public final class TMXLevelLoader
implements LevelLoader {
    private final Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Level load(@NotNull URL url, @NotNull GameWorld world) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(world, "world");
        try {
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it;
                Intrinsics.checkExpressionValueIsNotNull(inputStream, "it");
                it = this.parse(inputStream);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Object map = it;
            this.log.debug("Parsed raw map: " + map);
            TilesetLoader tilesetLoader = new TilesetLoader((TiledMap)map, url);
            List<Entity> tileLayerEntities = this.createTileLayerEntities((TiledMap)map, tilesetLoader);
            List<Entity> objectEntities = this.createObjectLayerEntities((TiledMap)map, tilesetLoader, world);
            Level level = new Level(((TiledMap)map).getWidth() * ((TiledMap)map).getTilewidth(), ((TiledMap)map).getHeight() * ((TiledMap)map).getTileheight(), CollectionsKt.plus((Collection)tileLayerEntities, (Iterable)objectEntities));
            ((TiledMap)map).getProperties().forEach(new BiConsumer<String, Object>(level){
                final /* synthetic */ Level $level;

                public final void accept(@NotNull String key, @NotNull Object value) {
                    Intrinsics.checkParameterIsNotNull(key, "key");
                    Intrinsics.checkParameterIsNotNull(value, "value");
                    if (value instanceof Float) {
                        this.$level.getProperties().setValue(key, ((Number)value).floatValue());
                    } else {
                        this.$level.getProperties().setValue(key, value);
                    }
                }
                {
                    this.$level = level;
                }
            });
            return level;
        }
        catch (Exception e) {
            this.log.warning("Parse error", e);
            e.printStackTrace();
            throw (Throwable)new LevelLoadingException(String.valueOf(e.getMessage()), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createTileLayerEntities(TiledMap map, TilesetLoader tilesetLoader) {
        Layer it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.log.debug("Creating tile layer entities");
        Iterable iterable = $receiver$iv = (Iterable)map.getLayers();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getType(), "tilelayer")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void layer;
            Entity entity;
            it = (Layer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Entity it2 = entity = new Entity();
            boolean bl2 = false;
            ViewComponent.addChild$default(it2.getViewComponent(), tilesetLoader.loadView(layer.getName()), false, 2, null);
            Entity entity2 = entity;
            collection.add(entity2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> createObjectLayerEntities(TiledMap map, TilesetLoader tilesetLoader, GameWorld world) {
        Object it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        this.log.debug("Creating object layer entities");
        Iterable iterable = $receiver$iv = (Iterable)map.getLayers();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(((Layer)it).getType(), "objectgroup")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Layer)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((Layer)it).getObjects();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object $receiver$iv2;
            void tiledObject;
            it = (TiledObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpawnData data = new SpawnData(tiledObject.getX(), tiledObject.getY() - (tiledObject.getGid() == 0 ? 0 : tiledObject.getHeight()));
            Object object = data;
            SpawnData $receiver = object;
            boolean bl2 = false;
            $receiver.put("name", tiledObject.getName());
            $receiver.put("type", tiledObject.getType());
            $receiver.put("width", tiledObject.getWidth());
            $receiver.put("height", tiledObject.getHeight());
            $receiver.put("rotation", Float.valueOf(tiledObject.getRotation()));
            $receiver.put("id", tiledObject.getId());
            $receiver.put("gid", tiledObject.getGid());
            Object object2 = $receiver$iv2 = tiledObject.getProperties();
            Iterator<Map.Entry<String, Object>> iterator2 = object2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> it2 = element$iv = iterator2.next();
                boolean bl3 = false;
                $receiver.put(it2.getKey(), it2.getValue());
            }
            Object e = object = world.create(tiledObject.getType(), data);
            boolean bl4 = false;
            $receiver$iv2 = data.getData();
            object2 = $receiver$iv2.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                ObjectMap.Entry it3 = (ObjectMap.Entry)element$iv;
                boolean bl5 = false;
                ((Entity)e).setProperty((String)it3.key, it3.value);
            }
            ((Entity)e).setPosition(data.getX(), data.getY());
            ((Entity)e).setRotation(tiledObject.getRotation());
            if (tiledObject.getGid() != 0) {
                ViewComponent.addChild$default(((Entity)e).getViewComponent(), tilesetLoader.loadView(tiledObject.getGid()), false, 2, null);
            }
            Object object3 = object;
            collection.add(object3);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TiledMap parse(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream, "UTF-8");
        TiledMap map = new TiledMap(0, 0, 0, 0, null, null, null, null, null, 0, 0, null, null, false, null, null, 65535, null);
        ArrayList<Layer> layers = new ArrayList<Layer>();
        ArrayList<Tileset> tilesets = new ArrayList<Tileset>();
        Layer currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
        Tileset currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, 4095, null);
        TiledObject currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, null, null, 4095, null);
        boolean mapPropertiesFinished = false;
        while (eventReader.hasNext()) {
            EndElement endElement;
            String string;
            int n;
            XMLEvent event;
            XMLEvent xMLEvent = event = eventReader.nextEvent();
            Intrinsics.checkExpressionValueIsNotNull(xMLEvent, "event");
            if (xMLEvent.isStartElement()) {
                StartElement start;
                StartElement startElement = start = event.asStartElement();
                Intrinsics.checkExpressionValueIsNotNull(startElement, "start");
                QName qName = startElement.getName();
                Intrinsics.checkExpressionValueIsNotNull(qName, "start.name");
                if (qName.getLocalPart() != null) {
                    n = -1;
                    switch (string.hashCode()) {
                        case 100313435: {
                            if (!string.equals("image")) break;
                            n = 1;
                            break;
                        }
                        case 3076010: {
                            if (!string.equals("data")) break;
                            n = 2;
                            break;
                        }
                        case -397519558: {
                            if (!string.equals("polygon")) break;
                            n = 3;
                            break;
                        }
                        case -1314831628: {
                            if (!string.equals("tileset")) break;
                            n = 4;
                            break;
                        }
                        case -993141291: {
                            if (!string.equals("property")) break;
                            n = 5;
                            break;
                        }
                        case 107868: {
                            if (!string.equals("map")) break;
                            n = 6;
                            break;
                        }
                        case 102749521: {
                            if (!string.equals("layer")) break;
                            n = 7;
                            break;
                        }
                        case -1269857632: {
                            if (!string.equals("objectgroup")) break;
                            n = 8;
                            break;
                        }
                        case -1023368385: {
                            if (!string.equals("object")) break;
                            n = 9;
                            break;
                        }
                    }
                    switch (n) {
                        case 6: {
                            this.parseMap(map, start);
                            break;
                        }
                        case 4: {
                            currentTileset = new Tileset(0, null, null, 0, 0, 0, 0, 0, 0, 0, 0, null, 4095, null);
                            this.parseTileset(currentTileset, start);
                            break;
                        }
                        case 1: {
                            this.parseImage(currentTileset, start);
                            break;
                        }
                        case 7: {
                            currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                            this.parseTileLayer(currentLayer, start);
                            break;
                        }
                        case 2: {
                            XMLEventReader xMLEventReader = eventReader;
                            Intrinsics.checkExpressionValueIsNotNull(xMLEventReader, "eventReader");
                            String string2 = xMLEventReader.getElementText();
                            Intrinsics.checkExpressionValueIsNotNull(string2, "eventReader.elementText");
                            this.parseData(currentLayer, string2, start);
                            break;
                        }
                        case 8: {
                            currentLayer = new Layer(0, 0, null, null, false, 0, 0, null, null, 0.0f, null, 2047, null);
                            this.parseObjectGroupLayer(currentLayer, start);
                            break;
                        }
                        case 9: {
                            mapPropertiesFinished = true;
                            currentObject = new TiledObject(0, 0, 0, null, null, false, 0, 0, 0.0f, 0, null, null, 4095, null);
                            this.parseObject(currentLayer, currentObject, start);
                            break;
                        }
                        case 5: {
                            if (mapPropertiesFinished) {
                                this.parseObjectProperty(currentObject, start);
                                break;
                            }
                            this.parseMapProperty(map, start);
                            break;
                        }
                        case 3: {
                            this.parseObjectPolygon(currentObject, start);
                        }
                    }
                }
            }
            if (!event.isEndElement()) continue;
            EndElement endElement2 = endElement = event.asEndElement();
            Intrinsics.checkExpressionValueIsNotNull(endElement2, "endElement");
            QName qName = endElement2.getName();
            Intrinsics.checkExpressionValueIsNotNull(qName, "endElement.name");
            if (qName.getLocalPart() == null) continue;
            tmp = -1;
            switch (string.hashCode()) {
                case -1314831628: {
                    if (!string.equals("tileset")) break;
                    tmp = 1;
                    break;
                }
                case 102749521: {
                    if (!string.equals("layer")) break;
                    tmp = 2;
                    break;
                }
                case -1269857632: {
                    if (!string.equals("objectgroup")) break;
                    tmp = 2;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    tilesets.add(currentTileset);
                    break;
                }
                case 2: {
                    layers.add(currentLayer);
                }
            }
        }
        map.setLayers((List<Layer>)layers);
        map.setTilesets((List<Tileset>)tilesets);
        return map;
    }

    private final void parseMap(TiledMap map, StartElement start) {
        map.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        map.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        map.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        map.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        map.setNextobjectid(TMXLevelLoaderKt.access$getInt(start, "nextobjectid"));
        map.setType("map");
        map.setVersion(1);
        map.setInfinite(TMXLevelLoaderKt.access$getInt(start, "infinite") == 1);
        map.setBackgroundcolor(TMXLevelLoaderKt.access$getString(start, "backgroundcolor"));
        map.setOrientation(TMXLevelLoaderKt.access$getString(start, "orientation"));
        map.setRenderorder(TMXLevelLoaderKt.access$getString(start, "renderorder"));
        map.setTiledversion(TMXLevelLoaderKt.access$getString(start, "tiledversion"));
        if (Intrinsics.areEqual(map.getTiledversion(), "1.2.3") ^ true) {
            this.log.warning("TiledMap generated from " + map.getTiledversion() + ". Supported version: 1.2.3. Some features may not be parsed fully.");
        }
    }

    private final void parseTileset(Tileset tileset, StartElement start) {
        tileset.setFirstgid(TMXLevelLoaderKt.access$getInt(start, "firstgid"));
        tileset.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        tileset.setTilewidth(TMXLevelLoaderKt.access$getInt(start, "tilewidth"));
        tileset.setTileheight(TMXLevelLoaderKt.access$getInt(start, "tileheight"));
        tileset.setSpacing(TMXLevelLoaderKt.access$getInt(start, "spacing"));
        tileset.setTilecount(TMXLevelLoaderKt.access$getInt(start, "tilecount"));
        tileset.setColumns(TMXLevelLoaderKt.access$getInt(start, "columns"));
    }

    private final void parseImage(Tileset tileset, StartElement start) {
        tileset.setImage(TMXLevelLoaderKt.access$getString(start, "source"));
        tileset.setImagewidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        tileset.setImageheight(TMXLevelLoaderKt.access$getInt(start, "height"));
        tileset.setTransparentcolor(TMXLevelLoaderKt.access$getString(start, "trans"));
    }

    private final void parseTileLayer(Layer layer, StartElement start) {
        layer.setType("tilelayer");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        layer.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        layer.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        layer.setOpacity(TMXLevelLoaderKt.access$getFloat(start, "opacity"));
        layer.setVisible(TMXLevelLoaderKt.access$getInt(start, "visible") == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void parseData(Layer layer, String data, StartElement start) {
        switch (TMXLevelLoaderKt.access$getString(start, "encoding")) {
            case "csv": {
                Collection<Integer> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                Iterable iterable = StringsKt.split$default((CharSequence)StringsKt.replace$default(data, "\n", "", false, 4, null), new String[]{","}, false, 0, 6, null);
                Layer layer2 = layer;
                void var6_9 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void var13_31 = it;
                    Integer n = Integer.parseInt((String)var13_31);
                    collection.add(n);
                }
                collection = (List)destination$iv$iv;
                layer2.setData((List<Integer>)collection);
                break;
            }
            case "base64": {
                String $receiver$iv$iv = data;
                Base64.Decoder decoder2 = Base64.getDecoder();
                String string = $receiver$iv$iv;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                byte[] bytes = decoder2.decode(string2);
                switch (TMXLevelLoaderKt.access$getString(start, "compression")) {
                    case "zlib": {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Intrinsics.checkExpressionValueIsNotNull(bytes, "bytes");
                        Object object = bytes;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        InputStream inputStream = byteArrayInputStream;
                        object = new InflaterInputStream(inputStream);
                        Throwable throwable = null;
                        try {
                            InflaterInputStream it22 = (InflaterInputStream)object;
                            boolean bl = false;
                            long it22 = ByteStreamsKt.copyTo$default(it22, baos, 0, 2, null);
                        }
                        catch (Throwable it22) {
                            throwable = it22;
                            throw it22;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, throwable);
                        }
                        bytes = baos.toByteArray();
                        break;
                    }
                    case "gzip": {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        Intrinsics.checkExpressionValueIsNotNull(bytes, "bytes");
                        Object object = bytes;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        InputStream inputStream = byteArrayInputStream;
                        object = new GZIPInputStream(inputStream);
                        Throwable throwable = null;
                        try {
                            GZIPInputStream it = (GZIPInputStream)object;
                            boolean bl = false;
                            long l = ByteStreamsKt.copyTo$default(it, baos, 0, 2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, throwable);
                        }
                        bytes = baos.toByteArray();
                    }
                }
                IntBuffer ints = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
                int[] intArray = new int[ints.limit()];
                ints.get(intArray);
                layer.setData(ArraysKt.toList(intArray));
            }
        }
    }

    private final void parseObjectGroupLayer(Layer layer, StartElement start) {
        layer.setType("objectgroup");
        layer.setName(TMXLevelLoaderKt.access$getString(start, "name"));
    }

    private final void parseObject(Layer layer, TiledObject obj, StartElement start) {
        obj.setName(TMXLevelLoaderKt.access$getString(start, "name"));
        obj.setType(TMXLevelLoaderKt.access$getString(start, "type"));
        obj.setId(TMXLevelLoaderKt.access$getInt(start, "id"));
        obj.setX(TMXLevelLoaderKt.access$getInt(start, "x"));
        obj.setY(TMXLevelLoaderKt.access$getInt(start, "y"));
        obj.setRotation(TMXLevelLoaderKt.access$getFloat(start, "rotation"));
        obj.setWidth(TMXLevelLoaderKt.access$getInt(start, "width"));
        obj.setHeight(TMXLevelLoaderKt.access$getInt(start, "height"));
        obj.setGid(TMXLevelLoaderKt.access$getInt(start, "gid"));
        List<TiledObject> list = layer.getObjects();
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<com.almasb.fxgl.entity.level.tiled.TiledObject>");
        }
        TypeIntrinsics.asMutableList(list).add(obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseObjectProperty(TiledObject obj, StartElement start) {
        Object object;
        Object object2;
        Map map;
        String propName;
        block13: {
            String propType;
            block11: {
                block10: {
                    block12: {
                        propName = TMXLevelLoaderKt.access$getString(start, "name");
                        propType = TMXLevelLoaderKt.access$getString(start, "type");
                        Map<String, String> map2 = obj.getPropertytypes();
                        if (map2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                        }
                        map = TypeIntrinsics.asMutableMap(map2);
                        object2 = propType;
                        map.put(propName, object2);
                        Map<String, Object> map3 = obj.getProperties();
                        if (map3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        }
                        map = TypeIntrinsics.asMutableMap(map3);
                        object2 = propType;
                        switch (((String)object2).hashCode()) {
                            case 0: {
                                if (!((String)object2).equals("")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 3029738: {
                                if (!((String)object2).equals("bool")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break;
                            }
                            case -891985903: {
                                if (!((String)object2).equals("string")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 94842723: {
                                if (!((String)object2).equals("color")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block11;
                            }
                            case 97526364: {
                                if (!((String)object2).equals("float")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block12;
                            }
                            case 104431: {
                                if (!((String)object2).equals("int")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                object = TMXLevelLoaderKt.access$getInt(start, "value");
                                break block13;
                            }
                        }
                        object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                        break block13;
                    }
                    object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                    break block13;
                }
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break block13;
            }
            object = TMXLevelLoaderKt.access$getColor(start, "value");
            break block13;
            throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
        }
        object2 = object;
        map.put(propName, object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseMapProperty(TiledMap map, StartElement start) {
        Object object;
        Object object2;
        Map map2;
        String propName;
        block13: {
            String propType;
            block11: {
                block10: {
                    block12: {
                        propName = TMXLevelLoaderKt.access$getString(start, "name");
                        propType = TMXLevelLoaderKt.access$getString(start, "type");
                        Map<String, String> map3 = map.getPropertytypes();
                        if (map3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
                        }
                        map2 = TypeIntrinsics.asMutableMap(map3);
                        object2 = propType;
                        map2.put(propName, object2);
                        Map<String, Object> map4 = map.getProperties();
                        if (map4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                        }
                        map2 = TypeIntrinsics.asMutableMap(map4);
                        object2 = propType;
                        switch (((String)object2).hashCode()) {
                            case 0: {
                                if (!((String)object2).equals("")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 3029738: {
                                if (!((String)object2).equals("bool")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break;
                            }
                            case -891985903: {
                                if (!((String)object2).equals("string")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block10;
                            }
                            case 94842723: {
                                if (!((String)object2).equals("color")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block11;
                            }
                            case 97526364: {
                                if (!((String)object2).equals("float")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                break block12;
                            }
                            case 104431: {
                                if (!((String)object2).equals("int")) throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
                                object = TMXLevelLoaderKt.access$getInt(start, "value");
                                break block13;
                            }
                        }
                        object = TMXLevelLoaderKt.access$getBoolean(start, "value");
                        break block13;
                    }
                    object = Float.valueOf(TMXLevelLoaderKt.access$getFloat(start, "value"));
                    break block13;
                }
                object = TMXLevelLoaderKt.access$getString(start, "value");
                break block13;
            }
            object = TMXLevelLoaderKt.access$getColor(start, "value");
            break block13;
            throw (Throwable)new IllegalArgumentException("Unknown property type: " + propType + " for " + propName);
        }
        object2 = object;
        map2.put(propName, object2);
    }

    private final void parseObjectPolygon(TiledObject obj, StartElement start) {
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        String data = TMXLevelLoaderKt.access$getString(start, "points");
        Object object = data;
        Object object2 = " +";
        object2 = new Regex((String)object2);
        int n = 0;
        object = ((Regex)object2).split((CharSequence)object, n);
        object2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, new String[]{","}, false, 0, 6, null);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it;
            Double d = Double.parseDouble(string);
            collection.add(d);
        }
        double[] points = CollectionsKt.toDoubleArray((List)destination$iv$iv);
        Polygon polygon = new Polygon(Arrays.copyOf(points, points.length));
        Map<String, Object> map = obj.getProperties();
        if (map == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
        }
        object2 = TypeIntrinsics.asMutableMap(map);
        String string = "polygon";
        Polygon polygon2 = polygon;
        object2.put(string, polygon2);
    }

    public TMXLevelLoader() {
        Logger logger;
        Logger.Companion this_$iv = Logger.Companion;
        TMXLevelLoader tMXLevelLoader = this;
        boolean $i$f$get = false;
        tMXLevelLoader.log = logger = this_$iv.get(TMXLevelLoader.class);
    }
}

