/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.util.DSLKt;
import com.almasb.fxgl.core.util.Optional;
import com.almasb.fxgl.core.util.Predicate;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityFactory;
import com.almasb.fxgl.entity.EntityPreloader;
import com.almasb.fxgl.entity.EntitySpawner;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.Preload;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.fxgl.entity.Spawns;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.components.IDComponent;
import com.almasb.fxgl.entity.components.IrremovableComponent;
import com.almasb.fxgl.entity.components.TimeComponent;
import com.almasb.fxgl.entity.level.Level;
import com.almasb.sslogger.Logger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 `2\u00020\u0001:\u0001`B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u001f\u0010\u001e\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050 \"\u00020\u0005\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u000fJ\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001aJ\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0010H\u0002J\u0006\u0010+\u001a\u00020\u001cJ\b\u0010,\u001a\u00020\u001cH\u0002J\u0016\u0010-\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/J\"\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010\u001d\u001a\u00020\u00052\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000503J\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u001d\u001a\u00020\u0005J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u00106\u001a\u000207J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u000e\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0:J-\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u001a\u0010=\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030>0 \"\u0006\u0012\u0002\b\u00030>\u00a2\u0006\u0002\u0010?J\u001a\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000503J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010C\u001a\u00020DJ\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020HJ\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020\u0005012\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000503J\u0018\u0010I\u001a\b\u0012\u0004\u0012\u00020\u0005012\n\u00109\u001a\u0006\u0012\u0002\b\u00030>J\u0014\u0010J\u001a\u00020\u00052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000503J\u0012\u0010J\u001a\u00020\u00052\n\u00109\u001a\u0006\u0012\u0002\b\u00030>J\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0005012\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000503J\u0018\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0005012\n\u00109\u001a\u0006\u0012\u0002\b\u00030>J1\u0010L\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u00052\u001a\u0010=\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030>0 \"\u0006\u0012\u0002\b\u00030>H\u0002\u00a2\u0006\u0002\u0010MJ\u0010\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u0005H\u0002J\u0010\u0010P\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u0005H\u0002J\u000e\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020SJ\u001f\u0010T\u001a\u00020\u001c2\u0012\u0010U\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050 \"\u00020\u0005\u00a2\u0006\u0002\u0010!J\u0014\u0010T\u001a\u00020\u001c2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00050VJ\u000e\u0010W\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010X\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u000fJ\u000e\u0010Y\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001aJ\u000e\u0010Z\u001a\u00020\u001c2\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0010J\u0016\u0010]\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/J\u0016\u0010]\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00102\u0006\u00106\u001a\u000207J\u001e\u0010]\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00102\u0006\u0010^\u001a\u00020S2\u0006\u0010_\u001a\u00020SR!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/almasb/fxgl/entity/GameWorld;", "", "()V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "getEntities", "()Ljava/util/ArrayList;", "entitiesCopy", "", "getEntitiesCopy", "()Ljava/util/List;", "entityFactories", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "Lcom/almasb/fxgl/entity/EntityFactory;", "", "entityPreloader", "Lcom/almasb/fxgl/entity/EntityPreloader;", "entitySpawners", "Lcom/almasb/fxgl/entity/EntitySpawner;", "updateList", "Lcom/almasb/fxgl/core/collection/Array;", "waitingList", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "worldListeners", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "add", "", "entity", "addEntities", "entitiesToAdd", "", "([Lcom/almasb/fxgl/entity/Entity;)V", "addEntity", "addEntityFactory", "entityFactory", "addWorldListener", "listener", "canRemove", "", "checkDuplicateSpawners", "entityName", "clear", "clearLevel", "create", "data", "Lcom/almasb/fxgl/entity/SpawnData;", "getClosestEntity", "Lcom/almasb/fxgl/core/util/Optional;", "filter", "Lcom/almasb/fxgl/core/util/Predicate;", "getCollidingEntities", "getEntitiesAt", "position", "Ljavafx/geometry/Point2D;", "getEntitiesByComponent", "type", "Ljava/lang/Class;", "Lcom/almasb/fxgl/entity/component/Component;", "getEntitiesByType", "types", "", "([Ljava/lang/Enum;)Ljava/util/List;", "getEntitiesFiltered", "predicate", "getEntitiesInRange", "selection", "Ljavafx/geometry/Rectangle2D;", "getEntityByID", "name", "id", "", "getRandom", "getSingleton", "getSingletonOptional", "isOneOfTypes", "(Lcom/almasb/fxgl/entity/Entity;[Ljava/lang/Enum;)Z", "notifyEntityAdded", "e", "notifyEntityRemoved", "onUpdate", "tpf", "", "removeEntities", "entitiesToRemove", "", "removeEntity", "removeEntityFactory", "removeWorldListener", "setLevel", "level", "Lcom/almasb/fxgl/entity/level/Level;", "spawn", "x", "y", "Companion", "fxgl-entity"})
public final class GameWorld {
    private final Array<Entity> updateList = new Array();
    private final UnorderedArray<Entity> waitingList = new UnorderedArray(0, 1, null);
    @NotNull
    private final ArrayList<Entity> entities = new ArrayList();
    private final Array<EntityWorldListener> worldListeners;
    private final ObjectMap<EntityFactory, List<String>> entityFactories;
    private final ObjectMap<String, EntitySpawner> entitySpawners;
    private final EntityPreloader entityPreloader;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final ArrayList<Entity> getEntities() {
        return this.entities;
    }

    @NotNull
    public final List<Entity> getEntitiesCopy() {
        return new ArrayList(this.entities);
    }

    public final void addEntity(@NotNull Entity entity) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        boolean bl2 = bl = !entity.isActive();
        if (!bl) {
            boolean bl3 = false;
            String string = "Entity is already attached to world";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.waitingList.add(entity);
        this.entities.add(entity);
        this.add(entity);
    }

    public final void addEntities(Entity ... entitiesToAdd) {
        Intrinsics.checkParameterIsNotNull(entitiesToAdd, "entitiesToAdd");
        for (Entity e : entitiesToAdd) {
            this.addEntity(e);
        }
    }

    private final void add(Entity entity) {
        entity.init(this);
        this.notifyEntityAdded(entity);
    }

    public final void removeEntity(@NotNull Entity entity) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        if (!entity.isActive()) {
            log.warning("Attempted to remove entity which is not active");
            return;
        }
        if (!this.canRemove(entity)) {
            return;
        }
        boolean bl2 = bl = entity.getWorld() == this;
        if (!bl) {
            boolean bl3 = false;
            String string = "Attempted to remove entity not attached to this world";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.entities.remove(entity);
        entity.markForRemoval();
        this.notifyEntityRemoved(entity);
    }

    public final void removeEntities(Entity ... entitiesToRemove) {
        Intrinsics.checkParameterIsNotNull(entitiesToRemove, "entitiesToRemove");
        for (Entity e : entitiesToRemove) {
            this.removeEntity(e);
        }
    }

    public final void removeEntities(@NotNull Collection<? extends Entity> entitiesToRemove) {
        Intrinsics.checkParameterIsNotNull(entitiesToRemove, "entitiesToRemove");
        for (Entity entity : entitiesToRemove) {
            this.removeEntity(entity);
        }
    }

    private final boolean canRemove(Entity entity) {
        return !entity.hasComponent(IrremovableComponent.class);
    }

    public final void onUpdate(double tpf) {
        this.updateList.addAll((Array<Entity>)this.waitingList);
        this.waitingList.clear();
        Iterator<Entity> iterator2 = this.updateList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, "updateList.iterator()");
        Iterator<Entity> it = iterator2;
        while (it.hasNext()) {
            Double tpfRatio2;
            Entity e;
            Entity entity = e = it.next();
            Intrinsics.checkExpressionValueIsNotNull(entity, "e");
            if (!entity.isActive()) {
                e.clean();
                it.remove();
                continue;
            }
            Double d = tpfRatio2 = e.getComponentOptional(TimeComponent.class).map(onUpdate.tpfRatio.1.INSTANCE).orElse(1.0);
            Intrinsics.checkExpressionValueIsNotNull(d, "tpfRatio");
            e.update(tpf * d);
        }
    }

    public final void clear() {
        GameWorld gameWorld;
        log.debug("Clearing game world");
        this.waitingList.clear();
        GameWorld $receiver = gameWorld = this;
        boolean bl = false;
        Iterator<Entity> iterator2 = $receiver.updateList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, "updateList.iterator()");
        Iterator<Entity> it = iterator2;
        while (it.hasNext()) {
            Entity e;
            Entity entity = e = it.next();
            Intrinsics.checkExpressionValueIsNotNull(entity, "e");
            if (!entity.isActive()) {
                e.clean();
            }
            it.remove();
        }
        Iterable $receiver$iv = this.getEntitiesCopy();
        for (Object element$iv : $receiver$iv) {
            Entity e = (Entity)element$iv;
            boolean bl2 = false;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
        }
        this.entities.clear();
        this.entityFactories.clear();
        this.entitySpawners.clear();
    }

    public final void addWorldListener(@NotNull EntityWorldListener listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, "listener");
        this.worldListeners.add(listener2);
    }

    public final void removeWorldListener(@NotNull EntityWorldListener listener2) {
        Intrinsics.checkParameterIsNotNull(listener2, "listener");
        this.worldListeners.removeValueByIdentity(listener2);
    }

    private final void notifyEntityAdded(Entity e) {
        Iterable $receiver$iv = this.worldListeners;
        for (Object element$iv : $receiver$iv) {
            EntityWorldListener it = (EntityWorldListener)element$iv;
            boolean bl = false;
            it.onEntityAdded(e);
        }
    }

    private final void notifyEntityRemoved(Entity e) {
        Iterable $receiver$iv = this.worldListeners;
        for (Object element$iv : $receiver$iv) {
            EntityWorldListener it = (EntityWorldListener)element$iv;
            boolean bl = false;
            it.onEntityRemoved(e);
        }
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkParameterIsNotNull(level, "level");
        this.clearLevel();
        log.debug("Setting level: " + level);
        Iterable $receiver$iv = level.getEntities();
        for (Object element$iv : $receiver$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            this.addEntity(it);
        }
    }

    private final void clearLevel() {
        GameWorld gameWorld;
        log.debug("Clearing removable entities");
        this.waitingList.clear();
        GameWorld $receiver = gameWorld = this;
        boolean bl = false;
        Iterator<Entity> iterator2 = $receiver.updateList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator2, "updateList.iterator()");
        Iterator<Entity> it = iterator2;
        while (it.hasNext()) {
            Entity e;
            Entity entity = e = it.next();
            Intrinsics.checkExpressionValueIsNotNull(entity, "e");
            if (!$receiver.canRemove(entity)) continue;
            if (!e.isActive()) {
                e.clean();
            }
            it.remove();
        }
        Iterator<Entity> iterator3 = this.entities.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator3, "entities.iterator()");
        Iterator<Entity> it2 = iterator3;
        while (it2.hasNext()) {
            Entity e;
            Intrinsics.checkExpressionValueIsNotNull(it2.next(), "it.next()");
            if (!this.canRemove(e)) continue;
            e.markForRemoval();
            this.notifyEntityRemoved(e);
            e.clean();
            it2.remove();
        }
    }

    public final void addEntityFactory(@NotNull EntityFactory entityFactory) {
        Intrinsics.checkParameterIsNotNull(entityFactory, "entityFactory");
        ArrayList entityNames = new ArrayList();
        ReflectionUtils.findMethodsMapToFunctions(entityFactory, Spawns.class, EntitySpawner.class).forEach(new BiConsumer<Spawns, EntitySpawner>(this, entityFactory, entityNames){
            final /* synthetic */ GameWorld this$0;
            final /* synthetic */ EntityFactory $entityFactory;
            final /* synthetic */ ArrayList $entityNames;

            public final void accept(Spawns annotation, EntitySpawner entitySpawner) {
                CharSequence charSequence = annotation.value();
                Iterator<T> iterator2 = ",";
                iterator2 = new Regex((String)((Object)iterator2));
                int n = 0;
                List<String> entityAliases = ((Regex)((Object)iterator2)).split(charSequence, n);
                Iterable $receiver$iv = entityAliases;
                for (T element$iv : $receiver$iv) {
                    String entityName = (String)element$iv;
                    boolean bl = false;
                    GameWorld.access$checkDuplicateSpawners(this.this$0, this.$entityFactory, entityName);
                    GameWorld.access$getEntitySpawners$p(this.this$0).put(entityName, entitySpawner);
                    this.$entityNames.add(entityName);
                }
            }
            {
                this.this$0 = gameWorld;
                this.$entityFactory = entityFactory;
                this.$entityNames = arrayList;
            }
        });
        ReflectionUtils.findMethods(entityFactory, Preload.class).forEach(new BiConsumer<Preload, Method>(this){
            final /* synthetic */ GameWorld this$0;

            public final void accept(Preload preload, Method method) {
                Spawns ann = method.getDeclaredAnnotation(Spawns.class);
                CharSequence charSequence = ann.value();
                Object object = ",";
                object = new Regex((String)object);
                int n = 0;
                List<String> entityAliases = ((Regex)object).split(charSequence, n);
                int numToPreload = preload.value();
                GameWorld.access$getEntityPreloader$p(this.this$0).addForPreloading(entityAliases, numToPreload);
            }
            {
                this.this$0 = gameWorld;
            }
        });
        this.entityFactories.put(entityFactory, entityNames);
    }

    private final void checkDuplicateSpawners(EntityFactory entityFactory, String entityName) {
        if (this.entitySpawners.containsKey(entityName)) {
            Object v0;
            block2: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)this.entityFactories;
                for (Object t : iterable2) {
                    ObjectMap.Entry it = (ObjectMap.Entry)t;
                    boolean bl = false;
                    if (!((List)it.value).contains(entityName)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            ObjectMap.Entry factory = v0;
            throw (Throwable)new IllegalArgumentException("Duplicated @Spawns(" + entityName + ") in " + entityFactory + ". Already exists in " + factory);
        }
    }

    public final void removeEntityFactory(@NotNull EntityFactory entityFactory) {
        Intrinsics.checkParameterIsNotNull(entityFactory, "entityFactory");
        List<String> list = this.entityFactories.remove(entityFactory);
        if (list != null) {
            Iterable $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.entitySpawners.remove(it);
            }
        }
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName) {
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        return this.spawn(entityName, 0.0, 0.0);
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, @NotNull Point2D position) {
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        Intrinsics.checkParameterIsNotNull(position, "position");
        return this.spawn(entityName, position.getX(), position.getY());
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, double x, double y) {
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        return this.spawn(entityName, new SpawnData(x, y));
    }

    @NotNull
    public final Entity spawn(@NotNull String entityName, @NotNull SpawnData data) {
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Entity entity = this.create(entityName, data);
        this.addEntity(entity);
        return entity;
    }

    @NotNull
    public final Entity create(@NotNull String entityName, @NotNull SpawnData data) {
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        Intrinsics.checkParameterIsNotNull(data, "data");
        boolean bl = this.entityFactories.isNotEmpty();
        if (!bl) {
            boolean bl2 = false;
            String string = "No EntityFactory was added! Call gameWorld.addEntityFactory()";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntitySpawner entitySpawner = this.entitySpawners.get(entityName);
        if (entitySpawner == null) {
            throw (Throwable)new IllegalArgumentException("No EntityFactory has a method annotated @Spawns(" + entityName + ')');
        }
        EntitySpawner spawner = entitySpawner;
        if (!data.hasKey("type")) {
            data.put("type", entityName);
        }
        if (this.entityPreloader.isPreloadingEnabled(entityName)) {
            return this.entityPreloader.obtain(entityName, data);
        }
        Object t = DSLKt.tryCatchRoot((Function0)new Function0<Entity>(spawner, data){
            final /* synthetic */ EntitySpawner $spawner;
            final /* synthetic */ SpawnData $data;

            public final Entity invoke() {
                R r = this.$spawner.apply(this.$data);
                Intrinsics.checkExpressionValueIsNotNull(r, "spawner.apply(data)");
                return (Entity)r;
            }
            {
                this.$spawner = entitySpawner;
                this.$data = spawnData;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, "tryCatchRoot { spawner.apply(data) }");
        return (Entity)t;
    }

    @NotNull
    public final Entity getSingleton(@NotNull Enum<?> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        return this.getSingleton(new Predicate<Entity>(type){
            final /* synthetic */ Enum $type;

            public final boolean test(Entity it) {
                return it.isType(this.$type);
            }
            {
                this.$type = enum_;
            }
        });
    }

    @NotNull
    public final Entity getSingleton(@NotNull Predicate<Entity> predicate) {
        Object v0;
        block2: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(predicate, "predicate");
            Iterable iterable2 = iterable = (Iterable)this.entities;
            for (Object t : iterable2) {
                Entity it = (Entity)t;
                boolean bl = false;
                if (!predicate.test(it)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Entity entity = v0;
        if (entity == null) {
            throw (Throwable)new NoSuchElementException("No entity found satisfying the predicate");
        }
        return entity;
    }

    @NotNull
    public final Optional<Entity> getSingletonOptional(@NotNull Enum<?> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        return this.getSingletonOptional(new Predicate<Entity>(type){
            final /* synthetic */ Enum $type;

            public final boolean test(Entity it) {
                return it.isType(this.$type);
            }
            {
                this.$type = enum_;
            }
        });
    }

    @NotNull
    public final Optional<Entity> getSingletonOptional(@NotNull Predicate<Entity> predicate) {
        Object t;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(predicate, "predicate");
            Iterable iterable2 = iterable = (Iterable)this.entities;
            for (Object t2 : iterable2) {
                Entity it = (Entity)t2;
                boolean bl = false;
                if (!predicate.test(it)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.ofNullable(enti\u2026d { predicate.test(it) })");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getRandom(@NotNull Enum<?> type) {
        Intrinsics.checkParameterIsNotNull(type, "type");
        Optional<Entity> optional = FXGLMath.random(this.getEntitiesByType(type));
        Intrinsics.checkExpressionValueIsNotNull(optional, "FXGLMath.random(getEntitiesByType(type))");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getRandom(@NotNull Predicate<Entity> predicate) {
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Optional<Entity> optional = FXGLMath.random(this.getEntitiesFiltered(predicate));
        Intrinsics.checkExpressionValueIsNotNull(optional, "FXGLMath.random(getEntitiesFiltered(predicate))");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByComponent(@NotNull Class<? extends Component> type) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(type, "type");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.hasComponent(type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesFiltered(@NotNull Predicate<Entity> predicate) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!predicate.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesByType(Enum<?> ... types) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(types, "types");
        Enum<?>[] enumArray = types;
        if (enumArray.length == 0) {
            return this.getEntitiesCopy();
        }
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!this.isOneOfTypes(it, Arrays.copyOf(types, types.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isOneOfTypes(Entity entity, Enum<?> ... types) {
        boolean bl;
        block1: {
            Enum<?>[] $receiver$iv;
            Enum<?>[] enumArray = $receiver$iv = types;
            int n = enumArray.length;
            for (int i = 0; i < n; ++i) {
                Enum<?> element$iv;
                Enum<?> it = element$iv = enumArray[i];
                boolean bl2 = false;
                if (!entity.isType(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesInRange(@NotNull Rectangle2D selection) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(selection, "selection");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!it.getBoundingBoxComponent().isWithin(selection)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getCollidingEntities(@NotNull Entity entity) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(it.isColliding(entity) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity> getEntitiesAt(@NotNull Point2D position) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(position, "position");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPosition(), position)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Optional<Entity> getClosestEntity(@NotNull Entity entity, @NotNull Predicate<Entity> filter) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Iterable iterable = $receiver$iv = (Iterable)this.entities;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Entity it = (Entity)element$iv$iv;
            boolean bl = false;
            if (!(filter.test(it) && it != entity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(entity){
            final /* synthetic */ Entity $entity$inlined;
            {
                this.$entity$inlined = entity;
            }

            public final int compare(T a, T b) {
                Entity it = (Entity)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(this.$entity$inlined.distance(it));
                it = (Entity)b;
                Comparable comparable2 = comparable;
                bl = false;
                Double d = this.$entity$inlined.distance(it);
                return ComparisonsKt.compareValues(comparable2, (Comparable)d);
            }
        };
        Optional<Entity> optional = Optional.ofNullable(CollectionsKt.firstOrNull(CollectionsKt.sortedWith(iterable, comparator)));
        Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.ofNullable(\n   \u2026 .firstOrNull()\n        )");
        return optional;
    }

    @NotNull
    public final Optional<Entity> getEntityByID(@NotNull String name, int id) {
        Object t;
        block1: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(name, "name");
            Iterable iterable2 = iterable = (Iterable)this.getEntitiesByComponent(IDComponent.class);
            for (Object t2 : iterable2) {
                Entity it = (Entity)t2;
                boolean bl = false;
                IDComponent idComponent = it.getComponent(IDComponent.class);
                if (!(Intrinsics.areEqual(idComponent.getName(), name) && idComponent.getId() == id)) continue;
                t = t2;
                break block1;
            }
            t = null;
        }
        Optional<Object> optional = Optional.ofNullable(t);
        Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.ofNullable(\n   \u2026              }\n        )");
        return optional;
    }

    public GameWorld() {
        log.debug("Game world initialized");
        this.worldListeners = new Array();
        this.entityFactories = new ObjectMap();
        this.entitySpawners = new ObjectMap();
        this.entityPreloader = new EntityPreloader(this.entitySpawners);
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("GameWorld");
    }

    public static final /* synthetic */ void access$checkDuplicateSpawners(GameWorld $this, EntityFactory entityFactory, String entityName) {
        $this.checkDuplicateSpawners(entityFactory, entityName);
    }

    public static final /* synthetic */ ObjectMap access$getEntitySpawners$p(GameWorld $this) {
        return $this.entitySpawners;
    }

    public static final /* synthetic */ EntityPreloader access$getEntityPreloader$p(GameWorld $this) {
        return $this.entityPreloader;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/entity/GameWorld$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl-entity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

