/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntitySpawner;
import com.almasb.fxgl.entity.SpawnData;
import com.almasb.sslogger.Logger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javafx.geometry.Point2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/almasb/fxgl/entity/EntityPreloader;", "", "spawners", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "", "Lcom/almasb/fxgl/entity/EntitySpawner;", "(Lcom/almasb/fxgl/core/collection/ObjectMap;)V", "log", "Lcom/almasb/sslogger/Logger;", "thread", "Lcom/almasb/fxgl/entity/EntityPreloader$EntitySpawnerThread;", "addForPreloading", "", "entityAliases", "", "numItems", "", "isPreloadingEnabled", "", "entityName", "obtain", "Lcom/almasb/fxgl/entity/Entity;", "data", "Lcom/almasb/fxgl/entity/SpawnData;", "EntitySpawnerThread", "fxgl-entity"})
public final class EntityPreloader {
    private final Logger log;
    private final EntitySpawnerThread thread;
    private final ObjectMap<String, EntitySpawner> spawners;

    public final boolean isPreloadingEnabled(@NotNull String entityName) {
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        return this.thread.getPreloadedEntities().containsKey(entityName);
    }

    public final void addForPreloading(@NotNull List<String> entityAliases, int numItems) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull(entityAliases, "entityAliases");
            Iterable $receiver$iv = entityAliases;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!this.isPreloadingEnabled(it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        ArrayBlockingQueue queue = new ArrayBlockingQueue(numItems);
        Iterable $receiver$iv = entityAliases;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            this.thread.getPreloadedEntities().put(it, queue);
        }
        if (!this.thread.isAlive()) {
            this.log.info("Starting Entity preloader thread");
            this.thread.start();
        }
    }

    @NotNull
    public final Entity obtain(@NotNull String entityName, @NotNull SpawnData data) {
        Entity e;
        Intrinsics.checkParameterIsNotNull(entityName, "entityName");
        Intrinsics.checkParameterIsNotNull(data, "data");
        Entity entity = e = this.thread.getPreloadedEntities().get(entityName).take();
        Intrinsics.checkExpressionValueIsNotNull(entity, "e");
        if (Intrinsics.areEqual(entity.getPosition(), Point2D.ZERO)) {
            e.setX(data.getX());
            e.setY(data.getY());
        }
        return e;
    }

    public EntityPreloader(@NotNull ObjectMap<String, EntitySpawner> spawners) {
        Intrinsics.checkParameterIsNotNull(spawners, "spawners");
        this.spawners = spawners;
        this.log = Logger.Companion.get(this.getClass());
        this.thread = new EntitySpawnerThread(this.spawners);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016R#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/entity/EntityPreloader$EntitySpawnerThread;", "Ljava/lang/Thread;", "spawners", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "", "Lcom/almasb/fxgl/entity/EntitySpawner;", "(Lcom/almasb/fxgl/core/collection/ObjectMap;)V", "preloadedEntities", "Ljava/util/concurrent/BlockingQueue;", "Lcom/almasb/fxgl/entity/Entity;", "getPreloadedEntities", "()Lcom/almasb/fxgl/core/collection/ObjectMap;", "getSpawners", "run", "", "fxgl-entity"})
    private static final class EntitySpawnerThread
    extends Thread {
        @NotNull
        private final ObjectMap<String, BlockingQueue<Entity>> preloadedEntities;
        @NotNull
        private final ObjectMap<String, EntitySpawner> spawners;

        @NotNull
        public final ObjectMap<String, BlockingQueue<Entity>> getPreloadedEntities() {
            return this.preloadedEntities;
        }

        @Override
        public void run() {
            block0: while (true) {
                Iterable $receiver$iv = this.preloadedEntities;
                Iterator iterator2 = $receiver$iv.iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block0;
                    Object element$iv = iterator2.next();
                    ObjectMap.Entry it = (ObjectMap.Entry)element$iv;
                    boolean bl = false;
                    EntitySpawner spawner = this.spawners.get((String)it.key);
                    BlockingQueue queue = (BlockingQueue)it.value;
                    queue.put(spawner.apply(new SpawnData(0.0, 0.0)));
                }
                break;
            }
        }

        @NotNull
        public final ObjectMap<String, EntitySpawner> getSpawners() {
            return this.spawners;
        }

        public EntitySpawnerThread(@NotNull ObjectMap<String, EntitySpawner> spawners) {
            Intrinsics.checkParameterIsNotNull(spawners, "spawners");
            super("Entity Spawner Thread");
            this.spawners = spawners;
            this.preloadedEntities = new ObjectMap();
            this.setDaemon(true);
        }
    }
}

