/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.entity;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.util.BackportKt;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.core.util.Optional;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.entity.component.ComponentHelper;
import com.almasb.fxgl.entity.component.ComponentListener;
import com.almasb.fxgl.entity.component.CoreComponent;
import com.almasb.fxgl.entity.component.Required;
import com.almasb.fxgl.entity.components.BoundingBoxComponent;
import com.almasb.fxgl.entity.components.TransformComponent;
import com.almasb.fxgl.entity.components.TypeComponent;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.physics.HitBox;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;

public class Entity {
    private PropertyMap properties = new PropertyMap();
    private ObjectMap<Class<? extends Component>, Component> components = new ObjectMap();
    private List<ComponentListener> componentListeners = new ArrayList<ComponentListener>();
    private ReadOnlyBooleanWrapper active = new ReadOnlyBooleanWrapper(false);
    private Runnable onActive = EmptyRunnable.INSTANCE;
    private Runnable onNotActive = EmptyRunnable.INSTANCE;
    private boolean updateEnabled = true;
    private boolean updating = false;
    private TypeComponent type = new TypeComponent();
    private TransformComponent transform = new TransformComponent();
    private BoundingBoxComponent bbox = new BoundingBoxComponent(new HitBox[0]);
    private ViewComponent view = new ViewComponent();
    private GameWorld world = null;

    public Entity() {
        this.addComponentNoChecks(this.type);
        this.addComponentNoChecks(this.transform);
        this.addComponentNoChecks(this.bbox);
        this.addComponentNoChecks(this.view);
    }

    public final GameWorld getWorld() {
        return this.world;
    }

    void init(GameWorld world) {
        this.world = world;
        this.onActive.run();
        this.active.set(true);
    }

    void clean() {
        this.removeAllComponents();
        this.properties.clear();
        this.componentListeners.clear();
        this.world = null;
        this.onActive = EmptyRunnable.INSTANCE;
        this.onNotActive = EmptyRunnable.INSTANCE;
        this.updateEnabled = true;
        this.updating = false;
        this.active.set(false);
    }

    public final void removeFromWorld() {
        if (this.world != null) {
            this.world.removeEntity(this);
        }
    }

    public final void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    void update(double tpf) {
        if (!this.updateEnabled) {
            return;
        }
        this.updating = true;
        for (Component c : this.components.values()) {
            if (c.isPaused()) continue;
            c.onUpdate(tpf);
        }
        this.updating = false;
    }

    void markForRemoval() {
        this.onNotActive.run();
        this.active.set(false);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.active.getReadOnlyProperty();
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public final void setOnActive(Runnable action) {
        this.onActive = action;
    }

    public final void setOnNotActive(Runnable action) {
        this.onNotActive = action;
    }

    public final PropertyMap getProperties() {
        return this.properties;
    }

    public final void setProperty(String key, Object value) {
        this.properties.setValue(key, value);
    }

    public final <T> Optional<T> getPropertyOptional(String key) {
        return this.properties.getValueOptional(key);
    }

    public final int getInt(String key) {
        return this.properties.getInt(key);
    }

    public final double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public final boolean getBoolean(String key) {
        return this.properties.getBoolean(key);
    }

    public final String getString(String key) {
        return this.properties.getString(key);
    }

    public final <T> T getObject(String key) {
        return this.properties.getObject(key);
    }

    public final void addComponentListener(ComponentListener listener2) {
        this.componentListeners.add(listener2);
    }

    public final void removeComponentListener(ComponentListener listener2) {
        this.componentListeners.remove(listener2);
    }

    public final boolean hasComponent(Class<? extends Component> type) {
        return this.components.containsKey(type);
    }

    public final <T extends Component> Optional<T> getComponentOptional(Class<T> type) {
        return Optional.ofNullable((Component)type.cast(this.components.get(type)));
    }

    public final <T extends Component> T getComponent(Class<T> type) {
        Component component = this.components.get(type);
        if (component == null) {
            throw new IllegalArgumentException("Component " + type.getSimpleName() + " not found!");
        }
        return (T)((Component)type.cast(component));
    }

    public final Array<Component> getComponents() {
        return this.components.values().toArray();
    }

    public final void addComponent(Component component) {
        this.checkNotUpdating();
        this.checkRequirementsMet(component.getClass());
        this.addComponentNoChecks(component);
    }

    private void addComponentNoChecks(Component component) {
        this.injectFields(component);
        component.onAdded();
        this.notifyComponentAdded(component);
        this.components.put(component.getClass(), component);
    }

    public final boolean removeComponent(Class<? extends Component> type) {
        if (!this.hasComponent(type)) {
            return false;
        }
        this.checkNotUpdating();
        this.checkNotCore(type);
        this.checkNotRequiredByAny(type);
        this.removeComponent(this.getComponent(type));
        this.components.remove(type);
        return true;
    }

    private void removeAllComponents() {
        BackportKt.forEach(this.components.values(), this::removeComponent);
        this.components.clear();
    }

    private void injectFields(Component component) {
        ComponentHelper.setEntity(component, this);
        BackportKt.forEach(ReflectionUtils.findFieldsByTypeRecursive(component, Component.class), field -> this.getComponentOptional(field.getType()).ifPresent(comp -> ReflectionUtils.inject(field, component, comp)));
    }

    private void removeComponent(Component component) {
        this.notifyComponentRemoved(component);
        component.onRemoved();
        ComponentHelper.setEntity(component, null);
    }

    private <T extends Component> void notifyComponentAdded(T c) {
        BackportKt.forEach(this.componentListeners, l -> l.onAdded(c));
    }

    private <T extends Component> void notifyComponentRemoved(T c) {
        BackportKt.forEach(this.componentListeners, l -> l.onRemoved(c));
    }

    private void checkNotUpdating() {
        if (this.updating) {
            throw new IllegalStateException("Cannot add / remove components during updating");
        }
    }

    private void checkNotCore(Class<? extends Component> type) {
        if (this.isCoreComponent(type)) {
            throw new IllegalArgumentException("Removing a core component: " + type + " is not allowed");
        }
    }

    private boolean isCoreComponent(Class<? extends Component> type) {
        return type.getAnnotation(CoreComponent.class) != null;
    }

    private void checkRequirementsMet(Class<? extends Component> type) {
        this.checkNotAnonymous(type);
        this.checkNotDuplicate(type);
        ArrayList<Required> requiredList = new ArrayList<Required>();
        Annotation[] annotations = type.getAnnotations();
        for (Annotation a : annotations) {
            if (!a.annotationType().equals(Required.class)) continue;
            requiredList.add((Required)a);
        }
        for (Required r : requiredList) {
            if (this.hasComponent(r.value())) continue;
            throw new IllegalStateException("Required component: [" + r.value().getSimpleName() + "] for: " + type.getSimpleName() + " is missing");
        }
    }

    private void checkNotAnonymous(Class<? extends Component> type) {
        if (ReflectionUtils.isAnonymousClass(type)) {
            throw new IllegalArgumentException("Anonymous components are not allowed: " + type.getName());
        }
    }

    private void checkNotDuplicate(Class<? extends Component> type) {
        if (this.hasComponent(type)) {
            throw new IllegalArgumentException("Entity already has component: " + type.getCanonicalName());
        }
    }

    private void checkNotRequiredByAny(Class<? extends Component> type) {
        for (Class clazz : this.components.keys()) {
            this.checkNotRequiredBy(clazz, type);
        }
    }

    private void checkNotRequiredBy(Class<? extends Component> requiringType, Class<? extends Component> type) {
        ArrayList<Required> requiredList = new ArrayList<Required>();
        Annotation[] annotations = requiringType.getAnnotations();
        for (Annotation a : annotations) {
            if (!a.annotationType().equals(Required.class)) continue;
            requiredList.add((Required)a);
        }
        for (Required required : requiredList) {
            if (!required.value().equals(type)) continue;
            throw new IllegalArgumentException("Required component: [" + required.value().getSimpleName() + "] by: " + requiringType.getSimpleName());
        }
    }

    public final TypeComponent getTypeComponent() {
        return this.type;
    }

    public final TransformComponent getTransformComponent() {
        return this.transform;
    }

    public final BoundingBoxComponent getBoundingBoxComponent() {
        return this.bbox;
    }

    public final ViewComponent getViewComponent() {
        return this.view;
    }

    public final Serializable getType() {
        return (Serializable)this.type.getValue();
    }

    public final void setType(Serializable type) {
        this.type.setValue(type);
    }

    public final boolean isType(Object type) {
        return this.type.isType(type);
    }

    public final ObjectProperty<Serializable> typeProperty() {
        return this.type.valueProperty();
    }

    public final Point2D getPosition() {
        return this.transform.getPosition();
    }

    public final void setPosition(Point2D position) {
        this.transform.setPosition(position);
    }

    public final void setPosition(Vec2 position) {
        this.transform.setPosition(position.x, position.y);
    }

    public final void setPosition(double x, double y) {
        this.transform.setPosition(x, y);
    }

    public final double getX() {
        return this.transform.getX();
    }

    public final double getY() {
        return this.transform.getY();
    }

    public final void setX(double x) {
        this.transform.setX(x);
    }

    public final void setY(double y) {
        this.transform.setY(y);
    }

    public final DoubleProperty xProperty() {
        return this.transform.xProperty();
    }

    public final DoubleProperty yProperty() {
        return this.transform.yProperty();
    }

    public final void translate(Point2D vector) {
        this.transform.translate(vector);
    }

    public final void translate(Vec2 vector) {
        this.transform.translate(vector.x, vector.y);
    }

    public final void translate(double dx, double dy) {
        this.transform.translate(dx, dy);
    }

    public final void translateX(double dx) {
        this.transform.translateX(dx);
    }

    public final void translateY(double dy) {
        this.transform.translateY(dy);
    }

    public final void translateTowards(Point2D point, double distance) {
        this.transform.translateTowards(point, distance);
    }

    public final double distance(Entity other) {
        return this.transform.distance(other.transform);
    }

    public final double getRotation() {
        return this.transform.getAngle();
    }

    public final void setRotation(double angle) {
        this.transform.setAngle(angle);
    }

    public final DoubleProperty angleProperty() {
        return this.transform.angleProperty();
    }

    public final void rotateBy(double angle) {
        this.transform.rotateBy(angle);
    }

    public final void rotateToVector(Point2D vector) {
        this.transform.rotateToVector(vector);
    }

    public final void setScaleX(double scaleX) {
        this.transform.setScaleX(scaleX);
    }

    public final void setScaleY(double scaleY) {
        this.transform.setScaleY(scaleY);
    }

    public final double getScaleX() {
        return this.transform.getScaleX();
    }

    public final double getScaleY() {
        return this.transform.getScaleY();
    }

    public final void setZ(int z) {
        this.transform.setZ(z);
    }

    public final int getZ() {
        return this.transform.getZ();
    }

    public final double getWidth() {
        return this.bbox.getWidth();
    }

    public final double getHeight() {
        return this.bbox.getHeight();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.bbox.widthProperty();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.bbox.heightProperty();
    }

    public final double getRightX() {
        return this.bbox.getMaxXWorld();
    }

    public final double getBottomY() {
        return this.bbox.getMaxYWorld();
    }

    public final Point2D getCenter() {
        return this.bbox.getCenterWorld();
    }

    public final boolean isColliding(Entity other) {
        return this.bbox.isCollidingWith(other.bbox);
    }

    public final boolean isWithin(Rectangle2D bounds) {
        return this.bbox.isWithin(bounds);
    }

    public String toString() {
        ArrayList coreComponentsAsString = new ArrayList(this.components.size());
        ArrayList otherComponentsAsString = new ArrayList(this.components.size());
        BackportKt.forEach(this.components.values(), c -> {
            if (this.isCoreComponent(c.getClass())) {
                coreComponentsAsString.add(c.toString());
            } else {
                otherComponentsAsString.add(c.toString());
            }
        });
        Collections.sort(coreComponentsAsString);
        Collections.sort(otherComponentsAsString);
        return "Entity(" + coreComponentsAsString + otherComponentsAsString + ")";
    }
}

