/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.pool;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.pool.Pool;
import com.almasb.fxgl.core.pool.ReflectionPool;

public final class Pools {
    private static final ObjectMap<Class, Pool> typePools = new ObjectMap();

    private Pools() {
    }

    private static <T> Pool<T> get(Class<T> type, int max) {
        ReflectionPool<T> pool = typePools.get(type);
        if (pool == null) {
            pool = new ReflectionPool<T>(type, 16, max);
            typePools.put(type, pool);
        }
        return pool;
    }

    private static <T> Pool<T> get(Class<T> type) {
        return Pools.get(type, 100);
    }

    public static <T> void set(Class<T> type, Pool<T> pool) {
        typePools.put(type, pool);
    }

    public static <T> T obtain(Class<T> type) {
        return Pools.get(type).obtain();
    }

    public static void free(Object object) {
        Pool pool = typePools.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }
}

