/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.concurrent;

import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.Function;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javafx.concurrent.Task;

public abstract class IOTask<T> {
    private static Executor defaultExecutor = Runnable::run;
    private static Consumer<Throwable> defaultFailAction = System.out::println;
    private static final UIDialogHandler DUMMY_DIALOG = new UIDialogHandler(){

        @Override
        public void show() {
        }

        @Override
        public void dismiss() {
        }
    };
    private Consumer<T> successAction = result -> {};
    private Consumer<Throwable> failAction = defaultFailAction;
    private String name;

    public static void setDefaultExecutor(Executor defaultExecutor) {
        IOTask.defaultExecutor = defaultExecutor;
    }

    public static void setDefaultFailAction(Consumer<Throwable> defaultFailAction) {
        IOTask.defaultFailAction = defaultFailAction;
    }

    public IOTask() {
        this("NoName");
    }

    public IOTask(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    protected abstract T onExecute() throws Exception;

    public final T run() {
        try {
            T value = this.onExecute();
            this.succeed(value);
            return value;
        }
        catch (Exception e) {
            this.fail(e);
            return null;
        }
    }

    public final void runAsync() {
        this.runAsync(defaultExecutor);
    }

    public final void runAsync(Executor executor2) {
        executor2.execute(this::run);
    }

    public final void runAsyncFX() {
        this.runAsyncFX(defaultExecutor);
    }

    public final void runAsyncFX(Executor executor2) {
        this.runAsyncFXWithDialog(executor2, DUMMY_DIALOG);
    }

    public final void runAsyncFXWithDialog(UIDialogHandler dialog2) {
        this.runAsyncFXWithDialog(defaultExecutor, dialog2);
    }

    public final void runAsyncFXWithDialog(Executor executor2, final UIDialogHandler dialog2) {
        dialog2.show();
        Task task = new Task<T>(){

            @Override
            protected T call() throws Exception {
                return IOTask.this.onExecute();
            }

            @Override
            protected void succeeded() {
                dialog2.dismiss();
                IOTask.this.succeed(this.getValue());
            }

            @Override
            protected void failed() {
                dialog2.dismiss();
                IOTask.this.fail(this.getException());
            }
        };
        executor2.execute(task);
    }

    public final IOTask<T> onSuccess(Consumer<T> successAction) {
        this.successAction = successAction;
        return this;
    }

    public final IOTask<T> onFailure(Consumer<Throwable> failAction) {
        this.failAction = failAction;
        return this;
    }

    public final <R> IOTask<R> then(Function<T, IOTask<R>> mapper) {
        return IOTask.of(this.name, () -> ((IOTask)mapper.apply(this.onExecute())).onExecute());
    }

    public final <R> IOTask<R> thenWrap(Function<T, R> mapper) {
        return this.then(t -> IOTask.of(() -> mapper.apply(t)));
    }

    private void succeed(T result) {
        this.successAction.accept(result);
    }

    private void fail(Throwable error) {
        this.failAction.accept(error);
    }

    public static IOTask<Void> ofVoid(Runnable action) {
        return IOTask.ofVoid("IOTask", action);
    }

    public static IOTask<Void> ofVoid(String name, Runnable action) {
        return IOTask.of(name, () -> {
            action.run();
            return null;
        });
    }

    public static <R> IOTask<R> of(Callable<R> action) {
        return IOTask.of("IOTask", action);
    }

    public static <R> IOTask<R> of(String name, final Callable<R> action) {
        return new IOTask<R>(name){

            @Override
            protected R onExecute() throws Exception {
                return action.call();
            }
        };
    }

    public static interface UIDialogHandler {
        public void show();

        public void dismiss();
    }
}

