/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.concurrent;

import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.concurrent.Executor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\b0\u0004\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/core/concurrent/FXGLExecutor;", "Lcom/almasb/fxgl/core/concurrent/Executor;", "()V", "async", "Lcom/almasb/fxgl/core/concurrent/Async;", "Ljava/lang/Void;", "func", "Ljava/lang/Runnable;", "T", "", "Ljava/util/concurrent/Callable;", "execute", "", "task", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "action", "delay", "Ljavafx/util/Duration;", "shutdownNow", "Companion", "FXGLThreadFactory", "fxgl-core"})
public final class FXGLExecutor
implements Executor {
    private static final ExecutorService service;
    private static final ScheduledExecutorService schedulerService;
    public static final Companion Companion;

    @Override
    public void execute(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull(task, "task");
        service.submit(task);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable action, @NotNull Duration delay) {
        Intrinsics.checkParameterIsNotNull(action, "action");
        Intrinsics.checkParameterIsNotNull(delay, "delay");
        ScheduledFuture<?> scheduledFuture = schedulerService.schedule(action, (long)delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, "schedulerService.schedul\u2026), TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    @Override
    @NotNull
    public <T> Async<T> async(@NotNull Callable<T> func) {
        Intrinsics.checkParameterIsNotNull(func, "func");
        Async<T> async = Async.start(func);
        Intrinsics.checkExpressionValueIsNotNull(async, "Async.start(func)");
        return async;
    }

    @Override
    @NotNull
    public Async<Void> async(@NotNull Runnable func) {
        Intrinsics.checkParameterIsNotNull(func, "func");
        Async<Void> async = Async.start(func);
        Intrinsics.checkExpressionValueIsNotNull(async, "Async.start(func)");
        return async;
    }

    @Override
    public void shutdownNow() {
        service.shutdownNow();
        schedulerService.shutdownNow();
    }

    static {
        Companion = new Companion(null);
        service = Executors.newCachedThreadPool(FXGLThreadFactory.INSTANCE);
        schedulerService = Executors.newScheduledThreadPool(2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/almasb/fxgl/core/concurrent/FXGLExecutor$FXGLThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "group", "Ljava/lang/ThreadGroup;", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "fxgl-core"})
    private static final class FXGLThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group;
        private static final AtomicInteger threadNumber;
        public static final FXGLThreadFactory INSTANCE;

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkParameterIsNotNull(r, "r");
            Thread t = new Thread(group, r, "FXGL Background Thread " + threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        private FXGLThreadFactory() {
        }

        static {
            ThreadGroup threadGroup;
            FXGLThreadFactory fXGLThreadFactory;
            INSTANCE = fXGLThreadFactory = new FXGLThreadFactory();
            threadNumber = new AtomicInteger(1);
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                ThreadGroup threadGroup2 = s.getThreadGroup();
                threadGroup = threadGroup2;
                Intrinsics.checkExpressionValueIsNotNull(threadGroup2, "s.threadGroup");
            } else {
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                ThreadGroup threadGroup3 = thread2.getThreadGroup();
                threadGroup = threadGroup3;
                Intrinsics.checkExpressionValueIsNotNull(threadGroup3, "Thread.currentThread().threadGroup");
            }
            group = threadGroup;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/almasb/fxgl/core/concurrent/FXGLExecutor$Companion;", "", "()V", "schedulerService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "service", "Ljava/util/concurrent/ExecutorService;", "getService", "()Ljava/util/concurrent/ExecutorService;", "fxgl-core"})
    public static final class Companion {
        public final ExecutorService getService() {
            return service;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

