/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.collection;

import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.collection.PropertyChangeListener;
import com.almasb.fxgl.core.util.Optional;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001b\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00170\u00172\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\n \u001a*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\n \u001a*\u0004\u0018\u00010 0 2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\n \u001a*\u0004\u0018\u0001H\rH\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\n \u001a*\u0004\u0018\u00010\n0\n2\u0006\u0010\u000e\u001a\u00020\nJ\u0019\u0010%\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010#J\u000e\u0010&\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\nJ\u001a\u0010'\u001a\b\u0012\u0004\u0012\u0002H\r0(\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010)\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u001dJ\u0016\u0010)\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010*\u001a\u00020 J\u000e\u0010+\u001a\u00020,2\u0006\u0010\u000e\u001a\u00020\nJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0.J\u001a\u0010/\u001a\b\u0012\u0004\u0012\u0002H\r00\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u00101\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nJ\"\u00102\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010J\u0016\u00103\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u0001J\u000e\u00104\u001a\u0002052\u0006\u0010\u000e\u001a\u00020\nJ\b\u00106\u001a\u00020\nH\u0016R2\u0010\u0003\u001a&\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004j\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/almasb/fxgl/core/collection/PropertyMap;", "", "()V", "listeners", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/core/collection/PropertyMap$ListenerKey;", "Ljavafx/beans/value/ChangeListener;", "Lkotlin/collections/HashMap;", "properties", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "", "addListener", "", "T", "propertyName", "listener", "Lcom/almasb/fxgl/core/collection/PropertyChangeListener;", "booleanProperty", "Ljavafx/beans/property/BooleanProperty;", "clear", "doubleProperty", "Ljavafx/beans/property/DoubleProperty;", "exists", "", "get", "getBoolean", "kotlin.jvm.PlatformType", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "getInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getObject", "(Ljava/lang/String;)Ljava/lang/Object;", "getString", "getValue", "getValueObservable", "getValueOptional", "Lcom/almasb/fxgl/core/util/Optional;", "increment", "value", "intProperty", "Ljavafx/beans/property/IntegerProperty;", "keys", "", "objectProperty", "Ljavafx/beans/property/ObjectProperty;", "remove", "removeListener", "setValue", "stringProperty", "Ljavafx/beans/property/StringProperty;", "toString", "ListenerKey", "fxgl-core"})
public final class PropertyMap {
    private final ObjectMap<String, Object> properties = new ObjectMap(32);
    private final HashMap<ListenerKey, ChangeListener<?>> listeners;

    @NotNull
    public final Set<String> keys() {
        ObjectMap.Keys<String> keys2 = this.properties.keys();
        Intrinsics.checkExpressionValueIsNotNull(keys2, "properties.keys()");
        return CollectionsKt.toSet((Iterable)keys2);
    }

    public final boolean exists(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.properties.containsKey(propertyName);
    }

    @NotNull
    public final <T> Optional<T> getValueOptional(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        try {
            Optional<T> optional = Optional.ofNullable(this.getValue(propertyName));
            Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.ofNullable(getValue(propertyName))");
            return optional;
        }
        catch (Exception e) {
            Optional optional = Optional.empty();
            Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.empty()");
            return optional;
        }
    }

    public final <T> T getValue(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.value.ObservableValue<*>");
        }
        return ((ObservableValue)object).getValue();
    }

    @NotNull
    public final Object getValueObservable(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.get(propertyName);
    }

    public final void setValue(@NotNull String propertyName, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (this.exists(propertyName)) {
            Object object = value;
            if (object instanceof Boolean) {
                this.booleanProperty(propertyName).setValue((Boolean)value);
            } else if (object instanceof Integer) {
                this.intProperty(propertyName).setValue((Number)value);
            } else if (object instanceof Double) {
                this.doubleProperty(propertyName).setValue((Number)value);
            } else if (object instanceof String) {
                this.stringProperty(propertyName).setValue((String)value);
            } else {
                this.objectProperty(propertyName).setValue(value);
            }
        } else {
            Object object = value;
            Property property = object instanceof Boolean ? (Property)new SimpleBooleanProperty((Boolean)value) : (object instanceof Integer ? (Property)new SimpleIntegerProperty(((Number)value).intValue()) : (object instanceof Double ? (Property)new SimpleDoubleProperty(((Number)value).doubleValue()) : (object instanceof String ? (Property)new SimpleStringProperty((String)value) : (Property)new SimpleObjectProperty<Object>(value))));
            this.properties.put(propertyName, property);
        }
    }

    public final void remove(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        this.properties.remove(propertyName);
    }

    public final void increment(@NotNull String propertyName, int value) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        IntegerProperty integerProperty = this.intProperty(propertyName);
        integerProperty.setValue(integerProperty.getValue() + value);
    }

    public final void increment(@NotNull String propertyName, double value) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        DoubleProperty doubleProperty = this.doubleProperty(propertyName);
        doubleProperty.setValue(doubleProperty.getValue() + value);
    }

    public final Boolean getBoolean(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.booleanProperty(propertyName).getValue();
    }

    public final Integer getInt(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.intProperty(propertyName).getValue();
    }

    public final Double getDouble(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.doubleProperty(propertyName).getValue();
    }

    public final String getString(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.stringProperty(propertyName).getValue();
    }

    public final <T> T getObject(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        return this.objectProperty(propertyName).getValue();
    }

    @NotNull
    public final BooleanProperty booleanProperty(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.property.BooleanProperty");
        }
        return (BooleanProperty)object;
    }

    @NotNull
    public final IntegerProperty intProperty(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.property.IntegerProperty");
        }
        return (IntegerProperty)object;
    }

    @NotNull
    public final DoubleProperty doubleProperty(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.property.DoubleProperty");
        }
        return (DoubleProperty)object;
    }

    @NotNull
    public final StringProperty stringProperty(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.property.StringProperty");
        }
        return (StringProperty)object;
    }

    @NotNull
    public final <T> ObjectProperty<T> objectProperty(@NotNull String propertyName) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.property.ObjectProperty<T>");
        }
        return (ObjectProperty)object;
    }

    public final <T> void addListener(@NotNull String propertyName, @NotNull PropertyChangeListener<? super T> listener2) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Intrinsics.checkParameterIsNotNull(listener2, "listener");
        ChangeListener internalListener2 = new ChangeListener<T>(listener2){
            final /* synthetic */ PropertyChangeListener $listener;

            public final void changed(ObservableValue<? extends T> $noName_0, T prev, T now) {
                this.$listener.onChange(prev, now);
            }
            {
                this.$listener = propertyChangeListener;
            }
        };
        ListenerKey key = new ListenerKey(propertyName, listener2);
        Map map = this.listeners;
        ChangeListener changeListener = internalListener2;
        map.put(key, changeListener);
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.value.ObservableValue<T>");
        }
        ((ObservableValue)object).addListener(internalListener2);
    }

    public final <T> void removeListener(@NotNull String propertyName, @NotNull PropertyChangeListener<? super T> listener2) {
        Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
        Intrinsics.checkParameterIsNotNull(listener2, "listener");
        ListenerKey key = new ListenerKey(propertyName, listener2);
        Object object = this.get(propertyName);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.value.ObservableValue<T>");
        }
        ChangeListener<?> changeListener = this.listeners.get(key);
        if (changeListener == null) {
            throw new TypeCastException("null cannot be cast to non-null type javafx.beans.value.ChangeListener<in T>");
        }
        ((ObservableValue)object).removeListener(changeListener);
        this.listeners.remove(key);
    }

    public final void clear() {
        Map $receiver$iv;
        Map map = $receiver$iv = (Map)this.listeners;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $key_listener = element$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = $key_listener;
            ListenerKey key = (ListenerKey)entry.getKey();
            entry = $key_listener;
            ChangeListener listener2 = (ChangeListener)entry.getValue();
            Object object = this.get(key.getPropertyName());
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type javafx.beans.value.ObservableValue<kotlin.Any>");
            }
            ChangeListener changeListener = listener2;
            if (changeListener == null) {
                throw new TypeCastException("null cannot be cast to non-null type javafx.beans.value.ChangeListener<kotlin.Any>");
            }
            ((ObservableValue)object).removeListener(changeListener);
        }
        this.listeners.clear();
        this.properties.clear();
    }

    private final Object get(String propertyName) {
        Object object = this.properties.get(propertyName);
        if (object == null) {
            throw (Throwable)new IllegalArgumentException("Property " + propertyName + " does not exist");
        }
        return object;
    }

    @NotNull
    public String toString() {
        return this.properties.toMap().toString();
    }

    public PropertyMap() {
        PropertyMap propertyMap = this;
        HashMap hashMap = new HashMap();
        propertyMap.listeners = hashMap;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/core/collection/PropertyMap$ListenerKey;", "", "propertyName", "", "propertyListener", "Lcom/almasb/fxgl/core/collection/PropertyChangeListener;", "(Ljava/lang/String;Lcom/almasb/fxgl/core/collection/PropertyChangeListener;)V", "getPropertyListener", "()Lcom/almasb/fxgl/core/collection/PropertyChangeListener;", "getPropertyName", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "fxgl-core"})
    private static final class ListenerKey {
        @NotNull
        private final String propertyName;
        @NotNull
        private final PropertyChangeListener<?> propertyListener;

        public int hashCode() {
            return Objects.hash(this.propertyName, this.propertyListener);
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.core.collection.PropertyMap.ListenerKey");
            }
            ListenerKey o = (ListenerKey)object;
            return Intrinsics.areEqual(this.propertyName, o.propertyName) && this.propertyListener == o.propertyListener;
        }

        @NotNull
        public final String getPropertyName() {
            return this.propertyName;
        }

        @NotNull
        public final PropertyChangeListener<?> getPropertyListener() {
            return this.propertyListener;
        }

        public ListenerKey(@NotNull String propertyName, @NotNull PropertyChangeListener<?> propertyListener) {
            Intrinsics.checkParameterIsNotNull(propertyName, "propertyName");
            Intrinsics.checkParameterIsNotNull(propertyListener, "propertyListener");
            this.propertyName = propertyName;
            this.propertyListener = propertyListener;
        }
    }
}

