/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio.impl;

import com.almasb.fxgl.audio.Audio;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.impl.DefaultAudioService;
import com.almasb.fxgl.audio.impl.DesktopMusic;
import com.almasb.fxgl.audio.impl.DesktopSound;
import java.net.URL;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/almasb/fxgl/audio/impl/DesktopAudioService;", "Lcom/almasb/fxgl/audio/impl/DefaultAudioService;", "()V", "loadAudioImpl", "Lcom/almasb/fxgl/audio/Audio;", "type", "Lcom/almasb/fxgl/audio/AudioType;", "resourceURL", "Ljava/net/URL;", "fxgl-media"})
public final class DesktopAudioService
extends DefaultAudioService {
    @Override
    @NotNull
    protected Audio loadAudioImpl(@NotNull AudioType type, @NotNull URL resourceURL) {
        Audio audio2;
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        Intrinsics.checkParameterIsNotNull(resourceURL, "resourceURL");
        String url = resourceURL.toExternalForm();
        if (type == AudioType.MUSIC) {
            String string = url;
            Intrinsics.checkExpressionValueIsNotNull(string, "url");
            audio2 = new DesktopMusic(string, new MediaPlayer(new Media(url)));
        } else {
            String string = url;
            Intrinsics.checkExpressionValueIsNotNull(string, "url");
            audio2 = new DesktopSound(string, new AudioClip(url));
        }
        return audio2;
    }
}

