/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.GameView;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.gameplay.GameState;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.Viewport;
import com.almasb.fxgl.ui.UI;
import com.almasb.sslogger.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB/\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020!J\u001f\u0010.\u001a\u00020&2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020!00\"\u00020!\u00a2\u0006\u0002\u00101J\u0006\u00102\u001a\u00020&J\u0006\u00103\u001a\u00020&J\u0006\u00104\u001a\u00020&J\u0010\u00105\u001a\u00020&2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020&2\u0006\u00106\u001a\u000207H\u0002J\u0018\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020\u000fH\u0016J\u0010\u0010?\u001a\u00020&2\u0006\u0010>\u001a\u00020\u000fH\u0016J\u0010\u0010@\u001a\u00020&2\u0006\u0010A\u001a\u00020;H\u0014J\u000e\u0010B\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010C\u001a\u00020&2\u0006\u0010*\u001a\u00020+J\u000e\u0010D\u001a\u00020\u00182\u0006\u0010E\u001a\u00020!J\u001f\u0010F\u001a\u00020&2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020!00\"\u00020!\u00a2\u0006\u0002\u00101J\u000e\u0010G\u001a\u00020&2\u0006\u0010H\u001a\u00020\u0018J\b\u0010I\u001a\u00020&H\u0002J\u000e\u0010J\u001a\u00020&2\u0006\u0010A\u001a\u00020;R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/almasb/fxgl/app/GameScene;", "Lcom/almasb/fxgl/scene/FXGLScene;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "width", "", "height", "gameState", "Lcom/almasb/fxgl/gameplay/GameState;", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "(IILcom/almasb/fxgl/gameplay/GameState;Lcom/almasb/fxgl/entity/GameWorld;Lcom/almasb/fxgl/physics/PhysicsWorld;)V", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "gameRoot", "Ljavafx/scene/Group;", "getGameState", "()Lcom/almasb/fxgl/gameplay/GameState;", "getGameWorld", "()Lcom/almasb/fxgl/entity/GameWorld;", "isSingleStep", "", "()Z", "setSingleStep", "(Z)V", "isZSortingNeeded", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "uiNodes", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/Node;", "getUiNodes", "()Ljavafx/collections/ObservableList;", "uiRoot", "addGameView", "", "view", "Lcom/almasb/fxgl/app/GameView;", "addUI", "ui", "Lcom/almasb/fxgl/ui/UI;", "addUINode", "node", "addUINodes", "nodes", "", "([Ljavafx/scene/Node;)V", "clear", "clearGameViews", "clearUINodes", "destroyView", "viewComponent", "Lcom/almasb/fxgl/entity/components/ViewComponent;", "initView", "initViewport", "w", "", "h", "onEntityAdded", "entity", "onEntityRemoved", "onUpdate", "tpf", "removeGameView", "removeUI", "removeUINode", "n", "removeUINodes", "setUIMouseTransparent", "b", "sortZ", "step", "Companion", "fxgl"})
public final class GameScene
extends FXGLScene
implements EntityWorldListener {
    private final Group gameRoot;
    private final Group uiRoot;
    private final ArrayList<Entity> entities;
    private boolean isZSortingNeeded;
    private boolean isSingleStep;
    @NotNull
    private final GameState gameState;
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final ObservableList<Node> getUiNodes() {
        ObservableList<Node> observableList = this.uiRoot.getChildrenUnmodifiable();
        Intrinsics.checkExpressionValueIsNotNull(observableList, "uiRoot.childrenUnmodifiable");
        return observableList;
    }

    public final boolean isSingleStep() {
        return this.isSingleStep;
    }

    public final void setSingleStep(boolean bl) {
        this.isSingleStep = bl;
    }

    private final void initViewport(double w, double h) {
        Viewport viewport = this.getViewport();
        this.gameRoot.layoutXProperty().bind(viewport.xProperty().negate());
        this.gameRoot.layoutYProperty().bind(viewport.yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind(viewport.xProperty());
        scale.pivotYProperty().bind(viewport.yProperty());
        scale.xProperty().bind(viewport.zoomProperty());
        scale.yProperty().bind(viewport.zoomProperty());
        this.gameRoot.getTransforms().add(scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind(viewport.xProperty().add(w / (double)2));
        rotate.pivotYProperty().bind(viewport.yProperty().add(h / (double)2));
        rotate.angleProperty().bind(viewport.angleProperty().negate());
        this.gameRoot.getTransforms().add(rotate);
    }

    @Override
    protected void onUpdate(double tpf) {
        if (this.isSingleStep) {
            return;
        }
        this.step(tpf);
    }

    public final void step(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getViewport().onUpdate(tpf);
        if (this.isZSortingNeeded) {
            this.sortZ();
            this.isZSortingNeeded = false;
        }
    }

    public final void addUINode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        this.uiRoot.getChildren().add(node);
    }

    public final void addUINodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public final boolean removeUINode(@NotNull Node n) {
        Intrinsics.checkParameterIsNotNull(n, "n");
        return this.uiRoot.getChildren().remove(n);
    }

    public final void removeUINodes(Node ... nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, "nodes");
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public final void addUI(@NotNull UI ui) {
        Intrinsics.checkParameterIsNotNull(ui, "ui");
        this.addUINode(ui.getRoot());
    }

    public final void removeUI(@NotNull UI ui) {
        Intrinsics.checkParameterIsNotNull(ui, "ui");
        this.removeUINode(ui.getRoot());
    }

    public final void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public final void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public final void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    private final void sortZ() {
        ArrayList tmp = new ArrayList(this.gameRoot.getChildren());
        List $receiver$iv = tmp;
        if ($receiver$iv.size() > 1) {
            List list = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Node it = (Node)a;
                    boolean bl = false;
                    Node node = it;
                    Intrinsics.checkExpressionValueIsNotNull(node, "it");
                    V v = node.getProperties().get("viewData");
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.GameView");
                    }
                    it = (Node)b;
                    Comparable comparable = Integer.valueOf(((GameView)v).getZ());
                    bl = false;
                    Node node2 = it;
                    Intrinsics.checkExpressionValueIsNotNull(node2, "it");
                    V v2 = node2.getProperties().get("viewData");
                    if (v2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.GameView");
                    }
                    Integer n = ((GameView)v2).getZ();
                    return ComparisonsKt.compareValues(comparable, (Comparable)n);
                }
            };
            CollectionsKt.sortWith(list, comparator);
        }
        this.gameRoot.getChildren().setAll(tmp);
    }

    public final void clear() {
        log.debug("Clearing game scene");
        this.getViewport().unbind();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
    }

    @Override
    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        this.entities.add(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkExpressionValueIsNotNull(viewComponent, "entity.viewComponent");
        this.initView(viewComponent);
    }

    @Override
    public void onEntityRemoved(@NotNull Entity entity) {
        Intrinsics.checkParameterIsNotNull(entity, "entity");
        this.entities.remove(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkExpressionValueIsNotNull(viewComponent, "entity.viewComponent");
        this.destroyView(viewComponent);
    }

    public final void addGameView(@NotNull GameView view) {
        Intrinsics.checkParameterIsNotNull(view, "view");
        ObservableMap<Object, Object> observableMap = view.getNode().getProperties();
        Intrinsics.checkExpressionValueIsNotNull(observableMap, "view.node.properties");
        Map map = observableMap;
        String string = "viewData";
        GameView gameView = view;
        map.put(string, gameView);
        this.gameRoot.getChildren().add(view.getNode());
        this.isZSortingNeeded = true;
    }

    public final void removeGameView(@NotNull GameView view) {
        Intrinsics.checkParameterIsNotNull(view, "view");
        view.getNode().getProperties().clear();
        this.gameRoot.getChildren().remove(view.getNode());
    }

    private final void initView(ViewComponent viewComponent) {
        Node node = viewComponent.getParent();
        Integer n = viewComponent.getZ().getValue();
        Intrinsics.checkExpressionValueIsNotNull(n, "viewComponent.z.value");
        GameView view = new GameView(node, n);
        view.getZProperty().bind(viewComponent.getZ());
        this.addGameView(view);
    }

    private final void destroyView(ViewComponent viewComponent) {
        block1: {
            Object v;
            Object v2 = viewComponent.getParent().getProperties().get("viewData");
            if (v2 == null) break block1;
            Object it = v = v2;
            boolean bl = false;
            Object v3 = it;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.almasb.fxgl.app.GameView");
            }
            GameView view = (GameView)v3;
            view.getZProperty().unbind();
            this.removeGameView(view);
        }
    }

    @NotNull
    public final GameState getGameState() {
        return this.gameState;
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public GameScene(int width, int height, @NotNull GameState gameState, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkParameterIsNotNull(gameState, "gameState");
        Intrinsics.checkParameterIsNotNull(gameWorld, "gameWorld");
        Intrinsics.checkParameterIsNotNull(physicsWorld, "physicsWorld");
        super(width, height);
        this.gameState = gameState;
        this.gameWorld = gameWorld;
        this.physicsWorld = physicsWorld;
        this.gameRoot = new Group();
        this.uiRoot = new Group();
        this.entities = new ArrayList();
        this.getContentRoot().getChildren().addAll((Node[])new Node[]{this.gameRoot, this.uiRoot});
        this.initViewport(width, height);
        this.getContentRoot().getChildren().add(this.getViewport().getCamera().getViewComponent().getParent());
        log.debug("Game scene initialized: " + width + "x" + height);
        this.gameWorld.addWorldListener(this.physicsWorld);
        this.gameWorld.addWorldListener(this);
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get(GameScene.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/GameScene$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

