/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.GameController;
import com.almasb.fxgl.core.local.Local;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.core.util.InputPredicates;
import com.almasb.fxgl.core.util.Supplier;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.Trigger;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.input.view.TriggerView;
import com.almasb.fxgl.saving.SaveFile;
import com.almasb.fxgl.scene.FXGLScene;
import com.almasb.fxgl.scene.MenuType;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.ui.FXGLScrollPane;
import com.almasb.fxgl.ui.FXGLUIConfig;
import com.almasb.sslogger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 M2\u00020\u0001:\u0003MNOB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0004J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020&H$J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020&H$J\u0018\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H$J\b\u0010,\u001a\u00020\u0006H\u0004J\b\u0010-\u001a\u00020\u0006H\u0004J\u001e\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000600H\u0004J\u001e\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000600H\u0004J\b\u00101\u001a\u00020\u0006H\u0004J\b\u00102\u001a\u00020\u0006H\u0004J\b\u00103\u001a\u00020\u0006H\u0004J\b\u00104\u001a\u00020\u0006H\u0004J\b\u00105\u001a\u00020\u0006H\u0004J\b\u00106\u001a\u00020\u0006H\u0004J\u0010\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020'H$J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020'H$J\u0010\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020'H$J\b\u0010=\u001a\u00020\u0018H\u0004J\u0010\u0010>\u001a\u00020\u00182\u0006\u0010?\u001a\u00020@H\u0004J\b\u0010A\u001a\u00020\u0018H\u0004J\b\u0010B\u001a\u00020\u0018H\u0004J\u0010\u0010C\u001a\u00020\u00182\u0006\u0010D\u001a\u00020@H\u0004J\b\u0010E\u001a\u00020\u0018H\u0004J\b\u0010F\u001a\u00020\u0018H\u0004J\b\u0010G\u001a\u00020\u0018H\u0004J\b\u0010H\u001a\u00020'H\u0002J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010J\u001a\u00020!H\u0014J\u0010\u0010K\u001a\u00020\u00182\u0006\u0010L\u001a\u00020!H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006P"}, d2={"Lcom/almasb/fxgl/app/FXGLMenu;", "Lcom/almasb/fxgl/scene/FXGLScene;", "type", "Lcom/almasb/fxgl/scene/MenuType;", "(Lcom/almasb/fxgl/scene/MenuType;)V", "EMPTY", "Lcom/almasb/fxgl/app/FXGLMenu$MenuContent;", "getEMPTY$fxgl", "()Lcom/almasb/fxgl/app/FXGLMenu$MenuContent;", "controller", "Lcom/almasb/fxgl/app/GameController;", "getController", "()Lcom/almasb/fxgl/app/GameController;", "menuContentRoot", "Ljavafx/scene/layout/Pane;", "getMenuContentRoot", "()Ljavafx/scene/layout/Pane;", "menuRoot", "getMenuRoot", "pressAnyKeyState", "Lcom/almasb/fxgl/app/FXGLMenu$PressAnyKeyState;", "getType", "()Lcom/almasb/fxgl/scene/MenuType;", "addNewInputBinding", "", "action", "Lcom/almasb/fxgl/input/UserAction;", "trigger", "Lcom/almasb/fxgl/input/Trigger;", "grid", "Ljavafx/scene/layout/GridPane;", "addUINode", "node", "Ljavafx/scene/Node;", "createActionButton", "Ljavafx/scene/control/Button;", "name", "Ljavafx/beans/binding/StringBinding;", "Ljava/lang/Runnable;", "", "createBackground", "width", "", "height", "createContentAchievements", "createContentAudio", "createContentButton", "contentSupplier", "Lcom/almasb/fxgl/core/util/Supplier;", "createContentControls", "createContentCredits", "createContentFeedback", "createContentGameplay", "createContentLoad", "createContentVideo", "createProfileView", "profileName", "createTitleView", "title", "createVersionView", "version", "fireContinue", "fireDelete", "fileName", "Lcom/almasb/fxgl/saving/SaveFile;", "fireExit", "fireExitToMainMenu", "fireLoad", "saveFile", "fireNewGame", "fireResume", "fireSave", "makeVersionString", "switchMenuContentTo", "content", "switchMenuTo", "menuBox", "Companion", "MenuContent", "PressAnyKeyState", "fxgl"})
public abstract class FXGLMenu
extends FXGLScene {
    @NotNull
    private final GameController controller;
    @NotNull
    private final Pane menuRoot;
    @NotNull
    private final Pane menuContentRoot;
    @NotNull
    private final MenuContent EMPTY;
    private final PressAnyKeyState pressAnyKeyState;
    @NotNull
    private final MenuType type;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final GameController getController() {
        return this.controller;
    }

    @NotNull
    protected final Pane getMenuRoot() {
        return this.menuRoot;
    }

    @NotNull
    protected final Pane getMenuContentRoot() {
        return this.menuContentRoot;
    }

    @NotNull
    public final MenuContent getEMPTY$fxgl() {
        return this.EMPTY;
    }

    protected void switchMenuTo(@NotNull Node menuBox) {
        Intrinsics.checkParameterIsNotNull(menuBox, "menuBox");
    }

    protected void switchMenuContentTo(@NotNull Node content) {
        Intrinsics.checkParameterIsNotNull(content, "content");
    }

    @NotNull
    protected abstract Button createActionButton(@NotNull String var1, @NotNull Runnable var2);

    @NotNull
    protected abstract Button createActionButton(@NotNull StringBinding var1, @NotNull Runnable var2);

    @NotNull
    protected final Button createContentButton(@NotNull String name, @NotNull Supplier<MenuContent> contentSupplier) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(contentSupplier, "contentSupplier");
        return this.createActionButton(name, new Runnable(this, contentSupplier){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ Supplier $contentSupplier;

            public final void run() {
                T t = this.$contentSupplier.get();
                Intrinsics.checkExpressionValueIsNotNull(t, "contentSupplier.get()");
                this.this$0.switchMenuContentTo((Node)t);
            }
            {
                this.this$0 = fXGLMenu;
                this.$contentSupplier = supplier;
            }
        });
    }

    @NotNull
    protected final Button createContentButton(@NotNull StringBinding name, @NotNull Supplier<MenuContent> contentSupplier) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(contentSupplier, "contentSupplier");
        return this.createActionButton(name, new Runnable(this, contentSupplier){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ Supplier $contentSupplier;

            public final void run() {
                T t = this.$contentSupplier.get();
                Intrinsics.checkExpressionValueIsNotNull(t, "contentSupplier.get()");
                this.this$0.switchMenuContentTo((Node)t);
            }
            {
                this.this$0 = fXGLMenu;
                this.$contentSupplier = supplier;
            }
        });
    }

    private final String makeVersionString() {
        return "v" + FXGLForKtKt.getSettings().getVersion() + (FXGLForKtKt.getSettings().getApplicationMode() == ApplicationMode.RELEASE ? "" : "-" + (Object)((Object)FXGLForKtKt.getSettings().getApplicationMode()));
    }

    @NotNull
    protected abstract Node createBackground(double var1, double var3);

    @NotNull
    protected abstract Node createTitleView(@NotNull String var1);

    @NotNull
    protected abstract Node createVersionView(@NotNull String var1);

    @NotNull
    protected abstract Node createProfileView(@NotNull String var1);

    @NotNull
    protected final MenuContent createContentLoad() {
        log.debug("createContentLoad()");
        return new MenuContent(new Node[0]);
    }

    @NotNull
    protected final MenuContent createContentGameplay() {
        log.debug("createContentGameplay()");
        return new MenuContent(new Node[0]);
    }

    @NotNull
    protected final MenuContent createContentControls() {
        log.debug("createContentControls()");
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        grid.getColumnConstraints().add(new ColumnConstraints(200.0, 200.0, 200.0, Priority.ALWAYS, HPos.LEFT, true));
        grid.getRowConstraints().add(new RowConstraints(40.0, 40.0, 40.0, Priority.ALWAYS, VPos.CENTER, true));
        grid.setUserData(0);
        FXGLForKtKt.getInput().getAllBindings().forEach(new BiConsumer<UserAction, Trigger>(this, grid){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ GridPane $grid;

            public final void accept(@NotNull UserAction action, @NotNull Trigger trigger) {
                Intrinsics.checkParameterIsNotNull(action, "action");
                Intrinsics.checkParameterIsNotNull(trigger, "trigger");
                FXGLMenu.access$addNewInputBinding(this.this$0, action, trigger, this.$grid);
            }
            {
                this.this$0 = fXGLMenu;
                this.$grid = gridPane;
            }
        });
        FXGLScrollPane scroll = new FXGLScrollPane(grid);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        scroll.setMaxHeight((double)FXGLForKtKt.getAppHeight() / 2.5);
        HBox hbox = new HBox(scroll);
        hbox.setAlignment(Pos.CENTER);
        return new MenuContent(hbox);
    }

    private final void addNewInputBinding(UserAction action, Trigger trigger, GridPane grid) {
        Text actionName = FXGLUIConfig.getUIFactory().newText(action.getName(), Color.WHITE, 18.0);
        TriggerView triggerView = new TriggerView(trigger, null, 0.0, 6, null);
        triggerView.triggerProperty().bind((ObservableValue<Trigger>)FXGLForKtKt.getInput().triggerProperty(action));
        triggerView.setOnMouseClicked((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(this, action){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ UserAction $action;

            public final void handle(MouseEvent event) {
                FXGLMenu.access$getPressAnyKeyState$p(this.this$0).setActionContext$fxgl(this.$action);
                this.this$0.getController().pushSubScene(FXGLMenu.access$getPressAnyKeyState$p(this.this$0));
            }
            {
                this.this$0 = fXGLMenu;
                this.$action = userAction;
            }
        });
        HBox hBox = new HBox();
        hBox.setPrefWidth(100.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add(triggerView);
        Object object = grid.getUserData();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int controlsRow = (Integer)object;
        grid.addRow(controlsRow++, actionName, hBox);
        grid.setUserData(controlsRow);
    }

    @NotNull
    protected final MenuContent createContentVideo() {
        ChoiceBox languageBox;
        log.debug("createContentVideo()");
        ChoiceBox choiceBox = languageBox = FXGLUIConfig.getUIFactory().newChoiceBox(FXCollections.observableArrayList((Collection)Local.getLanguages()));
        Intrinsics.checkExpressionValueIsNotNull(choiceBox, "languageBox");
        choiceBox.setValue(FXGLForKtKt.getSettings().getLanguage().getValue());
        FXGLForKtKt.getSettings().getLanguage().bindBidirectional(languageBox.valueProperty());
        VBox vbox = new VBox();
        if (FXGLForKtKt.getSettings().isFullScreenAllowed()) {
            CheckBox cbFullScreen;
            CheckBox checkBox = cbFullScreen = FXGLUIConfig.getUIFactory().newCheckBox();
            Intrinsics.checkExpressionValueIsNotNull(checkBox, "cbFullScreen");
            checkBox.setSelected(false);
            cbFullScreen.selectedProperty().bindBidirectional(FXGLForKtKt.getSettings().getFullScreen());
            vbox.getChildren().add(new HBox(25.0, FXGLUIConfig.getUIFactory().newText(Local.getLocalizedString("menu.fullscreen") + ": "), cbFullScreen));
        }
        return new MenuContent(new HBox(25.0, FXGLUIConfig.getUIFactory().newText(Local.localizedStringProperty("menu.language").concat(":")), languageBox), vbox);
    }

    @NotNull
    protected final MenuContent createContentAudio() {
        log.debug("createContentAudio()");
        Slider sliderMusic = new Slider(0.0, 1.0, 1.0);
        sliderMusic.valueProperty().bindBidirectional(FXGLForKtKt.getSettings().globalMusicVolumeProperty());
        Text textMusic = FXGLUIConfig.getUIFactory().newText(Local.localizedStringProperty("menu.music.volume").concat(": "));
        Text percentMusic = FXGLUIConfig.getUIFactory().newText("");
        percentMusic.textProperty().bind(sliderMusic.valueProperty().multiply(100).asString("%.0f"));
        Slider sliderSound = new Slider(0.0, 1.0, 1.0);
        sliderSound.valueProperty().bindBidirectional(FXGLForKtKt.getSettings().globalSoundVolumeProperty());
        Text textSound = FXGLUIConfig.getUIFactory().newText(Local.localizedStringProperty("menu.sound.volume").concat(": "));
        Text percentSound = FXGLUIConfig.getUIFactory().newText("");
        percentSound.textProperty().bind(sliderSound.valueProperty().multiply(100).asString("%.0f"));
        HBox hboxMusic = new HBox(15.0, textMusic, sliderMusic, percentMusic);
        HBox hboxSound = new HBox(15.0, textSound, sliderSound, percentSound);
        hboxMusic.setAlignment(Pos.CENTER_RIGHT);
        hboxSound.setAlignment(Pos.CENTER_RIGHT);
        return new MenuContent(hboxMusic, hboxSound);
    }

    @NotNull
    protected final MenuContent createContentCredits() {
        log.debug("createContentCredits()");
        FXGLScrollPane pane = new FXGLScrollPane();
        pane.setPrefWidth(500.0);
        pane.setPrefHeight(FXGLForKtKt.getAppHeight() / 2);
        pane.setStyle("-fx-background:black;");
        VBox vbox = new VBox();
        vbox.setAlignment(Pos.CENTER_LEFT);
        vbox.setPrefWidth(pane.getPrefWidth() - (double)15);
        ArrayList<String> credits = new ArrayList<String>((Collection)FXGLForKtKt.getSettings().getCredits());
        credits.add("");
        credits.add("Powered by FXGL " + FXGL.Companion.getVersion());
        credits.add("Author: Almas Baimagambetov");
        credits.add("https://github.com/AlmasB/FXGL");
        credits.add("");
        for (String credit : credits) {
            if (credit.length() > 45) {
                log.warning("Credit name length > 45: " + credit);
            }
            vbox.getChildren().add(FXGLUIConfig.getUIFactory().newText(credit));
        }
        pane.setContent(vbox);
        return new MenuContent(pane);
    }

    @NotNull
    protected final MenuContent createContentFeedback() {
        log.debug("createContentFeedback()");
        return new MenuContent(new VBox());
    }

    @NotNull
    protected final MenuContent createContentAchievements() {
        log.debug("createContentAchievements()");
        MenuContent content = new MenuContent(new Node[0]);
        Iterable $receiver$iv = FXGLForKtKt.getAchievementService().getAchievementsCopy();
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            CheckBox checkBox = new CheckBox();
            checkBox.setDisable(true);
            checkBox.selectedProperty().bind(a.achievedProperty());
            Text text = FXGLUIConfig.getUIFactory().newText(a.getName());
            Tooltip tooltip = new Tooltip(a.getDescription());
            tooltip.setShowDelay(Duration.seconds(0.1));
            Tooltip.install(text, tooltip);
            HBox box = new HBox(25.0, text, checkBox);
            box.setAlignment(Pos.CENTER_RIGHT);
            content.getChildren().add(box);
        }
        return content;
    }

    protected final void addUINode(@NotNull Node node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        this.menuContentRoot.getChildren().add(node);
    }

    protected final void fireNewGame() {
        log.debug("fireNewGame()");
        this.controller.startNewGame();
    }

    protected final void fireContinue() {
        log.debug("fireContinue()");
        this.controller.loadGameFromLastSave();
    }

    protected final void fireLoad(@NotNull SaveFile saveFile) {
        Intrinsics.checkParameterIsNotNull(saveFile, "saveFile");
        log.debug("fireLoad()");
        String text = Local.getLocalizedString("menu.loadSave") + " [" + saveFile.getName() + "]?\n" + Local.getLocalizedString("menu.unsavedProgress");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, new Consumer<Boolean>(this, saveFile){
            final /* synthetic */ FXGLMenu this$0;
            final /* synthetic */ SaveFile $saveFile;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull(bl, "yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().loadGame(this.$saveFile);
                }
            }
            {
                this.this$0 = fXGLMenu;
                this.$saveFile = saveFile;
            }
        });
    }

    protected final void fireSave() {
        log.debug("fireSave()");
        FXGLForKtKt.getDisplay().showInputBoxWithCancel(Local.getLocalizedString("menu.enterSaveName"), InputPredicates.ALPHANUM, new Consumer<String>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(String saveFileName) {
                String string = saveFileName;
                Intrinsics.checkExpressionValueIsNotNull(string, "saveFileName");
                CharSequence charSequence = string;
                if (charSequence.length() == 0) {
                    return;
                }
                this.this$0.getController().saveGame(saveFileName);
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    protected final void fireDelete(@NotNull SaveFile fileName) {
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        log.debug("fireDelete()");
    }

    protected final void fireResume() {
        log.debug("fireResume()");
        this.controller.gotoPlay();
    }

    protected final void fireExit() {
        log.debug("fireExit()");
        String text = Local.getLocalizedString("dialog.exitGame");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, new Consumer<Boolean>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull(bl, "yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().exit();
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    protected final void fireExitToMainMenu() {
        log.debug("fireExitToMainMenu()");
        String text = Local.getLocalizedString("menu.exitMainMenu") + "\n" + Local.getLocalizedString("menu.unsavedProgress");
        FXGLForKtKt.getDisplay().showConfirmationBox(text, new Consumer<Boolean>(this){
            final /* synthetic */ FXGLMenu this$0;

            public final void accept(Boolean yes) {
                Boolean bl = yes;
                Intrinsics.checkExpressionValueIsNotNull(bl, "yes");
                if (bl.booleanValue()) {
                    this.this$0.getController().gotoMainMenu();
                }
            }
            {
                this.this$0 = fXGLMenu;
            }
        });
    }

    @NotNull
    protected final MenuType getType() {
        return this.type;
    }

    public FXGLMenu(@NotNull MenuType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        super(0, 0, 3, null);
        this.type = type;
        this.controller = FXGLForKtKt.getGameController();
        this.menuRoot = new Pane();
        this.menuContentRoot = new Pane();
        this.EMPTY = new MenuContent(new Node[0]);
        this.pressAnyKeyState = new PressAnyKeyState();
        this.getContentRoot().getChildren().addAll((Node[])new Node[]{this.createBackground(FXGLForKtKt.getAppWidth(), FXGLForKtKt.getAppHeight()), this.createTitleView(FXGLForKtKt.getSettings().getTitle()), this.createVersionView(this.makeVersionString()), this.menuRoot, this.menuContentRoot});
        this.controller.profileNameProperty().addListener((ChangeListener)new ChangeListener<String>(){

            @Override
            public final void changed(ObservableValue<? extends String> o, String oldName, String newName) {
                String string = oldName;
                Intrinsics.checkExpressionValueIsNotNull(string, "oldName");
                CharSequence charSequence = string;
                if (!(charSequence.length() == 0)) {
                    this.getContentRoot().getChildren().remove(this.getContentRoot().getChildren().size() - 1);
                }
                this.getContentRoot().getChildren().add(this.createProfileView(Local.getLocalizedString("profile.profile") + ": " + newName));
            }
        });
    }

    static {
        Companion = new Companion(null);
        log = Logger.Companion.get("Menu");
    }

    public static final /* synthetic */ void access$addNewInputBinding(FXGLMenu $this, UserAction action, Trigger trigger, GridPane grid) {
        $this.addNewInputBinding(action, trigger, grid);
    }

    public static final /* synthetic */ PressAnyKeyState access$getPressAnyKeyState$p(FXGLMenu $this) {
        return $this.pressAnyKeyState;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/almasb/fxgl/app/FXGLMenu$PressAnyKeyState;", "Lcom/almasb/fxgl/scene/SubScene;", "(Lcom/almasb/fxgl/app/FXGLMenu;)V", "actionContext", "Lcom/almasb/fxgl/input/UserAction;", "getActionContext$fxgl", "()Lcom/almasb/fxgl/input/UserAction;", "setActionContext$fxgl", "(Lcom/almasb/fxgl/input/UserAction;)V", "fxgl"})
    private final class PressAnyKeyState
    extends SubScene {
        @Nullable
        private UserAction actionContext;

        @Nullable
        public final UserAction getActionContext$fxgl() {
            return this.actionContext;
        }

        public final void setActionContext$fxgl(@Nullable UserAction userAction) {
            this.actionContext = userAction;
        }

        public PressAnyKeyState() {
            Input input = this.getInput();
            EventType<KeyEvent> eventType = KeyEvent.KEY_PRESSED;
            Intrinsics.checkExpressionValueIsNotNull(eventType, "KeyEvent.KEY_PRESSED");
            input.addEventHandler(eventType, (EventHandler)new EventHandler<KeyEvent>(){

                @Override
                public final void handle(KeyEvent e) {
                    KeyCode keyCode = e.getCode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)keyCode, "e.getCode()");
                    if (Input.Companion.isIllegal(keyCode)) {
                        return;
                    }
                    Input input = FXGLForKtKt.getInput();
                    UserAction userAction = this.getActionContext$fxgl();
                    if (userAction == null) {
                        Intrinsics.throwNpe();
                    }
                    KeyCode keyCode2 = e.getCode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)keyCode2, "e.getCode()");
                    KeyEvent keyEvent = e;
                    Intrinsics.checkExpressionValueIsNotNull(keyEvent, "e");
                    boolean rebound = input.rebind(userAction, keyCode2, InputModifier.Companion.from(keyEvent));
                    if (rebound) {
                        FXGLMenu.this.getController().popSubScene();
                    }
                }
            });
            Input input2 = this.getInput();
            EventType<MouseEvent> eventType2 = MouseEvent.MOUSE_PRESSED;
            Intrinsics.checkExpressionValueIsNotNull(eventType2, "MouseEvent.MOUSE_PRESSED");
            input2.addEventHandler(eventType2, (EventHandler)new EventHandler<MouseEvent>(){

                @Override
                public final void handle(MouseEvent e) {
                    Input input = FXGLForKtKt.getInput();
                    UserAction userAction = this.getActionContext$fxgl();
                    if (userAction == null) {
                        Intrinsics.throwNpe();
                    }
                    MouseButton mouseButton = e.getButton();
                    Intrinsics.checkExpressionValueIsNotNull((Object)mouseButton, "e.getButton()");
                    MouseEvent mouseEvent = e;
                    Intrinsics.checkExpressionValueIsNotNull(mouseEvent, "e");
                    boolean rebound = input.rebind(userAction, mouseButton, InputModifier.Companion.from(mouseEvent));
                    if (rebound) {
                        FXGLMenu.this.getController().popSubScene();
                    }
                }
            });
            Rectangle rect = new Rectangle(250.0, 100.0);
            rect.setStroke(Color.color(0.85, 0.9, 0.9, 0.95));
            rect.setStrokeWidth(10.0);
            rect.setArcWidth(15.0);
            rect.setArcHeight(15.0);
            Text text = FXGLUIConfig.getUIFactory().newText(Local.getLocalizedString("menu.pressAnyKey"), 24.0);
            StackPane pane = new StackPane(rect, text);
            pane.setTranslateX(FXGLForKtKt.getAppWidth() / 2 - 125);
            pane.setTranslateY(FXGLForKtKt.getAppHeight() / 2 - 50);
            this.getContentRoot().getChildren().add(pane);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u000fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/FXGLMenu$MenuContent;", "Ljavafx/scene/layout/VBox;", "items", "", "Ljavafx/scene/Node;", "([Ljavafx/scene/Node;)V", "maxW", "", "getMaxW", "()I", "setMaxW", "(I)V", "onClose", "Ljava/lang/Runnable;", "onOpen", "", "setOnClose", "onCloseAction", "setOnOpen", "onOpenAction", "fxgl"})
    public static final class MenuContent
    extends VBox {
        private Runnable onOpen;
        private Runnable onClose;
        private int maxW;

        public final int getMaxW() {
            return this.maxW;
        }

        public final void setMaxW(int n) {
            this.maxW = n;
        }

        public final void setOnOpen(@NotNull Runnable onOpenAction) {
            Intrinsics.checkParameterIsNotNull(onOpenAction, "onOpenAction");
            this.onOpen = onOpenAction;
        }

        public final void setOnClose(@NotNull Runnable onCloseAction) {
            Intrinsics.checkParameterIsNotNull(onCloseAction, "onCloseAction");
            this.onClose = onCloseAction;
        }

        private final void onOpen() {
            if (this.onOpen != null) {
                Runnable runnable = this.onOpen;
                if (runnable == null) {
                    Intrinsics.throwNpe();
                }
                runnable.run();
            }
        }

        private final void onClose() {
            if (this.onClose != null) {
                Runnable runnable = this.onClose;
                if (runnable == null) {
                    Intrinsics.throwNpe();
                }
                runnable.run();
            }
        }

        public MenuContent(Node ... items) {
            Node[] nodeArray;
            Intrinsics.checkParameterIsNotNull(items, "items");
            Node[] nodeArray2 = nodeArray = items;
            if (!(nodeArray2.length == 0)) {
                Bounds bounds = items[0].getLayoutBounds();
                Intrinsics.checkExpressionValueIsNotNull(bounds, "items[0].layoutBounds");
                this.maxW = (int)bounds.getWidth();
                for (Node n : items) {
                    Bounds bounds2 = n.getLayoutBounds();
                    Intrinsics.checkExpressionValueIsNotNull(bounds2, "n.layoutBounds");
                    int w = (int)bounds2.getWidth();
                    if (w <= this.maxW) continue;
                    this.maxW = w;
                }
                for (Node item : items) {
                    this.getChildren().addAll((Node[])new Node[]{item});
                }
            }
            this.sceneProperty().addListener(new ChangeListener<Scene>(){

                @Override
                public final void changed(ObservableValue<? extends Scene> o, Scene oldScene, Scene newScene) {
                    if (newScene != null) {
                        this.onOpen();
                    } else {
                        this.onClose();
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/FXGLMenu$Companion;", "", "()V", "log", "Lcom/almasb/sslogger/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

