/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.app.FXGLIntroScene;
import com.almasb.fxgl.app.IntroScene;
import com.almasb.fxgl.core.collection.ObjectMap;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.math.Vec2;
import com.almasb.fxgl.core.util.Consumer;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.particle.Particle;
import com.almasb.fxgl.particle.ParticleEmitter;
import com.almasb.fxgl.particle.ParticleEmitters;
import com.almasb.fxgl.particle.ParticleSystem;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.Glow;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0014J\b\u0010\u001b\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/app/FXGLIntroScene;", "Lcom/almasb/fxgl/app/IntroScene;", "()V", "animation", "Ljavafx/animation/Transition;", "h", "", "indices", "Lcom/almasb/fxgl/core/collection/ObjectMap;", "Lcom/almasb/fxgl/particle/Particle;", "particleSystem", "Lcom/almasb/fxgl/particle/ParticleSystem;", "w", "initEmitter", "Lcom/almasb/fxgl/particle/ParticleEmitter;", "kotlin.jvm.PlatformType", "makeLetter", "Ljavafx/scene/text/Text;", "letter", "", "makeLine", "Ljavafx/scene/shape/Rectangle;", "width", "height", "onUpdate", "", "tpf", "startIntro", "fxgl"})
public final class FXGLIntroScene
extends IntroScene {
    private final double w = FXGL.Companion.getAppWidth();
    private final double h = FXGL.Companion.getAppHeight();
    private final Transition animation;
    private final ParticleSystem particleSystem = new ParticleSystem();
    private final ObjectMap<Particle, Double> indices = new ObjectMap();

    private final ParticleEmitter initEmitter() {
        ParticleEmitter particleEmitter;
        ParticleEmitter $receiver = particleEmitter = ParticleEmitters.newFireEmitter();
        boolean bl = false;
        $receiver.setAllowParticleRotation(true);
        $receiver.setBlendMode(BlendMode.SRC_OVER);
        $receiver.setVelocityFunction(initEmitter.1.1.INSTANCE);
        $receiver.setSourceImage(FXGL.Companion.texture("particles/explosion.png", 32.0, 32.0).brighter().brighter().saturate().getImage());
        $receiver.setSize(1.5, 8.5);
        $receiver.setNumParticles(15);
        $receiver.setEmissionRate(1.0);
        $receiver.setExpireFunction(initEmitter.1.2.INSTANCE);
        $receiver.setControl(new Consumer<Particle>(this){
            final /* synthetic */ FXGLIntroScene this$0;
            {
                this.this$0 = fXGLIntroScene;
            }

            public final void accept(Particle p) {
                Double index = FXGLIntroScene.access$getIndices$p(this.this$0).get(p, FXGLMath.random(0.001, 3.05));
                FXGLIntroScene.access$getIndices$p(this.this$0).put(p, index);
                double x = p.position.x;
                double y = p.position.y;
                double d = x / (double)300;
                double d2 = y / (double)300;
                double d3 = 1.0 - p.life;
                Double d4 = index;
                Intrinsics.checkExpressionValueIsNotNull(d4, "index");
                double noiseValue = FXGLMath.noise3D(d, d2, d3 * d4);
                double angle = FXGLMath.toDegrees((noiseValue + 1.0) * Math.PI * 1.5);
                angle %= 360.0;
                if (FXGLMath.randomBoolean(0.35)) {
                    angle = FXGLMath.map(angle, 0.0, 360.0, -100.0, 50.0);
                }
                Vec2 v = Vec2.fromAngle(angle).normalizeLocal().mulLocal(FXGLMath.random(0.05, 0.35));
                p.acceleration.set(v);
            }
        });
        return particleEmitter;
    }

    private final Text makeLetter(String letter) {
        Text text;
        Text $receiver = text = new Text(letter);
        boolean bl = false;
        $receiver.setFont(FXGL.Companion.getUIFactory().newFont(122.0));
        $receiver.setFill(Color.color(0.9, 0.95, 0.96));
        $receiver.setTranslateY(this.h / (double)2 - (double)150);
        $receiver.setOpacity(0.96);
        $receiver.setEffect(new Glow(0.35));
        $receiver.setStroke(Color.DARKBLUE);
        $receiver.setStrokeWidth(3.5);
        return text;
    }

    private final Rectangle makeLine(double width, double height) {
        Rectangle rectangle;
        Rectangle $receiver = rectangle = new Rectangle(10.0, 0.0, Color.color(0.9, 0.95, 0.96));
        boolean bl = false;
        $receiver.setStroke(Color.DARKBLUE);
        $receiver.setArcWidth(15.0);
        $receiver.setArcHeight(15.0);
        $receiver.setStrokeWidth(4.0);
        $receiver.setOpacity(0.0);
        $receiver.setTranslateX(width);
        $receiver.setTranslateY(height);
        return rectangle;
    }

    @Override
    protected void onUpdate(double tpf) {
        super.onUpdate(tpf);
        this.particleSystem.onUpdate(tpf);
    }

    @Override
    public void startIntro() {
        this.animation.play();
    }

    public FXGLIntroScene() {
        ParticleEmitter emitter = this.initEmitter();
        this.particleSystem.getPane().setEffect(new GaussianBlur(3.0));
        ParticleEmitter particleEmitter = emitter;
        Intrinsics.checkExpressionValueIsNotNull(particleEmitter, "emitter");
        this.particleSystem.addParticleEmitter(particleEmitter, -50.0, this.h + 50.0);
        Text f = this.makeLetter("F");
        Text x = this.makeLetter("X");
        Text g = this.makeLetter("G");
        Text l = this.makeLetter("L");
        Rectangle line = this.makeLine(this.w / (double)2 - (double)25, 245.0);
        Rectangle line2 = this.makeLine(this.w / (double)2 + (double)25, 245.0);
        double d = this.w / (double)2;
        Bounds bounds = f.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull(bounds, "f.layoutBounds");
        double originX = d - bounds.getWidth() * (double)4 / (double)2;
        Bounds bounds2 = f.getLayoutBounds();
        Intrinsics.checkExpressionValueIsNotNull(bounds2, "f.layoutBounds");
        double dx = bounds2.getWidth();
        TranslateTransition f1 = new TranslateTransition(Duration.seconds(0.66), f);
        f1.setFromX(-100.0);
        f1.setToX(originX);
        f1.setInterpolator(Interpolators.EXPONENTIAL.EASE_OUT());
        TranslateTransition f2 = new TranslateTransition(Duration.seconds(1.0), x);
        f2.setFromX(-100.0);
        f2.setToX(originX + dx);
        f2.setInterpolator(Interpolators.ELASTIC.EASE_OUT());
        TranslateTransition f3 = new TranslateTransition(Duration.seconds(1.13), g);
        f3.setFromX(-100.0);
        f3.setToX(originX + dx * (double)2);
        f3.setInterpolator(Interpolators.BOUNCE.EASE_OUT());
        TranslateTransition f4 = new TranslateTransition(Duration.seconds(0.66), l);
        f4.setFromX(-100.0);
        f4.setToX(originX + dx * 3.2);
        f4.setInterpolator(Interpolators.BACK.EASE_OUT());
        Timeline t = new Timeline();
        t.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.seconds(1.0), new KeyValue(line.opacityProperty(), 1.0)), new KeyFrame(Duration.seconds(1.0), new KeyValue(line2.opacityProperty(), 1.0)), new KeyFrame(Duration.seconds(1.0), new KeyValue(line.heightProperty(), 100.0)), new KeyFrame(Duration.seconds(1.0), new KeyValue(line2.heightProperty(), 100.0))});
        this.animation = new SequentialTransition(f1, f2, f3, f4, t);
        this.animation.setOnFinished(new EventHandler<ActionEvent>(){

            @Override
            public final void handle(ActionEvent it) {
                FadeTransition t2 = new FadeTransition(Duration.seconds(1.2), this.getContentRoot());
                t2.setFromValue(1.0);
                t2.setToValue(0.5);
                t2.setOnFinished(new EventHandler<ActionEvent>(){

                    @Override
                    public final void handle(ActionEvent it) {
                        this.finishIntro();
                    }
                });
                t2.play();
            }
        });
        this.getContentRoot().getChildren().addAll((Node[])new Node[]{new Rectangle(this.w, this.h), new Group(f, x, g, l), line, line2, this.particleSystem.getPane()});
    }

    public static final /* synthetic */ ObjectMap access$getIndices$p(FXGLIntroScene $this) {
        return $this.indices;
    }
}

