/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.core.math.FXGLMath;
import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/almasb/fxgl/animation/AnimatedColor;", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Ljavafx/scene/paint/Color;", "from", "to", "(Ljavafx/scene/paint/Color;Ljavafx/scene/paint/Color;)V", "animate", "val1", "val2", "progress", "", "interpolator", "Ljavafx/animation/Interpolator;", "fxgl-animation"})
public final class AnimatedColor
extends AnimatedValue<Color> {
    @Override
    @NotNull
    public Color animate(@NotNull Color val1, @NotNull Color val2, double progress, @NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull(val1, "val1");
        Intrinsics.checkParameterIsNotNull(val2, "val2");
        Intrinsics.checkParameterIsNotNull(interpolator, "interpolator");
        Color color = Color.color(FXGLMath.interpolate(val1.getRed(), val2.getRed(), progress, interpolator), FXGLMath.interpolate(val1.getGreen(), val2.getGreen(), progress, interpolator), FXGLMath.interpolate(val1.getBlue(), val2.getBlue(), progress, interpolator), FXGLMath.interpolate(val1.getOpacity(), val2.getOpacity(), progress, interpolator));
        Intrinsics.checkExpressionValueIsNotNull(color, "Color.color(\n           \u2026, interpolator)\n        )");
        return color;
    }

    public AnimatedColor(@NotNull Color from, @NotNull Color to) {
        Intrinsics.checkParameterIsNotNull(from, "from");
        Intrinsics.checkParameterIsNotNull(to, "to");
        super(from, to);
    }
}

