/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.achievement;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.achievement.AchievementEvent;
import com.almasb.fxgl.achievement.AchievementProgressEvent;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.PropertyChangeListener;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.event.EventBus;
import com.almasb.sslogger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/almasb/fxgl/achievement/AchievementManager;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "achievements", "", "Lcom/almasb/fxgl/achievement/Achievement;", "achievementsCopy", "", "getAchievementsCopy", "()Ljava/util/List;", "achievementsFromSettings", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "log", "Lcom/almasb/sslogger/Logger;", "bindToVars", "", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "bindToVars$fxgl_achievement", "getAchievementByName", "name", "", "onExit", "onGameReady", "onMainLoopStarting", "onUpdate", "tpf", "", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "registerAchievement", "a", "registerAchievement$fxgl_achievement", "write", "fxgl-achievement"})
public final class AchievementManager
implements EngineService {
    private final Logger log = Logger.Companion.get(this.getClass());
    @Inject(value="achievements")
    private List<Achievement> achievementsFromSettings;
    @Inject(value="eventBus")
    private EventBus eventBus;
    private final List<Achievement> achievements;

    @NotNull
    public final List<Achievement> getAchievementsCopy() {
        List<Achievement> list = Collections.unmodifiableList(this.achievements);
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.unmodifiableList(achievements)");
        return list;
    }

    @NotNull
    public final Achievement getAchievementByName(@NotNull String name) {
        Object v0;
        block2: {
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(name, "name");
            Iterable iterable2 = iterable = (Iterable)this.achievements;
            for (Object t : iterable2) {
                Achievement it = (Achievement)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Achievement achievement = v0;
        if (achievement == null) {
            throw (Throwable)new IllegalArgumentException("Achievement with name [" + name + "] is not registered!");
        }
        return achievement;
    }

    public final void registerAchievement$fxgl_achievement(@NotNull Achievement a) {
        boolean bl;
        block4: {
            boolean bl2;
            Intrinsics.checkParameterIsNotNull(a, "a");
            Iterable $receiver$iv = this.achievements;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Achievement it = (Achievement)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it.getName(), a.getName())) continue;
                    bl2 = false;
                    break block4;
                }
                bl2 = bl = true;
            }
        }
        if (!bl) {
            boolean bl4 = false;
            String string = "Achievement with name [" + a.getName() + "] exists";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.achievements.add(a);
        this.log.debug("Registered new achievement: " + a.getName());
    }

    @Override
    public void onMainLoopStarting() {
        List<Achievement> list = this.achievementsFromSettings;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("achievementsFromSettings");
        }
        Iterable $receiver$iv = list;
        for (Object element$iv : $receiver$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            this.registerAchievement$fxgl_achievement(it);
        }
    }

    @Override
    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkParameterIsNotNull(vars, "vars");
        this.bindToVars$fxgl_achievement(vars);
    }

    /*
     * WARNING - void declaration
     */
    public final void bindToVars$fxgl_achievement(@NotNull PropertyMap vars) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(vars, "vars");
        Iterable $receiver$iv = this.achievements;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Achievement it = (Achievement)element$iv$iv;
            boolean bl2 = false;
            if (!(!it.isAchieved())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Ref.ObjectRef listener2;
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            if (!vars.exists(it.getVarName())) {
                this.log.warning("Achievement " + it.getName() + " cannot find property " + it.getVarName());
                continue;
            }
            Object object = it.getVarValue();
            if (object instanceof Integer) {
                Ref.ObjectRef bl2 = new Ref.ObjectRef();
                bl2.element = null;
                listener2.element = new PropertyChangeListener<Integer>(it, listener2, this, vars){
                    private boolean halfReached;
                    final /* synthetic */ Achievement $it;
                    final /* synthetic */ Ref.ObjectRef $listener;
                    final /* synthetic */ AchievementManager this$0;
                    final /* synthetic */ PropertyMap $vars$inlined;
                    {
                        this.$it = $captured_local_variable$1;
                        this.$listener = $captured_local_variable$2;
                        this.this$0 = achievementManager;
                        this.$vars$inlined = propertyMap;
                    }

                    public final boolean getHalfReached() {
                        return this.halfReached;
                    }

                    public final void setHalfReached(boolean bl) {
                        this.halfReached = bl;
                    }

                    public void onChange(int prev, int now) {
                        if (!this.halfReached && now >= ((Number)this.$it.getVarValue()).intValue() / 2) {
                            this.halfReached = true;
                            AchievementManager.access$getEventBus$p(this.this$0).fireEvent(new AchievementProgressEvent(this.$it, now, ((Number)this.$it.getVarValue()).intValue()));
                        }
                        if (Intrinsics.compare(now, ((Number)this.$it.getVarValue()).intValue()) >= 0) {
                            this.$it.setAchieved$fxgl_achievement();
                            AchievementManager.access$getEventBus$p(this.this$0).fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$it));
                            String string = this.$it.getVarName();
                            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                            if (propertyChangeListener == null) {
                                Intrinsics.throwNpe();
                            }
                            this.$vars$inlined.removeListener(string, propertyChangeListener);
                        }
                    }
                };
                vars.addListener(it.getVarName(), (PropertyChangeListener)listener2.element);
                continue;
            }
            if (object instanceof Double) {
                listener2 = new Ref.ObjectRef();
                listener2.element = null;
                listener2.element = new PropertyChangeListener<Double>(it, listener2, this, vars){
                    private boolean halfReached;
                    final /* synthetic */ Achievement $it;
                    final /* synthetic */ Ref.ObjectRef $listener;
                    final /* synthetic */ AchievementManager this$0;
                    final /* synthetic */ PropertyMap $vars$inlined;
                    {
                        this.$it = $captured_local_variable$1;
                        this.$listener = $captured_local_variable$2;
                        this.this$0 = achievementManager;
                        this.$vars$inlined = propertyMap;
                    }

                    public final boolean getHalfReached() {
                        return this.halfReached;
                    }

                    public final void setHalfReached(boolean bl) {
                        this.halfReached = bl;
                    }

                    public void onChange(double prev, double now) {
                        if (!this.halfReached && now >= ((Number)this.$it.getVarValue()).doubleValue() / (double)2) {
                            this.halfReached = true;
                            AchievementManager.access$getEventBus$p(this.this$0).fireEvent(new AchievementProgressEvent(this.$it, now, ((Number)this.$it.getVarValue()).doubleValue()));
                        }
                        if (Double.compare(now, ((Number)this.$it.getVarValue()).doubleValue()) >= 0) {
                            this.$it.setAchieved$fxgl_achievement();
                            AchievementManager.access$getEventBus$p(this.this$0).fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$it));
                            String string = this.$it.getVarName();
                            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                            if (propertyChangeListener == null) {
                                Intrinsics.throwNpe();
                            }
                            this.$vars$inlined.removeListener(string, propertyChangeListener);
                        }
                    }
                };
                vars.addListener(it.getVarName(), (PropertyChangeListener)listener2.element);
                continue;
            }
            if (object instanceof Boolean) {
                listener2 = new Ref.ObjectRef();
                listener2.element = null;
                listener2.element = new PropertyChangeListener<Boolean>(it, listener2, this, vars){
                    final /* synthetic */ Achievement $it;
                    final /* synthetic */ Ref.ObjectRef $listener;
                    final /* synthetic */ AchievementManager this$0;
                    final /* synthetic */ PropertyMap $vars$inlined;
                    {
                        this.$it = $captured_local_variable$1;
                        this.$listener = $captured_local_variable$2;
                        this.this$0 = achievementManager;
                        this.$vars$inlined = propertyMap;
                    }

                    public void onChange(boolean prev, boolean now) {
                        if (now) {
                            this.$it.setAchieved$fxgl_achievement();
                            AchievementManager.access$getEventBus$p(this.this$0).fireEvent(new AchievementEvent(AchievementEvent.ACHIEVED, this.$it));
                            String string = this.$it.getVarName();
                            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                            if (propertyChangeListener == null) {
                                Intrinsics.throwNpe();
                            }
                            this.$vars$inlined.removeListener(string, propertyChangeListener);
                        }
                    }
                };
                vars.addListener(it.getVarName(), (PropertyChangeListener)listener2.element);
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Unknown value type for achievement: " + it.getVarValue());
        }
    }

    @Override
    public void onExit() {
    }

    @Override
    public void onUpdate(double tpf) {
    }

    @Override
    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull(bundle, "bundle");
        Iterable $receiver$iv = this.achievements;
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            bundle.put(a.getName(), Boolean.valueOf(a.isAchieved()));
        }
    }

    @Override
    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull(bundle, "bundle");
        Iterable $receiver$iv = this.achievements;
        for (Object element$iv : $receiver$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            boolean achieved = (Boolean)bundle.get(a.getName());
            if (!achieved) continue;
            a.setAchieved$fxgl_achievement();
        }
    }

    public AchievementManager() {
        List list;
        AchievementManager achievementManager = this;
        achievementManager.achievements = list = (List)new ArrayList();
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(AchievementManager $this) {
        EventBus eventBus2 = $this.eventBus;
        if (eventBus2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("eventBus");
        }
        return eventBus2;
    }

    public static final /* synthetic */ void access$setEventBus$p(AchievementManager $this, EventBus eventBus2) {
        $this.eventBus = eventBus2;
    }
}

